/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.factory;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.ServerTaskHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.ibecorp.model.booking.HotelBookingCreateParametersPane;
import com.gridnine.xtrip.client.fx.ibecorp.model.booking.HotelBookingCreateParametersPaneController;
import com.gridnine.xtrip.client.fx.ibecorp.model.booking.HotelBookingCreateParametersPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileCreateParametersPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.standard.factory.basic.StandardHotelCreateProcedure;
import com.gridnine.xtrip.client.fx.standard.helpers.CreateBookingHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.CreateBookingHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.ibecorp.rpc.RpcBookingFileRef;
import com.gridnine.xtrip.common.fx.ibecorp.rpc.model.FxRpcImportHotelBookingFileParameters;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.WorkflowStatus;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.scene.Node;

public class IbecorpHotelCreateProcedure
extends StandardHotelCreateProcedure {
    public void run() {
        HotelBookingCreateParametersPaneController parametersController = new HotelBookingCreateParametersPaneController(false);
        final HotelBookingCreateParametersPane pane = parametersController.getView();
        new Dialog().setTitle("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u043e\u0433\u043e \u0437\u0430\u043a\u0430\u0437\u0430").setBody((Node)parametersController.getView()).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, "\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u0437\u0430\u043a\u0430\u0437", () -> {
            HotelBookingCreateParametersPaneVM parameters = new HotelBookingCreateParametersPaneVM();
            parametersController.writeData(parameters);
            List handlers = CreateBookingHelper.getCreateBookingHandlers();
            if (parameters.isDoImport()) {
                Notifications.get().enqueueAsyncTask((ServerTaskHandler)new ImportHotelBookingFileTaskHandler(parameters));
            } else {
                Notifications.get().submitTask(() -> this.createBookingFile(parameters, handlers), "\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u043e\u0433\u043e \u0437\u0430\u043a\u0430\u0437\u0430");
            }
        }, (BooleanExpression)new BooleanBinding(){
            {
                this.bind(new Observable[]{pane.getAgentNode().valueProperty(), pane.getAgencyNode().valueProperty(), pane.getSubagencyNode().valueProperty(), pane.getClientNode().valueProperty(), pane.getDoImportNode().selectedProperty(), pane.getGdsAccountNode().valueProperty(), pane.getHotelProviderNode().valueProperty(), pane.getImportByNumberNode().valueProperty(), pane.getOrderNumberNode().valueProperty(), pane.getOrdersDateNode().getDateFromNode().valueProperty(), pane.getOrdersDateNode().getDateToNode().valueProperty()});
            }

            protected boolean computeValue() {
                if (pane.getAgentNode().getValue() == null || pane.getAgencyNode().getValue() == null || pane.getClientNode().getValue() == null) {
                    return false;
                }
                if (!pane.getDoImportNode().isSelected()) {
                    return true;
                }
                return pane.getGdsAccountNode().getValue() != null && pane.getHotelProviderNode().getValue() != null && ((Boolean)pane.getImportByNumberNode().valueProperty().getValue() != false && !TextUtil.isBlank((String)pane.getOrderNumberNode().getValue()) || (Boolean)pane.getImportByNumberNode().valueProperty().getValue() == false && pane.getOrdersDateNode().getDateFromNode().getValue() != null && pane.getOrdersDateNode().getDateToNode().getValue() != null);
            }
        }).showGlobal();
    }

    private void createBookingFile(HotelBookingCreateParametersPaneVM parameters, List<CreateBookingHandler> handlers) throws Exception {
        BookingFile bf = new BookingFile();
        BookingFileUIData uiData = new BookingFileUIData();
        for (CreateBookingHandler createBookingHandler : handlers) {
            createBookingHandler.onCreateBegin(bf, uiData, (BookingFileCreateParametersPaneVM)parameters);
        }
        AgentData agentData = Prefetched.getData().getCurrentAgentData();
        agentData.setSalesPoint(parameters.getSalesPoint());
        this.onCreate(bf, uiData, (BookingFileCreateParametersPaneVM)parameters);
        for (CreateBookingHandler handler : handlers) {
            handler.onCreateEnd(bf, uiData, (BookingFileCreateParametersPaneVM)parameters);
        }
        DataTransferPackage dataTransferPackage = new DataTransferPackage(EntityContainer.create((BaseEntity)bf), (Object)uiData);
        FxUtil.submitToFxThread(() -> CreateBookingHelper.navigateTo((DataTransferPackage)dtp));
    }

    private static class ImportHotelBookingFileTaskHandler
    extends ServerTaskHandler {
        private final HotelBookingCreateParametersPaneVM parameters;
        private String title = "\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u043e\u0433\u043e \u0437\u0430\u043a\u0430\u0437\u0430";

        ImportHotelBookingFileTaskHandler(HotelBookingCreateParametersPaneVM parameters) {
            this.parameters = parameters;
        }

        protected String getTaskClassName() {
            return "com.gridnine.xtrip.server.fx.ibecorp.async.ImportHotelAsyncTask";
        }

        protected String getTitle() {
            return this.title;
        }

        protected Serializable getTaskParameters() {
            FxRpcImportHotelBookingFileParameters params = new FxRpcImportHotelBookingFileParameters();
            if (this.parameters.isImportByNumber()) {
                String orderNumber = this.parameters.getOrderNumber().replaceAll("/", "").trim();
                params.setOrderNumber(orderNumber);
            } else {
                params.setDateFrom(this.parameters.getOrdersDate().getDateFrom());
                params.setDateTo(this.parameters.getOrdersDate().getDateTo());
            }
            params.setAgent(this.parameters.getAgent());
            params.setAgency(this.parameters.getAgency());
            params.setSubagency(this.parameters.getSubagency());
            params.setClient(this.parameters.getClient());
            params.setSalesPoint(this.parameters.getSalesPoint());
            params.setGdsAccount(this.parameters.getGdsAccount());
            params.setHotelProvider(this.parameters.getHotelProvider());
            params.setImportByNumber(this.parameters.isImportByNumber());
            params.setDateFrom(this.parameters.getOrdersDate().getDateFrom());
            params.setDateTo(this.parameters.getOrdersDate().getDateTo());
            return params;
        }

        protected void onCompleted(Object result, List<Message> log) {
            if (result == null) {
                return;
            }
            RpcBookingFileRef rpcResult = (RpcBookingFileRef)result;
            EntityReference bookingFileRef = rpcResult.getBookingFileRef();
            boolean yetExists = log.stream().map(mes -> mes.getMessage().getKey()).anyMatch("HOTELS2_BOOKING_FILE_FOUND_IN_MOM"::equals);
            if (yetExists) {
                this.title = "\u0417\u0430\u043a\u0430\u0437 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u041c\u0438\u0434\u043e\u0444\u0438\u0441\u0435";
            } else {
                L10nResourcesManager l10nResourcesManager = LocaleManager.get().getL10nResourceManager();
                String errorText = log.stream().filter(mes -> mes.getType() == MessageType.ERROR).map(Message::getMessage).filter(Objects::nonNull).map(arg_0 -> ((L10nResourcesManager)l10nResourcesManager).getMessage(arg_0)).collect(Collectors.joining("\n"));
                if (TextUtil.nonBlank((String)errorText)) {
                    this.title = errorText;
                }
            }
            if (bookingFileRef != null) {
                FxUtil.submitToFxThread(() -> RootEntityEditingService.get().open(bookingFileRef, true, pane -> {
                    BookingFile booking = (BookingFile)pane.getData().getContainer().getEntity();
                    if (booking.getWorkflowStatus() == WorkflowStatus.ERROR) {
                        return;
                    }
                    BookingFileSpace bookingFileSpace = (BookingFileSpace)pane.getEditor();
                    bookingFileSpace.expand(bookingFileSpace.getProductsTile());
                    CompactNavigatorWidget navigatorWidget = (CompactNavigatorWidget)((BookingFileProductsFullPanel)bookingFileSpace.getProductsTile().getFullNode()).getContent();
                    if (navigatorWidget.getViews().size() > 0) {
                        Node node = (Node)navigatorWidget.getViews().get(0);
                        navigatorWidget.selectView(node);
                    }
                }));
            }
        }
    }
}

