/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.factory;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import com.gridnine.xtrip.client.fx.ibecorp.model.booking.RailKzBookingCreateParametersPane;
import com.gridnine.xtrip.client.fx.ibecorp.model.booking.RailKzBookingCreateParametersPaneController;
import com.gridnine.xtrip.client.fx.ibecorp.model.booking.RailKzBookingCreateParametersPaneVM;
import com.gridnine.xtrip.client.fx.standard.helpers.ListParametersHelper;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.gds.GdsAccountIndex;
import com.gridnine.xtrip.common.model.ibecorp.ImportKzBookingParameters;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.scene.Node;

public class IbecorpKzBookingCreateProcedure
implements Runnable {
    @Override
    public void run() {
        RailKzBookingCreateParametersPaneController paneController = new RailKzBookingCreateParametersPaneController(false);
        final RailKzBookingCreateParametersPane pane = paneController.getView();
        IndexListParameters<BaseGdsAccount, ?> gdsAccountsParams = this.getGdsAccounts();
        Notifications.get().submitTask(() -> {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().addAll(gdsAccountsParams.getSearchCriterions());
            query.getPreferredProperties().add(GdsAccountIndex.Property.name.name());
            List indexes = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(ServiceInvocationContext.get(), GdsAccountIndex.class, query);
            if (indexes.size() == 1) {
                FxUtil.submitToFxThread(() -> pane.getGdsAccountNode().setValue(((GdsAccountIndex)indexes.get(0)).getSource()));
            }
        }, "\u0417\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439");
        pane.getGdsAccountNode().setListParametersSupplier(() -> gdsAccountsParams);
        new Dialog().setTitle(Messages.IbeCorpKzImportBooking).setBody((Node)pane).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, () -> {
            RailKzBookingCreateParametersPaneVM vmParameters = new RailKzBookingCreateParametersPaneVM();
            paneController.writeData(vmParameters);
            Notifications.get().submitTask(() -> {
                HashMap<String, ImportKzBookingParameters> contextMap = new HashMap<String, ImportKzBookingParameters>();
                ImportKzBookingParameters taskParameters = new ImportKzBookingParameters();
                taskParameters.setOrderNumber(vmParameters.getOrderNumber());
                taskParameters.setGdsAccount(vmParameters.getGdsAccount());
                contextMap.put(IBusIbecorpContextKeys.IBECORP_IMPORT_KZ_BOOKING_PARAMS.name(), taskParameters);
                Set<String> returnKeys = Collections.singleton(IBusBookingContextKeys.BOOKING_REFERENCE.name());
                Map contextResult = ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processRouteSync(ServiceInvocationContext.get(), "railway:kz:sync-reservation:import-booking", contextMap, returnKeys);
                EntityReference bfReference = (EntityReference)contextResult.get(IBusBookingContextKeys.BOOKING_REFERENCE.name());
                if (bfReference != null) {
                    EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, new EntityModification(bfReference, EntityModification.ModificationType.CHANGE)));
                }
                RootEntityEditingService.navigateTo((EntityReference)bfReference);
            }, com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Data_loading);
        }, (BooleanExpression)new BooleanBinding(){
            {
                this.bind(new Observable[]{pane.getOrderNumberNode().valueProperty(), pane.getGdsAccountNode().valueProperty()});
            }

            protected boolean computeValue() {
                return pane.getGdsAccountNode().getValue() != null && !TextUtil.isBlank((String)pane.getOrderNumberNode().getValue());
            }
        }).showGlobal();
    }

    private IndexListParameters<BaseGdsAccount, ?> getGdsAccounts() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(GdsAccountIndex.class);
        result.getSearchCriterions().add(SearchCriterion.eq((String)GdsAccountIndex.Property.gds.name(), (Object)GdsName.RAIL_KZ));
        result.getSortings().put(GdsAccountIndex.Property.name.name(), SortOrder.DESC);
        ListParametersHelper.setColumns((IndexListParameters)result, (String[])new String[]{GdsAccountIndex.Property.name.name(), GdsAccountIndex.Property.agency.name()});
        return result;
    }
}

