/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.factory.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.ibecorp.model.booking.HotelBookingCreateParametersPane;
import com.gridnine.xtrip.client.fx.ibecorp.model.booking.HotelBookingCreateParametersPaneController;
import com.gridnine.xtrip.client.fx.ibecorp.model.booking.HotelBookingCreateParametersPaneVM;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ListParametersHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.client.fx.standard.worklog.Workplace;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.model.AgentSalesPoint;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductSettings;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProviderProfile;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.gds.GdsAccountIndex;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;

public class IbecorpHotelBookingCreateParametersPaneControllerInterceptor
extends ControllerInterceptor<HotelBookingCreateParametersPaneVM, HotelBookingCreateParametersPaneController> {
    protected Class<HotelBookingCreateParametersPaneController> getControllerClass() {
        return HotelBookingCreateParametersPaneController.class;
    }

    protected void onCreate(HotelBookingCreateParametersPaneController controller) {
        HotelBookingCreateParametersPane pane = controller.getView();
        AgentData agentData = Prefetched.getData().getCurrentAgentData();
        pane.getAgentNode().setValue(agentData.getAgent());
        pane.getAgentNode().setListParametersSupplier(this::getAgents);
        pane.getAgencyNode().setValue(agentData.getAgency());
        pane.getAgencyNode().setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        pane.getSubagencyNode().setValue(agentData.getSubagency());
        pane.getSubagencyNode().setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        pane.getClientNode().setListParametersSupplier(() -> this.getClients((EntityReference<Organization>)pane.getSubagencyNode().getValue()));
        List availableSalesPoints = agentData.getAvailableSalesPoints();
        pane.getSalesPointNode().setLive(true);
        pane.getSalesPointNode().setItemsSupplier(() -> this.getAgencySalesPoints(availableSalesPoints, (EntityReference<Organization>)pane.getAgencyNode().getValue()), true);
        if (Workplace.get().isWorklogEnabled()) {
            pane.getSalesPointNode().setValue(agentData.getSalesPoint());
        } else {
            pane.getSalesPointNode().setValue(this.getDefaultSalesPoint(agentData, (EntityReference<Organization>)agentData.getAgency()));
        }
        pane.getHotelProviderNode().setLive(false);
        pane.getHotelProviderNode().setAsync(true);
        pane.getHotelProviderNode().setItemsSupplier(this::getHotelProviders);
        pane.getGdsAccountNode().setListParametersSupplier(() -> this.getGdsAccounts((HotelProvider)pane.getHotelProviderNode().getValue()));
        pane.getImportByNumberNode().setConverter(Converters.boolConverter((String)"\u041d\u043e\u043c\u0435\u0440 \u0437\u0430\u043a\u0430\u0437\u0430", (String)"\u041f\u0435\u0440\u0438\u043e\u0434"));
        pane.getAgencyNode().valueProperty().addListener((observable, oldValue, newValue) -> {
            if (!MiscUtil.equals((Object)oldValue, (Object)newValue)) {
                pane.getSalesPointNode().setValue(this.getDefaultSalesPoint(agentData, (EntityReference<Organization>)newValue));
            }
        });
        pane.getHotelProviderNode().valueProperty().addListener((observable, oldValue, newValue) -> {
            if (!MiscUtil.equals((Object)oldValue, (Object)newValue)) {
                Notifications.get().submitTask(() -> {
                    Runnable setNullValueTask = () -> pane.getGdsAccountNode().setValue(null);
                    if (newValue == null) {
                        FxUtil.submitToFxThread((Runnable)setNullValueTask);
                    }
                    IndexListParameters<BaseGdsAccount, ?> gdsAccountsParams = this.getGdsAccounts((HotelProvider)newValue);
                    SearchQuery query = new SearchQuery();
                    query.getCriteria().getCriterions().addAll(gdsAccountsParams.getSearchCriterions());
                    query.getPreferredProperties().add(GdsAccountIndex.Property.name.name());
                    List indexes = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(ServiceInvocationContext.get(), GdsAccountIndex.class, query);
                    if (indexes.size() == 1) {
                        FxUtil.submitToFxThread(() -> pane.getGdsAccountNode().setValue(((GdsAccountIndex)indexes.get(0)).getSource()));
                    } else {
                        FxUtil.submitToFxThread((Runnable)setNullValueTask);
                    }
                }, "\u0417\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439");
            }
        });
        FxUtil.addListener((ObservableValue)pane.getDoImportNode().selectedProperty(), (s, o, newValue) -> {
            pane.getGdsAccountCell().setHidden(newValue == false);
            pane.getHotelProviderCell().setHidden(newValue == false);
            pane.getImportByNumberNode().setValue(true);
            pane.getImportByNumberCell().setHidden(newValue == false);
            FxUtil.addListener((ObservableValue)pane.getImportByNumberNode().valueProperty(), (s2, o2, newValue2) -> {
                pane.getOrderNumberCell().setHidden(newValue == false || newValue2 == false);
                pane.getOrdersDateCell().setHidden(newValue == false || newValue2 != false);
            });
        });
    }

    private List<EntityReference<SalesPoint>> getAgencySalesPoints(List<AgentSalesPoint> availableSalesPoints, EntityReference<Organization> agencyRef) {
        return availableSalesPoints.stream().filter(sp -> MiscUtil.equals((Object)sp.getAgency(), (Object)agencyRef)).map(AgentSalesPoint::getSalesPoint).collect(Collectors.toList());
    }

    private EntityReference<SalesPoint> getDefaultSalesPoint(AgentData agentData, EntityReference<Organization> agencyRef) {
        List defaultSalesPoints;
        List availableSalesPoints = agentData.getAvailableSalesPoints();
        List<EntityReference<SalesPoint>> agencySalesPoints = this.getAgencySalesPoints(availableSalesPoints, agencyRef);
        if (agencySalesPoints.contains(agentData.getSalesPoint())) {
            return agentData.getSalesPoint();
        }
        if (agencySalesPoints.size() == 1) {
            return agencySalesPoints.get(0);
        }
        if (agencySalesPoints.size() > 1 && (defaultSalesPoints = availableSalesPoints.stream().filter(sp -> agencySalesPoints.contains(sp.getSalesPoint())).filter(AgentSalesPoint::isDefaultForOrg).collect(Collectors.toList())).size() == 1) {
            return ((AgentSalesPoint)defaultSalesPoints.get(0)).getSalesPoint();
        }
        return null;
    }

    private IndexListParameters<Person, PersonIndex> getAgents() {
        IndexListParameters result = ControllerInterceptorsHelper.getAgents();
        result.getPatternSearchFields().add(PersonIndex.Property.name.name());
        result.getPatternSearchFields().add(PersonIndex.Property.loginName.name());
        return result;
    }

    private IndexListParameters<Organization, OrganizationIndex> getClients(EntityReference<Organization> agencyRef) {
        IndexListParameters result = ControllerInterceptorsHelper.getClients();
        if (agencyRef != null) {
            result.getSearchCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.supplierUids.name(), (Object)agencyRef.getUid()));
        }
        return result;
    }

    private List<HotelProvider> getHotelProviders() {
        try {
            EntityContainer settings = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), HotelProductHelper.HOTEL_PRODUCT_SETTINGS_REF);
            return ((HotelProductSettings)settings.getEntity()).getSuppliersMapping().stream().map(HotelProviderProfile::getProvider).distinct().collect(Collectors.toList());
        }
        catch (Exception e) {
            throw Xeption.forDeveloper((String)"getHotelProviders failed", (Throwable)e, (Object[])new Object[0]);
        }
    }

    private IndexListParameters<BaseGdsAccount, ?> getGdsAccounts(HotelProvider hotelProvider) {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(GdsAccountIndex.class);
        result.getSearchCriterions().add(SearchCriterion.eq((String)GdsAccountIndex.Property.gds.name(), (Object)GdsName.HOTEL_AGGREGATOR));
        result.getSearchCriterions().add(SearchCriterion.eq((String)GdsAccountIndex.Property.hotelProvider.name(), (Object)hotelProvider));
        result.getSortings().put(GdsAccountIndex.Property.name.name(), SortOrder.DESC);
        ListParametersHelper.setColumns((IndexListParameters)result, (String[])new String[]{GdsAccountIndex.Property.name.name(), GdsAccountIndex.Property.agency.name(), GdsAccountIndex.Property.hotelProvider.name()});
        return result;
    }
}

