/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.rules;

import com.gridnine.xtrip.client.fx.core.lib.components.tree.CustomCheckBoxTreeView;
import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.PopupWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.ibecorp.rpc.IbecorpModelService;
import com.gridnine.xtrip.common.model.ibecorp.AvailableReportsSettings;
import com.gridnine.xtrip.common.model.ibecorp.xreports.ReportGroup;
import com.gridnine.xtrip.common.model.ibecorp.xreports.ReportReference;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.BorderPane;

public class IbecorpAvailableReportsRenderer
implements NodeRenderer {
    public static final IbecorpAvailableReportsRenderer instance = new IbecorpAvailableReportsRenderer();
    public static final String ROOT_ELM_ID = "ROOT";

    public Node createNode(boolean readonly) {
        PopupWidget popup = new PopupWidget();
        popup.setInfoText(UiUtil.NULL_TEXT);
        ApplicableReportsNode viewNode = new ApplicableReportsNode();
        popup.setView((Node)viewNode);
        popup.setDialogConfigurator(d -> Notifications.get().submitTask(() -> {
            List reports = ((IbecorpModelService)((RpcServiceManager)Environment.getPublished(RpcServiceManager.class)).getService(IbecorpModelService.class)).getAllXreportsReportGroups((ServiceInvocationContext)Environment.getPublished(ServiceInvocationContext.class));
            viewNode.setAllReports(reports);
        }, (String)null));
        popup.setDialogCloseHandler(() -> popup.setInfoText(this.getInfoText(viewNode.getValue())));
        return popup;
    }

    private String getInfoText(AvailableReportsSettings value) {
        if (value == null || value.getSelectedReportsIds().isEmpty()) {
            return Messages.Not_set;
        }
        if (value.getSelectedReportsIds().contains(ROOT_ELM_ID)) {
            return Messages.All;
        }
        return Messages.Several_reports;
    }

    public Object getValue(Node node) {
        return ((ApplicableReportsNode)((PopupWidget)node).getView()).getValue();
    }

    public void setValue(Node node, Object value) {
        PopupWidget popup = (PopupWidget)node;
        ((ApplicableReportsNode)popup.getView()).setValue((AvailableReportsSettings)value);
        popup.setInfoText(this.getInfoText((AvailableReportsSettings)value));
    }

    public void setReadonly(boolean readonly, Node node) {
        ((ApplicableReportsNode)((PopupWidget)node).getView()).setReadonly(readonly);
    }

    static class ReportTreeNode {
        private String id;
        private String title;
        private final List<ReportTreeNode> children = new ArrayList<ReportTreeNode>();

        ReportTreeNode() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public List<ReportTreeNode> getChildren() {
            return this.children;
        }
    }

    static class ApplicableReportsTree
    extends CustomCheckBoxTreeView<ReportTreeNode> {
        public ApplicableReportsTree(ReportTreeNode root) {
            super((Object)root, true, Collections.emptyList());
            UiUtil.expand((TreeItem)this.getTreeView().getRoot());
        }

        protected List<ReportTreeNode> getNodeChildren(ReportTreeNode reportTreeNode) {
            return reportTreeNode.children;
        }

        protected String getNodeTitle(ReportTreeNode reportTreeNode) {
            return reportTreeNode.title;
        }

        protected String getNodeId(ReportTreeNode reportTreeNode) {
            return reportTreeNode.id;
        }

        protected Comparator<TreeItem<ReportTreeNode>> getComparator() {
            return Comparator.comparing(it -> {
                ReportTreeNode root = (ReportTreeNode)this.getTreeView().getRoot().getValue();
                int idx = root.getChildren().indexOf(it.getValue());
                if (idx != -1) {
                    return idx + "";
                }
                return ((ReportTreeNode)it.getValue()).getTitle();
            });
        }
    }

    static class ApplicableReportsNode
    extends BorderPane {
        private AvailableReportsSettings value = null;
        private List<ReportGroup> allReports = null;
        private Boolean readonly;
        private ApplicableReportsTree panel;
        private boolean initialized = false;

        ApplicableReportsNode() {
        }

        void setValue(AvailableReportsSettings value) {
            this.value = value == null ? new AvailableReportsSettings() : value;
            this.updateTree();
        }

        public void setReadonly(boolean readonly) {
            this.readonly = readonly;
            this.updateTree();
        }

        private void updateTree() {
            if (!this.initialized && this.value != null && this.allReports != null && this.readonly != null) {
                ReportTreeNode root = new ReportTreeNode();
                root.setId(IbecorpAvailableReportsRenderer.ROOT_ELM_ID);
                root.setTitle(Messages.All_reports);
                ArrayList<String> selectedUids = new ArrayList<String>();
                if (this.value.getSelectedReportsIds().contains(IbecorpAvailableReportsRenderer.ROOT_ELM_ID)) {
                    selectedUids.add(root.getId());
                }
                for (ReportGroup gr : this.allReports) {
                    ReportTreeNode groupNode = new ReportTreeNode();
                    groupNode.setId(gr.getUid());
                    groupNode.setTitle(gr.getTitle());
                    if (this.value.getSelectedReportsIds().contains(IbecorpAvailableReportsRenderer.ROOT_ELM_ID) || this.value.getSelectedReportsIds().contains(groupNode.getId())) {
                        selectedUids.add(groupNode.getId());
                    }
                    root.getChildren().add(groupNode);
                    for (ReportReference rep : gr.getReports()) {
                        ReportTreeNode reportNode = new ReportTreeNode();
                        reportNode.setId(rep.getUid());
                        reportNode.setTitle(rep.getTitle());
                        groupNode.getChildren().add(reportNode);
                        if (!this.value.getSelectedReportsIds().contains(IbecorpAvailableReportsRenderer.ROOT_ELM_ID) && !this.value.getSelectedReportsIds().contains(groupNode.getId()) && !this.value.getSelectedReportsIds().contains(reportNode.getId())) continue;
                        selectedUids.add(reportNode.getId());
                    }
                }
                FxUtil.submitToFxThread(() -> {
                    this.panel = new ApplicableReportsTree(root);
                    this.panel.setReadonly(this.readonly);
                    this.panel.setNodesSelection(selectedUids);
                    if (selectedUids.contains(IbecorpAvailableReportsRenderer.ROOT_ELM_ID)) {
                        this.panel.setRootSelected(true);
                    }
                    this.setCenter((Node)this.panel.getTreePane());
                });
                this.initialized = true;
            }
        }

        void setAllReports(List<ReportGroup> allReports) {
            this.allReports = allReports;
            this.updateTree();
        }

        AvailableReportsSettings getValue() {
            AvailableReportsSettings result = new AvailableReportsSettings();
            if (this.panel == null) {
                return this.value;
            }
            boolean hasUnselectedGroup = false;
            List selectedItemsIds = this.panel.getSelectedItemsIds();
            for (ReportGroup group : this.allReports) {
                boolean hasUnselectedReports = group.getReports().isEmpty();
                ArrayList<String> selectedReports = new ArrayList<String>();
                for (ReportReference rep : group.getReports()) {
                    if (selectedItemsIds.contains(rep.getUid())) {
                        selectedReports.add(rep.getUid());
                        continue;
                    }
                    hasUnselectedReports = true;
                }
                if (hasUnselectedReports) {
                    hasUnselectedGroup = true;
                    result.getSelectedReportsIds().addAll(selectedReports);
                    continue;
                }
                result.getSelectedReportsIds().add(group.getUid());
            }
            if (!hasUnselectedGroup) {
                result.getSelectedReportsIds().clear();
                result.getSelectedReportsIds().add(IbecorpAvailableReportsRenderer.ROOT_ELM_ID);
            }
            return result;
        }
    }
}

