/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp;

import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.ibecorp.IbeCorpSalesContextHandler;
import com.gridnine.xtrip.common.ibecorp.rules.AirPropertySet;
import com.gridnine.xtrip.common.ibecorp.rules.IbecorpActionSet;
import com.gridnine.xtrip.common.ibecorp.rules.Targets;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang.BooleanUtils;

public class AirAllowingHelper {
    public static boolean isReservationValidForUnsell(Reservation reservation) {
        return reservation != null && CommonIbecorpHelper.getReservationStatus(reservation) == ReservationStatus.ISSUED && reservation.getGdsNameInfo().getOnlineGdsAccount() != null;
    }

    public static IbecorpActionSet getReservationCancelVoidTargetPermissions(SalesContext salesContext, Reservation reservation) throws Exception {
        RuleProxy<Object, IbecorpActionSet> proxy = AirAllowingHelper.createdRuleProxy(Targets.RESERVATIONS_CANCEL_TICKETS_VOIDING);
        if (Objects.nonNull(reservation)) {
            proxy.setPropertySet((Object)new AirPropertySet(reservation));
        }
        IbecorpActionSet result = new IbecorpActionSet();
        ReservationStatus status = reservation.getStatus();
        if (status == ReservationStatus.IN_PROCESS_OF_TICKETING) {
            result.setReservationCancelPermitted(false);
        }
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)AirAllowingHelper.getRules(salesContext));
        return (IbecorpActionSet)proxy.getActionSet();
    }

    public static boolean getTicketExchangePermissions(SalesContext salesContext, Reservation reservation) throws Exception {
        RuleProxy<Object, IbecorpActionSet> proxy = AirAllowingHelper.createdRuleProxy(Targets.TICKETS_EXCHANGE);
        if (Objects.nonNull(reservation)) {
            proxy.setPropertySet((Object)new AirPropertySet(reservation));
        }
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)AirAllowingHelper.getRules(salesContext));
        Boolean ticketExchangePermitted = ((IbecorpActionSet)proxy.getActionSet()).isTicketExchangePermitted();
        return BooleanUtils.isTrue((Boolean)ticketExchangePermitted);
    }

    private static RuleSet getRules(SalesContext salesContext) {
        IbeCorpSalesContextHandler handler = (IbeCorpSalesContextHandler)SalesContextHandler.get();
        return handler.getRules(salesContext);
    }

    private static RuleProxy<Object, IbecorpActionSet> createdRuleProxy(Targets target) {
        RuleProxy proxy = new RuleProxy();
        proxy.setActionSet((Object)new IbecorpActionSet());
        proxy.setProxyType(target.getId());
        proxy.setProxyDate(new Date());
        return proxy;
    }
}

