/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp;

import com.gridnine.xtrip.common.gds.model.GdsCommission;
import com.gridnine.xtrip.common.gds.model.GdsContractRelationData;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MulticurrencyHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMCurrencyDisplaySettings;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.ExchangeRateCondition;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class CurrencyHelper {
    private static final boolean ALLOW_REVERSE_RATE = true;

    public static String getSystem() {
        return DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, null);
    }

    public static String getClientCurrencyForCurrentSubagent(EntityReference<Organization> subagencyRef, EntityReference<Organization> clientRef) {
        return CurrencyHelper.getCurrency(subagencyRef, clientRef, ContractType.CLIENT);
    }

    public static String getSubagentCurrencyForSubagent(EntityReference<Organization> agencyRef, EntityReference<Organization> subagencyRef) {
        return CurrencyHelper.getCurrency(agencyRef, subagencyRef, ContractType.SUBAGENCY);
    }

    public static String getCurrency(EntityReference<Organization> supplierRef, EntityReference<Organization> customerRef, ContractType contractType) {
        try {
            List<Contract> contracts = CommonIbecorpHelper.getContracts(supplierRef, customerRef, contractType);
            for (Contract contract : contracts) {
                if (contract.getPaymentCurrency() != null) {
                    return contract.getPaymentCurrency();
                }
                for (ContractCustomerInfo customer : contract.getCustomers()) {
                    if (!Objects.equals(customerRef, customer.getCustomer()) || customer.getPaymentCurrency() == null) continue;
                    return customer.getPaymentCurrency();
                }
            }
        }
        catch (Exception e) {
            return CurrencyHelper.getSystem();
        }
        return CurrencyHelper.getSystem();
    }

    public static <T extends BaseCommission, R extends BaseContractRelationData> BigDecimal exchange(Collection<T> commissions, String targetCurrency, Collection<R> contractRelationsData, boolean air) {
        return commissions.stream().map(c -> CurrencyHelper.exchange(c, targetCurrency, contractRelationsData, air)).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public static <T extends BaseCommission, R extends BaseContractRelationData> BigDecimal exchange(T commission, String clientCurrency, Collection<R> contractRelationsData, boolean air) {
        BigDecimal result = null;
        R contractRelationData = CurrencyHelper.getCommissionContractRelationData(commission, contractRelationsData);
        String commissionContractCurrency = CurrencyHelper.getCommissionContractCurrency(commission, Collections.singletonList(contractRelationData));
        if (commission.getEquivalentAmount() != null) {
            if (commissionContractCurrency != null && contractRelationData != null && !commissionContractCurrency.equals(clientCurrency)) {
                R clientContractRelationData = CurrencyHelper.getClientContractRelationData(contractRelationsData);
                ExchangeRateData rateData = CurrencyHelper.getExchangeRateData(commissionContractCurrency, clientContractRelationData, air);
                result = RulesHelper.convert((BigDecimal)commission.getEquivalentAmount(), (ExchangeRateData)rateData);
            } else {
                result = commission.getEquivalentAmount();
            }
        }
        return result;
    }

    private static <R extends BaseContractRelationData> ExchangeRateData getExchangeRateData(String sourceCurrency, R contractRelationData, boolean air) {
        EntityReference<Organization> customer = CurrencyHelper.getCustomer(contractRelationData);
        EntityContainer contract = EntityStorage.get().resolve((EntityReference)contractRelationData.getGeneralData().getContract());
        return RulesHelper.getExchangeRateData(Collections.singletonList(contract), customer, (Date)new Date(), null, (String)sourceCurrency, (boolean)air);
    }

    private static <T extends BaseCommission, R extends BaseContractRelationData> String getCommissionContractCurrency(T commission, Collection<R> contractRelationsData) {
        String contractCurrency = null;
        if (commission instanceof GdsCommission) {
            contractCurrency = CurrencyHelper.getCurrencyGdsRateCommission(commission, contractRelationsData);
        } else if (commission instanceof Commission) {
            contractCurrency = CurrencyHelper.getCurrencyAirRateCommission(commission, contractRelationsData);
        } else if (commission instanceof GeneralProductCommission) {
            contractCurrency = CurrencyHelper.getCurrencyGeneralRateCommission(commission, contractRelationsData);
        }
        return contractCurrency;
    }

    private static <T extends BaseCommission, R extends BaseContractRelationData> R getCommissionContractRelationData(T commission, Collection<R> contractRelationsData) {
        BaseContractRelationData contractRelationData = null;
        if (commission instanceof GdsCommission) {
            contractRelationData = (BaseContractRelationData)contractRelationsData.stream().filter(CurrencyHelper.filterGdsContractRelation((GdsCommission)commission)).findFirst().get();
        } else if (commission instanceof Commission) {
            contractRelationData = (BaseContractRelationData)contractRelationsData.stream().filter(CurrencyHelper.filterAirContractRelations((Commission)commission)).findFirst().get();
        } else if (commission instanceof GeneralProductCommission) {
            contractRelationData = (BaseContractRelationData)contractRelationsData.stream().filter(CurrencyHelper.filterGeneralContractRelation((GeneralProductCommission)commission)).findFirst().get();
        }
        return (R)contractRelationData;
    }

    private static <T extends BaseCommission, R extends BaseContractRelationData> R getClientContractRelationData(Collection<R> contractRelationsData) {
        return (R)((BaseContractRelationData)contractRelationsData.stream().filter(r -> GeneralProductHelper.getContractType((EntityReference)r.getDescription()) == ContractType.CLIENT).findFirst().orElse(null));
    }

    public static <R extends BaseContractRelationData> EntityReference<Organization> getCustomer(R contractRelationData) {
        NestedEntityReference contract = contractRelationData.getGeneralData().getContract();
        return ((Contract)EntityStorage.get().resolve((EntityReference)contract).getEntity()).getCustomers().stream().filter(contractCustomerInfo -> contractCustomerInfo.getUid().equals(contract.getNestedEntityUid())).findFirst().map(ContractCustomerInfo::getCustomer).orElse(null);
    }

    private static <T extends BaseCommission, R extends BaseContractRelationData> String getCurrencyAirRateCommission(T commission, Collection<R> contractRelationsData) {
        return contractRelationsData.stream().filter(CurrencyHelper.filterAirContractRelations((Commission)commission)).map(CurrencyHelper.toAirProductContractRelationData()).filter(r -> r.getCommissions().contains(commission)).findFirst().map(CurrencyHelper.resolveCurrency()).orElse(CurrencyHelper.getSystem());
    }

    private static <R extends BaseContractRelationData> Function<R, AirProductContractRelationData> toAirProductContractRelationData() {
        return r -> (AirProductContractRelationData)r;
    }

    private static <T extends BaseCommission, R extends BaseContractRelationData> Predicate<R> filterAirContractRelations(Commission commission) {
        return relation -> GeneralProductHelper.getContractType((EntityReference)relation.getDescription()) == commission.getContractType();
    }

    private static <T extends BaseCommission, R extends BaseContractRelationData> String getCurrencyGeneralRateCommission(T commission, Collection<R> contractRelationsData) {
        return contractRelationsData.stream().filter(CurrencyHelper.filterGeneralContractRelation((GeneralProductCommission)commission)).map(CurrencyHelper.toGeneralProductContractRelationData()).filter(r -> r.getCommissions().contains(commission)).findFirst().map(CurrencyHelper.resolveCurrency()).orElse(CurrencyHelper.getSystem());
    }

    private static <R extends BaseContractRelationData> Function<R, GeneralProductContractRelationData> toGeneralProductContractRelationData() {
        return r -> (GeneralProductContractRelationData)r;
    }

    private static <T extends BaseCommission, R extends BaseContractRelationData> Predicate<R> filterGeneralContractRelation(GeneralProductCommission commission) {
        return relation -> GeneralProductHelper.getContractType((EntityReference)relation.getDescription()) == commission.getContractType();
    }

    private static <T extends BaseCommission, R extends BaseContractRelationData> String getCurrencyGdsRateCommission(T commission, Collection<R> contractRelationsData) {
        return contractRelationsData.stream().filter(CurrencyHelper.filterGdsContractRelation((GdsCommission)commission)).map(CurrencyHelper.toGdsContractRelationData()).filter(r -> r.getCommissions().stream().map(c -> c.getUid()).anyMatch(s -> s.equals(commission.getUid()))).findFirst().map(CurrencyHelper.resolveCurrency()).orElse(CurrencyHelper.getSystem());
    }

    private static <R extends BaseContractRelationData> Function<R, GdsContractRelationData> toGdsContractRelationData() {
        return r -> (GdsContractRelationData)r;
    }

    private static <T extends BaseCommission, R extends BaseContractRelationData> Predicate<R> filterGdsContractRelation(GdsCommission commission) {
        return r -> GeneralProductHelper.getContractType((EntityReference)r.getDescription()) == commission.getContractType();
    }

    private static <R extends BaseContractRelationData> Function<R, String> resolveCurrency() {
        return r -> r.getGeneralData() != null && r.getGeneralData().getCurrency() != null ? r.getGeneralData().getCurrency().getCode() : null;
    }

    public static BigDecimal exchange(Money money, String targetCurrency) {
        if (money == null) {
            return null;
        }
        if (!money.getCurrency().equals(targetCurrency)) {
            return Optional.ofNullable(FinanceHelper.exchange((BigDecimal)money.getValue(), (String)money.getCurrency(), (String)targetCurrency, (CurrencyRateType)CurrencyRateType.IATA, (TariffType)TariffType.REGULAR, null, null, (boolean)true)).orElse(money.getValue());
        }
        return money.getValue();
    }

    public static BigDecimal exchange(BigDecimal amount, EntityReference<Organization> agencyRef, EntityReference<Organization> subagencyRef, EntityReference<Organization> client) {
        String subagentClientCurrency;
        String subagentAgentCurrency = CurrencyHelper.getSubagentCurrencyForSubagent(agencyRef, subagencyRef);
        if (!subagentAgentCurrency.equals(subagentClientCurrency = CurrencyHelper.getClientCurrencyForCurrentSubagent(subagencyRef, client))) {
            return Optional.ofNullable(FinanceHelper.exchange((BigDecimal)amount, (String)subagentAgentCurrency, (String)subagentClientCurrency, (CurrencyRateType)CurrencyRateType.IATA, (TariffType)TariffType.REGULAR, null, null, (boolean)true)).orElse(amount);
        }
        return amount;
    }

    public static BigDecimal exchange(BigDecimal amount, String sourceCurrencyCode, String exchangeCurrencyCode) {
        if (!sourceCurrencyCode.equals(exchangeCurrencyCode)) {
            return Optional.ofNullable(FinanceHelper.exchange((BigDecimal)amount, (String)sourceCurrencyCode, (String)exchangeCurrencyCode, (CurrencyRateType)CurrencyRateType.IATA, (TariffType)TariffType.REGULAR, null, null, (boolean)true)).orElse(amount);
        }
        return amount;
    }

    public static BigDecimal exchange(BigDecimal amount, String currency, String targetCurrency, SMCurrencyDisplaySettings settings) {
        if (TextUtil.isBlank((String)targetCurrency) || MiscUtil.equals((Object)targetCurrency, (Object)currency)) {
            return amount;
        }
        ExchangeRateCondition exRateCondition = CurrencyHelper.toExchangeRateCondition(settings);
        ExchangeRateData rateData = MulticurrencyHelper.buildExchangeRateData((String)currency, (String)targetCurrency, (ExchangeRateCondition)exRateCondition, (Date)new Date(), null, (boolean)true);
        if (rateData.getRateWithCoefficient() == 0.0) {
            return null;
        }
        return MulticurrencyHelper.convert((BigDecimal)amount, (ExchangeRateData)rateData);
    }

    private static ExchangeRateCondition toExchangeRateCondition(SMCurrencyDisplaySettings settings) {
        if (settings == null) {
            return null;
        }
        ExchangeRateCondition result = new ExchangeRateCondition();
        result.setRateType(settings.getRateType());
        result.setRoundingMode((RoundingMode)MiscUtil.guarded((Object)settings.getRoundingMode(), (Object)RoundingMode.MATH));
        result.setRoundingValue((RoundingValue)MiscUtil.guarded((Object)settings.getRoundingValue(), (Object)RoundingValue.V_1));
        if (settings.getRiskRatio() != null) {
            result.setCoefficient(settings.getRiskRatio().doubleValue());
        }
        return result;
    }

    @Deprecated
    public static <T extends BaseContractRelationData> String getContractCurrency(Collection<T> contractRelationsData) {
        for (BaseContractRelationData contractData : contractRelationsData) {
            if (contractData.getGeneralData().getCurrency() == null) continue;
            return contractData.getGeneralData().getCurrency().getCode();
        }
        return CurrencyHelper.getSystem();
    }

    @Deprecated
    public static String getCurrency(EntityReference<Organization> agencyRef, ContractType contractType) {
        try {
            List contracts = ProfileHelper.getOrganizationContracts(Collections.singletonList(agencyRef), Collections.singletonList(contractType));
            for (EntityReference cr : contracts) {
                EntityContainer ec = EntityStorage.get().resolve(cr);
                Contract contract = (Contract)ec.getEntity();
                for (ContractCustomerInfo customer : contract.getCustomers()) {
                    if (customer.getPaymentCurrency() == null) continue;
                    return customer.getPaymentCurrency();
                }
            }
        }
        catch (Exception e) {
            return CurrencyHelper.getSystem();
        }
        return CurrencyHelper.getSystem();
    }

    @Deprecated
    public static String getClientCurrencyForCurrentSubagent(EntityReference<Organization> agencyRef) {
        return CurrencyHelper.getCurrency(agencyRef, ContractType.CLIENT);
    }

    @Deprecated
    public static String getSubagentCurrencyForSubagent(EntityReference<Organization> agencyRef) {
        return CurrencyHelper.getCurrency(agencyRef, ContractType.SUBAGENCY);
    }

    @Deprecated
    public static <T extends BaseCommission> String getCommissionsCurrency(Collection<T> commissions) {
        return commissions.stream().map(BaseCommission::getAmount).filter(Objects::nonNull).findFirst().map(Money::getCurrency).orElse(null);
    }

    @Deprecated
    public static BigDecimal exchange(BigDecimal amount, EntityReference<Organization> agencyRef) {
        String subagentClientCurrency;
        String subagentAgentCurrency = CurrencyHelper.getSubagentCurrencyForSubagent(agencyRef);
        if (!subagentAgentCurrency.equals(subagentClientCurrency = CurrencyHelper.getClientCurrencyForCurrentSubagent(agencyRef))) {
            return Optional.ofNullable(FinanceHelper.exchange((BigDecimal)amount, (String)subagentAgentCurrency, (String)subagentClientCurrency, (CurrencyRateType)CurrencyRateType.IATA, (TariffType)TariffType.REGULAR, null, null, (boolean)true)).orElse(amount);
        }
        return amount;
    }
}

