/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp;

import com.gridnine.xtrip.common.midoffice.helper.ReservationGdsNameInfoUpdateHandler;
import com.gridnine.xtrip.common.model.booking.RecordLocatorInfo;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationSystemInfo;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;

public class IbecorpReservationGdsNameInfoUpdateHandler
extends ReservationGdsNameInfoUpdateHandler {
    protected boolean isCompatibilityRecordLocator(ReservationSystemInfo systemInfo, RecordLocatorInfo locatorInfo, Reservation reservation) {
        switch (systemInfo.getGdsName()) {
            case MIXVEL: {
                return false;
            }
            case SIRENA: {
                return !CommonReservationGdsNameInfoHelper.containsGds((Reservation)reservation, (GdsName)GdsName.TA_NDC) && locatorInfo.getType() == RecordLocatorType.SIRENA_LATIN;
            }
            case SABRE: {
                return !CommonReservationGdsNameInfoHelper.containsGds((Reservation)reservation, (GdsName)GdsName.TA_NDC) && !CommonReservationGdsNameInfoHelper.containsGds((Reservation)reservation, (GdsName)GdsName.HOTEL_AGGREGATOR);
            }
            case AMADEUS: {
                return !CommonReservationGdsNameInfoHelper.containsGds((Reservation)reservation, (GdsName)GdsName.TA_NDC) && !CommonReservationGdsNameInfoHelper.containsGds((Reservation)reservation, (GdsName)GdsName.HOTEL_AGGREGATOR);
            }
            case GALILEO: {
                return !CommonReservationGdsNameInfoHelper.containsGds((Reservation)reservation, (GdsName)GdsName.TA_NDC);
            }
            case TA_NDC: {
                return locatorInfo.getType() == RecordLocatorType.TA_NDC_ORIGINAL_BOOKING_ID;
            }
            case FLY_ARYSTAN: {
                return locatorInfo.getType() == RecordLocatorType.FLY_ARYSTAN_ID;
            }
            case EXPRESS: {
                return !CommonReservationGdsNameInfoHelper.containsGds((Reservation)reservation, (GdsName)GdsName.RAIL_KZ);
            }
            case IWAY: {
                return locatorInfo.getType() == RecordLocatorType.IWAY_ORDER_ID;
            }
            case IBE: 
            case A_AND_A: 
            case ACADEMSERVICE: 
            case BEDSONLINE: 
            case BOOKING: 
            case BRONEVIK: 
            case DOME: 
            case EXPEDIA: 
            case HAPPY_TRAVEL: 
            case HORSE_21: 
            case HOTELBOOK: 
            case HOTELSTAR: 
            case GO_GLOBAL: 
            case GTA: 
            case OKTOGO: 
            case OSTROVOK: 
            case PANDA: 
            case PRICELINE: 
            case RCR: 
            case SUSANIN: {
                return !CommonReservationGdsNameInfoHelper.containsGds((Reservation)reservation, (GdsName)GdsName.HOTEL_AGGREGATOR);
            }
            case HOTEL_AGGREGATOR: {
                return locatorInfo.getType() == RecordLocatorType.HOTEL_AGGREGATOR_PNR;
            }
        }
        return true;
    }
}

