/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.correspondence;

import com.gridnine.xtrip.common.ibecorp.correspondence.CorrespondenceHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBookingHandlersRegistry;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBookingHandlersRegistryConfigurator;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBookingRelatedObjectHandler;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.BaseIssue;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.IssueIndex;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.HashSet;

public class CorrespondenceArchivedBookingHandlersRegistryConfigurator
implements ArchivedBookingHandlersRegistryConfigurator {
    public void configure(ArchivedBookingHandlersRegistry registry) {
        registry.register((ArchivedBookingRelatedObjectHandler)new RelatedIssuesHandler());
        registry.register((ArchivedBookingRelatedObjectHandler)new RelatedDocumentsOfRelatedIssuesHandler());
    }

    static class RelatedDocumentsOfRelatedIssuesHandler
    implements ArchivedBookingRelatedObjectHandler<BaseFileDocument, BasicDocumentIndex> {
        RelatedDocumentsOfRelatedIssuesHandler() {
        }

        public Class<BasicDocumentIndex> getIndexClass() {
            return BasicDocumentIndex.class;
        }

        public String getDisplayName() {
            return "\u0421\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u043e\u0439 \u043f\u0435\u0440\u0435\u043f\u0438\u0441\u043a\u0438";
        }

        public SearchQuery getQuery(EntityContainer<BookingFile> bookingCtr) {
            SearchQuery query = CorrespondenceHelper.getSearchIssuesSearchQuery(TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)bookingCtr.getEntity())));
            HashSet<String> issueUids = new HashSet<String>();
            for (IssueIndex idx : EntityStorage.get().search(IssueIndex.class, query).getData()) {
                issueUids.add(idx.getSource().getUid());
            }
            if (issueUids.isEmpty()) {
                return null;
            }
            SearchQuery result = new SearchQuery();
            result.getCriteria().getCriterions().add(SearchCriterion.in((String)BasicDocumentIndex.Property.owner.name(), (Object[])new ArrayList(issueUids).toArray()));
            return result;
        }

        public String getId() {
            return "related-documents-of-related-issues";
        }
    }

    static class RelatedIssuesHandler
    implements ArchivedBookingRelatedObjectHandler<BaseIssue, IssueIndex> {
        RelatedIssuesHandler() {
        }

        public Class<IssueIndex> getIndexClass() {
            return IssueIndex.class;
        }

        public String getDisplayName() {
            return "\u0421\u0432\u044f\u0437\u0430\u043d\u043d\u0430\u044f \u043f\u0435\u0440\u0435\u043f\u0438\u0441\u043a\u0430";
        }

        public SearchQuery getQuery(EntityContainer<BookingFile> bookingCtr) {
            return CorrespondenceHelper.getSearchIssuesSearchQuery(TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)bookingCtr.getEntity())));
        }

        public String getId() {
            return "related-issues";
        }
    }
}

