/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.correspondence;

import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.IssueIndex;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class CorrespondenceHelper {
    private static final Pattern EMAIL_ADDRESS_PATTERN = Pattern.compile("([0-9A-Za-z-_]+\\.)*[0-9A-Za-z-_]+@((([0-9A-Za-z-_]+\\.)+[A-Za-z]+)|(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}))");

    public static SearchQuery getSearchIssuesSearchQuery(String bookingNumber) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)IssueIndex.Property.bookingNumber.name(), (Object)bookingNumber));
        return query;
    }

    public static List<String> getPersonEmails(Person person) {
        ArrayList<String> addresses = new ArrayList<String>();
        for (Communication comm : person.getCommunications()) {
            if (comm.getType() != CommunicationType.EMAIL || !CorrespondenceHelper.isValidEmailAddress(comm.getSense())) continue;
            addresses.add(comm.getSense());
        }
        return addresses;
    }

    public static boolean isValidEmailAddress(String str) {
        if (TextUtil.isBlank((String)str)) {
            return false;
        }
        return EMAIL_ADDRESS_PATTERN.matcher(str).matches();
    }
}

