/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.rest;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.util.DesUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Optional;

public final class AuthUserPreferencesToken {
    public static final String IBECORP_B2B_AUTH_USER_PREFERENCES_TOKEN_COOKIE_NAME = "IBECORP_B2B_USER_PREFERENCES_TOKEN_COOKIE";
    private static final char[] SKEY = "Jv6D%MK4SmLpG4Wi".toCharArray();
    private final PersonType personType;
    private final EntityReference<Organization> organizationRef;
    private final EntityReference<SalesPoint> salesPointRef;

    public AuthUserPreferencesToken(PersonType personType, EntityReference<Organization> organizationRef, EntityReference<SalesPoint> salesPointRef) {
        this.personType = personType;
        this.organizationRef = organizationRef;
        this.salesPointRef = salesPointRef;
    }

    public PersonType getPersonType() {
        return this.personType;
    }

    public EntityReference<Organization> getOrganizationRef() {
        return this.organizationRef;
    }

    public EntityReference<SalesPoint> getSalesPointRef() {
        return this.salesPointRef;
    }

    public String encode() throws Exception {
        return DesUtil.encrypt((char[])SKEY, (String)String.join((CharSequence)"|", this.personType.name(), this.organizationRef.getUid(), this.salesPointRef != null ? this.salesPointRef.getUid() : ""));
    }

    public static AuthUserPreferencesToken decode(String str) throws Exception {
        if (TextUtil.isBlank((String)str)) {
            return null;
        }
        String token = DesUtil.decrypt((char[])SKEY, (String)str);
        String[] tokenParts = token.split("\\|", 3);
        if (tokenParts.length < 2 || tokenParts.length > 3) {
            throw Xeption.forDeveloper((String)"invalid user preference token", (Object[])new Object[0]);
        }
        PersonType personType = PersonType.valueOf((String)tokenParts[0]);
        EntityReference orgRef = new EntityReference(tokenParts[1], Organization.class, null);
        String spUid = null;
        if (tokenParts.length == 3) {
            spUid = tokenParts[2];
        }
        EntityReference spRef = Optional.ofNullable(spUid).filter(TextUtil::nonBlank).map(uid -> new EntityReference(uid, SalesPoint.class, null)).orElse(null);
        AuthUserPreferencesToken result = new AuthUserPreferencesToken(personType, (EntityReference<Organization>)orgRef, (EntityReference<SalesPoint>)spRef);
        return result;
    }
}

