/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.rules;

import com.gridnine.xtrip.common.ibecorp.rules.CompanyRelationProvider;
import com.gridnine.xtrip.common.ibecorp.rules.Targets;
import com.gridnine.xtrip.common.ibecorp.rules.ValueTypes;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.finance.CompanyRelation;
import com.gridnine.xtrip.common.model.rules.standard.ClientPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import java.util.Collection;

public enum FinanceProperties implements RuleProperty
{
    FINANCE_CUSTOMER{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)"FINANCE_RULES_PROPERTIES_CUSTOMER");
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.AGENCIES_AND_CLIENTS.name();
        }

        @Override
        public String[] getTargetIds() {
            return new String[]{Targets.FINANCE.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10n.replace((String)L10n.get((String)"FINANCE_RULES_PROPERTIES_CUSTOMER_INFO"), (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            ClientPropertiesProvider ps = (ClientPropertiesProvider)propertySet;
            EntityReference psValue = ps.getClient();
            Collection values = (Collection)value;
            if (Conditions.INCLUDE.equals((Object)condition)) {
                return values.contains(psValue);
            }
            if (Conditions.EXCLUDE.equals((Object)condition)) {
                return !values.contains(psValue);
            }
            return false;
        }
    }
    ,
    FINANCE_COMPANY_RELATION{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)"FINANCE_RULES_PROPERTIES_RELATIONS");
        }

        public String getRendererId() {
            return ValueTypes.COMPANY_RELATION.name();
        }

        @Override
        public String[] getTargetIds() {
            return new String[]{Targets.FINANCE.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10n.replace((String)L10n.get((String)"FINANCE_RULES_PROPERTIES_RELATIONS_INFO"), (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            CompanyRelationProvider ps = (CompanyRelationProvider)propertySet;
            CompanyRelation companyRelation = ps.getCompanyRelation();
            CompanyRelation values = (CompanyRelation)value;
            if (Conditions.EQUALS.equals((Object)condition)) {
                return values.equals((Object)companyRelation);
            }
            if (Conditions.NOT_EQUALS.equals((Object)condition)) {
                return !values.equals((Object)companyRelation);
            }
            return false;
        }
    };


    public String getId() {
        return this.name();
    }

    public abstract String[] getTargetIds();

    public abstract String[] getConditionIds();
}

