/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.rules;

import com.gridnine.xtrip.common.ibecorp.CurrencyHelper;
import com.gridnine.xtrip.common.ibecorp.rules.HotelTravelPolicyPropertiesProvider;
import com.gridnine.xtrip.common.ibecorp.rules.IbecorpTravelPolicyPropertiesProvider;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMCurrencyDisplaySettings;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RulePropertyConditions;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyTargets;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;

public enum IbecorpTravelPolicyProperties implements RuleProperty,
RulePropertyConditions
{
    TRAVEL_POLICY_CLIENT_TOTAL_WITH_CURRENCY{

        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"TRAVEL_POLICY_RULES_PROPERTIES_CLIENT_TOTAL_WITH_CURRENCY", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.PRICE_WITH_CURRENCY.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{TravelPolicyTargets.TRAVEL_POLICY_AVIA.getId(), TravelPolicyTargets.TRAVEL_POLICY_RAILWAY.getId(), TravelPolicyTargets.TRAVEL_POLICY_HOTELS.getId(), TravelPolicyTargets.TRAVEL_POLICY_TRANSFER.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"TRAVEL_POLICY_RULES_PROPERTIES_CLIENT_TOTAL_WITH_CURRENCY_X", (Object[])new Object[]{cond.getDisplayName(), String.valueOf(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            SMCurrencyDisplaySettings settings;
            String clientCurrency;
            IbecorpTravelPolicyPropertiesProvider ps = (IbecorpTravelPolicyPropertiesProvider)propertySet;
            String localCurrency = DictHelper.getLocalCurrency();
            Money money = (Money)value;
            BigDecimal ruleAmount = MiscUtil.guarded((BigDecimal)money.getValue());
            String ruleCurrency = (String)MiscUtil.guarded((Object)money.getCurrency(), (Object)localCurrency);
            BigDecimal clientTotal = MiscUtil.guarded((BigDecimal)ps.getClientTotal());
            BigDecimal convertedClientTotal = CurrencyHelper.exchange(clientTotal, clientCurrency = (String)MiscUtil.guarded((Object)ps.getClientCurrency(), (Object)localCurrency), ruleCurrency, settings = (SMCurrencyDisplaySettings)ps.getSmGeneralSettings().getDisplayCurrencies().stream().filter(dc -> MiscUtil.equals((Object)DictHelper.getCode((DictionaryReference)dc.getCurrency()), (Object)ruleCurrency)).findFirst().orElse(null));
            if (convertedClientTotal == null) {
                return false;
            }
            int compared = MiscUtil.guarded((BigDecimal)convertedClientTotal).compareTo(ruleAmount);
            if (Conditions.EQUALS.equals((Object)condition)) {
                return 0 == compared;
            }
            if (Conditions.NOT_EQUALS.equals((Object)condition)) {
                return compared != 0;
            }
            if (Conditions.GREATER_THAN.equals((Object)condition)) {
                return compared > 0;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals((Object)condition)) {
                return compared >= 0;
            }
            if (Conditions.LESS_THAN.equals((Object)condition)) {
                return compared < 0;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals((Object)condition)) {
                return compared <= 0;
            }
            return false;
        }
    }
    ,
    TRAVEL_POLICY_HOTEL_DAILY_RATE_PER_PERSON_WITH_CURRENCY{

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"TRAVEL_POLICY_RULES_PROPERTIES_RATE_PER_NIGHT_PER_PERSON_WITH_CURRENCY", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.PRICE_WITH_CURRENCY.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"TRAVEL_POLICY_RULES_PROPERTIES_RATE_PER_NIGHT_PER_PERSON_WITH_CURRENCY_INFO", (Object[])new Object[]{cond.getDisplayName(), String.valueOf(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            SMCurrencyDisplaySettings settings;
            HotelTravelPolicyPropertiesProvider ps = (HotelTravelPolicyPropertiesProvider)propertySet;
            BigDecimal totalPrice = BookingHelper.getTotalPrice((BaseProduct)ps.getProduct(), (ContractType)ContractType.CLIENT);
            BigDecimal nights = BigDecimal.valueOf(ps.getStayDuration());
            BigDecimal persons = BigDecimal.valueOf(ps.getPersonsCount());
            if (nights.intValue() < 1) {
                return false;
            }
            if (persons.intValue() < 1) {
                return false;
            }
            String localCurrency = DictHelper.getLocalCurrency();
            Money money = (Money)value;
            BigDecimal ruleAmount = MiscUtil.guarded((BigDecimal)money.getValue());
            String ruleCurrency = (String)MiscUtil.guarded((Object)money.getCurrency(), (Object)localCurrency);
            String clientCurrency = (String)MiscUtil.guarded((Object)ps.getClientCurrency(), (Object)localCurrency);
            BigDecimal convertedClientTotal = CurrencyHelper.exchange(totalPrice, clientCurrency, ruleCurrency, settings = (SMCurrencyDisplaySettings)ps.getSmGeneralSettings().getDisplayCurrencies().stream().filter(dc -> MiscUtil.equals((Object)DictHelper.getCode((DictionaryReference)dc.getCurrency()), (Object)ruleCurrency)).findFirst().orElse(null));
            if (convertedClientTotal == null) {
                return false;
            }
            BigDecimal costPerNightPerPerson = convertedClientTotal.divide(nights, RoundingMode.HALF_UP).divide(persons, RoundingMode.HALF_UP);
            int compared = MiscUtil.guarded((BigDecimal)costPerNightPerPerson).compareTo(MiscUtil.guarded((BigDecimal)ruleAmount));
            if (Conditions.EQUALS.equals((Object)condition)) {
                return 0 == compared;
            }
            if (Conditions.NOT_EQUALS.equals((Object)condition)) {
                return compared != 0;
            }
            if (Conditions.GREATER_THAN.equals((Object)condition)) {
                return compared > 0;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals((Object)condition)) {
                return compared >= 0;
            }
            if (Conditions.LESS_THAN.equals((Object)condition)) {
                return compared < 0;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals((Object)condition)) {
                return compared <= 0;
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{TravelPolicyTargets.TRAVEL_POLICY_HOTELS.getId()};
        }

        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }
    };


    public String getId() {
        return this.name();
    }

    abstract String[] getTargetIds();
}

