/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.rules;

import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.rules.GdsPropertiesProvider;
import com.gridnine.xtrip.common.hotels2.model.HotelOffer;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.ibecorp.rules.SmSiteTypeProvider;
import com.gridnine.xtrip.common.midoffice.helper.CommonHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.ibecorp.PriceDetailDisplayArea;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.SalesContextPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.TravelSubjectsPropertyProvider;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.server.transfers.SearchGdsResponse;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class PriceDetailProperty
implements GdsPropertiesProvider,
SalesContextPropertiesProvider,
TravelSubjectsPropertyProvider,
SmSiteTypeProvider {
    private final String gdsName;
    private final EntityReference<? extends BaseGdsAccount> gdsAccount;
    private final EntityReference<Organization> client;
    private final SMSiteType smSiteType;
    private final String agencyCode;
    private final Collection<PriceDetailDisplayArea> priceDetailDisplayAreas = new HashSet<PriceDetailDisplayArea>();
    private final Set<String> subagencyCodes = new HashSet<String>();
    private final Collection<TravelSubject> travelSubjects = new HashSet<TravelSubject>();

    public PriceDetailProperty(Reservation reservation, PriceDetailDisplayArea priceDetailDisplayAreas) {
        this.gdsAccount = reservation.getGdsNameInfo().getOnlineGdsAccount();
        this.gdsName = EnumUtil.nameOf((Enum)CommonReservationGdsNameInfoHelper.getRulesGdsName((Reservation)reservation));
        this.client = reservation.getBookingFile().getCustomerProfile();
        this.smSiteType = CommonIbecorpHelper.getSiteType(reservation);
        this.agencyCode = RulesHelper.getAgencyCode((Reservation)reservation);
        this.addSubagencyCodes((EntityReference<Organization>)reservation.getSubagency());
        this.travelSubjects.add(BookingHelper.getTravelSubject((Reservation)reservation));
        this.priceDetailDisplayAreas.add(priceDetailDisplayAreas);
    }

    private PriceDetailProperty(SalesContext salesContext, GdsName gdsName, EntityReference<? extends BaseGdsAccount> gdsAccount) {
        this.client = salesContext.getClient();
        this.smSiteType = CommonIbecorpHelper.getSiteType((EntityReference<SMSite>)salesContext.getSite());
        this.agencyCode = CommonHelper.getAgencyCode((SalesContext)salesContext);
        this.addSubagencyCodes((EntityReference<Organization>)salesContext.getSubagency());
        this.priceDetailDisplayAreas.add(PriceDetailDisplayArea.SITE);
        this.gdsName = EnumUtil.nameOf((Enum)gdsName);
        this.gdsAccount = gdsAccount;
    }

    public PriceDetailProperty(Flight flight, SalesContext salesContext) {
        this(salesContext, flight.getGds(), (EntityReference<? extends BaseGdsAccount>)flight.getGdsAccount());
        this.travelSubjects.add(TravelSubject.AIR);
    }

    public PriceDetailProperty(HotelOffer offer, SalesContext salesContext) {
        this(salesContext, PriceDetailProperty.resolveGdsName((EntityReference<? extends BaseGdsAccount>)offer.getGdsAccount()), (EntityReference<? extends BaseGdsAccount>)offer.getGdsAccount());
        this.travelSubjects.add(TravelSubject.HOTEL_RESERVATION);
    }

    public PriceDetailProperty(SearchGdsResponse transferOffer, SalesContext salesContext) {
        this(salesContext, PriceDetailProperty.resolveGdsName((EntityReference<? extends BaseGdsAccount>)transferOffer.getGdsAccount()), (EntityReference<? extends BaseGdsAccount>)transferOffer.getGdsAccount());
        this.travelSubjects.add(TravelSubject.TRANSFER);
    }

    private static GdsName resolveGdsName(EntityReference<? extends BaseGdsAccount> gdsAccount) {
        EntityContainer gdsAccountCtr = EntityStorage.get().resolve(gdsAccount);
        return gdsAccountCtr != null ? ((BaseGdsAccount)gdsAccountCtr.getEntity()).getGds() : null;
    }

    public EntityReference<? extends BaseGdsAccount> getGdsAccount() {
        return this.gdsAccount;
    }

    public String getGdsName() {
        return this.gdsName;
    }

    public EntityReference<Organization> getClient() {
        return this.client;
    }

    public String getAgencyCode() {
        return this.agencyCode;
    }

    public Set<String> getSubagencyCodes() {
        return this.subagencyCodes;
    }

    private void addSubagencyCodes(EntityReference<Organization> agencyRef) {
        RulesHelper.addSubagencyCodes(this.subagencyCodes, agencyRef);
    }

    public Set<String> getProfileGroups() {
        return null;
    }

    public EntityReference<Person> getAgent() {
        return null;
    }

    public Collection<TravelSubject> getTravelSubjects() {
        return this.travelSubjects;
    }

    @Override
    public SMSiteType getSMSiteType() {
        return this.smSiteType;
    }

    public Collection<PriceDetailDisplayArea> getPriceDetailDisplayArea() {
        return this.priceDetailDisplayAreas;
    }
}

