/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.rules;

import com.gridnine.xtrip.common.ibecorp.rules.RzdParametersExPropertiesProvider;
import com.gridnine.xtrip.common.ibecorp.rules.ValueTypes;
import com.gridnine.xtrip.common.ibecorp.rules.l10n.Messages;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RulePropertyConditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.railway.model.rules.standart.RailwayProductPropertiesProvider;
import com.gridnine.xtrip.common.railway.model.rules.standart.Targets;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import java.util.Date;
import java.util.List;

public enum RailwayProperties implements RuleProperty,
RulePropertyConditions
{
    RAILWAY_DEPARTURE_TIME{

        public String[] getConditionIds() {
            return new String[]{Conditions.PERIOD_WITHIN.getId(), Conditions.PERIOD_BEYOND.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RAILWAY_RULES_PROPERTIES_DEPARTURE_TIME", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.TIME_INTERVAL.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[0];
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(" %s %s %s", this.getDisplayName(), cond.getDisplayName(), RulesHelper.buildDateIntervalInfo((RuleCondition)cond, (Object)value)));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider propertiesProvider = (RailwayProductPropertiesProvider)propertySet;
            return RulesHelper.matchesTimeIntervalRestriction((Date)propertiesProvider.getDepartureDate(), (Object)value, (RuleCondition)condition);
        }
    }
    ,
    RAILWAY_ARRIVAL_TIME{

        public String[] getConditionIds() {
            return new String[]{Conditions.PERIOD_WITHIN.getId(), Conditions.PERIOD_BEYOND.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RAILWAY_PROPERTIES_ARRIVAL_TIME", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.TIME_INTERVAL.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[0];
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(" %s %s %s", this.getDisplayName(), cond.getDisplayName(), RulesHelper.buildDateIntervalInfo((RuleCondition)cond, (Object)value)));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider propertiesProvider = (RailwayProductPropertiesProvider)propertySet;
            return RulesHelper.matchesTimeIntervalRestriction((Date)propertiesProvider.getArrivalDate(), (Object)value, (RuleCondition)condition);
        }
    }
    ,
    RAILWAY_CARRIAGE_TYPE{

        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)com.gridnine.xtrip.common.model.rules.l10n.Messages.Properties_coachType);
        }

        public String getRendererId() {
            return ValueTypes.RAILWAY_CARRIAGE_TYPE_VALUE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[0];
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(" %s %s %s", this.getDisplayName(), cond.getDisplayName(), value != null ? value.toString() : null));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider ps = (RailwayProductPropertiesProvider)propertySet;
            CarriageType carriageType = (CarriageType)value;
            if (Conditions.EQUALS.equals((Object)condition)) {
                return ps.getCarriageTypes().size() == 1 && carriageType != null && ps.getCarriageTypes().contains(carriageType.name());
            }
            if (Conditions.NOT_EQUALS.equals((Object)condition)) {
                return ps.getCarriageTypes().size() != 1 || carriageType == null || !ps.getCarriageTypes().contains(carriageType.name());
            }
            return true;
        }
    }
    ,
    RAILWAY_TRAIN_TITLE_BRAND{
        private final String DISPLAY_NAME = L10nResourcesManager.getStr((String)"RAILWAY_RULES_PROPERTIES_TRAIN_TYPE", (Object[])new Object[0]);

        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return this.DISPLAY_NAME;
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{com.gridnine.xtrip.common.gds.rules.Targets.GDS_PARAMETERS_EX.getId(), Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(this.DISPLAY_NAME).append(String.format(" %s \"%s\"", cond.getDisplayName(), RulesHelper.toString((Object)value)));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RzdParametersExPropertiesProvider ps = (RzdParametersExPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRangeRestriction(ps.getTrainTypes(), (Object)value, (boolean)true);
            }
            if (Conditions.EXCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRangeRestriction(ps.getTrainTypes(), (Object)value, (boolean)false);
            }
            return true;
        }
    }
    ,
    RAILWAY_EXTERNAL_REFUND{
        private final String DISPLAY_NAME = L10nResourcesManager.getStr((String)"RAILWAY_RULES_PROPERTIES_EXTERNAL_REFUND", (Object[])new Object[0]);

        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId()};
        }

        public String getDisplayName() {
            return this.DISPLAY_NAME;
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(Boolean.TRUE.equals(value) ? this.DISPLAY_NAME : L10nResourcesManager.getStr((String)"RAILWAY_RULES_PROPERTIES_EXTERNAL_REFUND_NO", (Object[])new Object[0]));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RzdParametersExPropertiesProvider ps = (RzdParametersExPropertiesProvider)propertySet;
            return Boolean.valueOf(ps.isExternalRefund()).equals(value);
        }
    }
    ,
    RAILWAY_DEPARTURE_WEEK_DAYS{

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)Messages.RuleProperty_RailwayDepartureWeekDay, (Object[])new Object[0]);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.WEEK_DAY.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10n.replace((String)L10nResourcesManager.getStr((String)Messages.RuleProperty_RailwayDepartureWeekDay_info, (Object[])new Object[0]), (Object[])new Object[]{cond.getDisplayName(), RulesHelper.values2text((List)((List)value))}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider ps = (RailwayProductPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesEnumRestriction((String)DictHelper.getWeekDay((int)ps.getDepartureDateLocal().getDay()), (List)((List)value), (boolean)true);
            }
            if (Conditions.EXCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesEnumRestriction((String)DictHelper.getWeekDay((int)ps.getDepartureDateLocal().getDay()), (List)((List)value), (boolean)false);
            }
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[0];
        }

        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }
    };


    public String getId() {
        return this.name();
    }

    abstract String[] getTargetIds();
}

