/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.rzd;

import com.gridnine.xtrip.common.gds.helper.AgeRestriction;
import com.gridnine.xtrip.common.ibecorp.rzd.DirectionGroupCalculator;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.CarriageAttribute;
import com.gridnine.xtrip.common.ibecorp.rzd.model.CarriageAttributeEx;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPrice;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTariff;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrain;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrier;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AgeRestrictionCalculator {
    private static final Map<String, List<ServiceClass>> mapOf10age = new HashMap<String, List<ServiceClass>>();

    public AgeRestriction calculate(RzdTariff rzdTariff, RzdTrain train, RzdPrice rzdPrice) {
        return this.calculate(rzdTariff, train, rzdPrice, false);
    }

    public AgeRestriction calculate(RzdTariff rzdTariff, RzdTrain train, RzdPrice rzdPrice, boolean isSeatMotherWithChild) {
        RzdTariff correctedTariff = AgeRestrictionCalculator.correctRzdTariff(rzdTariff, train, rzdPrice);
        if (this.isInfantOneYearsOld(correctedTariff, rzdPrice, isSeatMotherWithChild)) {
            return new AgeRestriction(null, null, Integer.valueOf(1), Boolean.FALSE);
        }
        return this.buildAgeRestriction(correctedTariff);
    }

    public static RzdTariff correctRzdTariff(RzdTariff rzdTariff, RzdTrain train, RzdPrice rzdPrice) {
        boolean isDM = rzdPrice.getSeatsIncluded() == 2;
        int directionGroup = AgeRestrictionCalculator.calculateDirectionGroup(train, rzdPrice);
        boolean isSuburbanTrain = RzdCommonHelper.isSuburbanTrain(train.getDisplayNumber());
        boolean isSpecialCarriage = RzdCommonHelper.isSpecialCarriage(rzdPrice.getCategory(), isDM);
        HashMap<String, String> carrierCodeVariants = new HashMap<String, String>();
        if (rzdPrice.getCarrier() != null) {
            carrierCodeVariants.putAll(((RailwayCarrier)DictionaryCache.get().resolveReference(rzdPrice.getCarrier())).getCodeVariants());
        }
        boolean isInfant10age = AgeRestrictionCalculator.existsInMap(mapOf10age, carrierCodeVariants, rzdPrice.getServiceClass());
        return AgeRestrictionCalculator.calculateRzdTariff(rzdTariff, directionGroup, isSuburbanTrain, isSpecialCarriage, isInfant10age);
    }

    private static RzdTariff calculateRzdTariff(RzdTariff rzdTariff, int directionGroup, boolean isSuburbanTrain, boolean isSpecialCarriage, boolean isInfant10age) {
        RzdTariff correctedTariff = rzdTariff;
        if (rzdTariff == RzdTariff.BABY) {
            switch (directionGroup) {
                case 0: {
                    if (!isSpecialCarriage || !isInfant10age) break;
                    correctedTariff = RzdTariff.INFANT_10;
                    break;
                }
                case 1: {
                    correctedTariff = RzdTariff.INFANT_6;
                    break;
                }
                case 2: {
                    correctedTariff = RzdTariff.INFANT_4;
                }
            }
        } else if (rzdTariff == RzdTariff.CHILD) {
            switch (directionGroup) {
                case 0: {
                    if (!isSuburbanTrain) break;
                    correctedTariff = RzdTariff.CHILD_7;
                    break;
                }
                case 1: {
                    correctedTariff = RzdTariff.CHILD_17;
                    break;
                }
                case 2: {
                    correctedTariff = RzdTariff.CHILD_12;
                }
            }
        }
        return correctedTariff;
    }

    private AgeRestriction buildAgeRestriction(RzdTariff rzdTariff) {
        AgeRestriction defaultRestriction = new AgeRestriction(null, null, null, Boolean.FALSE);
        if (rzdTariff == null) {
            return defaultRestriction;
        }
        switch (rzdTariff) {
            case BABY: {
                return new AgeRestriction(null, null, Integer.valueOf(5), Boolean.FALSE);
            }
            case INFANT_4: {
                return new AgeRestriction(null, null, Integer.valueOf(4), Boolean.FALSE);
            }
            case INFANT_6: {
                return new AgeRestriction(null, null, Integer.valueOf(6), Boolean.FALSE);
            }
            case INFANT_10: {
                return new AgeRestriction(null, null, Integer.valueOf(10), Boolean.FALSE);
            }
            case CHILD: {
                return new AgeRestriction(null, null, Integer.valueOf(10), Boolean.FALSE);
            }
            case CHILD_7: {
                return new AgeRestriction(null, null, Integer.valueOf(7), Boolean.FALSE);
            }
            case CHILD_12: {
                return new AgeRestriction(null, null, Integer.valueOf(12), Boolean.FALSE);
            }
            case CHILD_17: {
                return new AgeRestriction(null, null, Integer.valueOf(17), Boolean.FALSE);
            }
            case CHILD_10_17: {
                return new AgeRestriction(Integer.valueOf(10), Boolean.TRUE, Integer.valueOf(18), Boolean.TRUE);
            }
            case JUNIOR: {
                return new AgeRestriction(Integer.valueOf(12), Boolean.FALSE, Integer.valueOf(26), Boolean.FALSE);
            }
            case SENIOR: {
                return new AgeRestriction(Integer.valueOf(60), Boolean.FALSE, null, Boolean.FALSE);
            }
            case SENIOR_SAPSAN: {
                return new AgeRestriction(Integer.valueOf(60), Boolean.FALSE, null, Boolean.FALSE);
            }
            case SCHOOL: {
                return new AgeRestriction(Integer.valueOf(10), Boolean.TRUE, Integer.valueOf(19), Boolean.TRUE);
            }
            case INFANT_12: {
                return new AgeRestriction(null, null, Integer.valueOf(12), Boolean.FALSE);
            }
            case INFANT_6_MKL11: {
                return new AgeRestriction(null, null, Integer.valueOf(6), Boolean.FALSE);
            }
            case JUNIOR_10_21: {
                return new AgeRestriction(Integer.valueOf(10), Boolean.TRUE, Integer.valueOf(21), Boolean.FALSE);
            }
            case INFANT_KTZ: {
                return new AgeRestriction(null, null, Integer.valueOf(7), Boolean.FALSE);
            }
            case CHILD_KTZ: {
                return new AgeRestriction(null, null, Integer.valueOf(15), Boolean.FALSE);
            }
        }
        return defaultRestriction;
    }

    private static int calculateDirectionGroup(RzdTrain train, RzdPrice rzdPrice) {
        return rzdPrice.getDirectionGroup() == null ? new DirectionGroupCalculator().calculate((DictionaryReference<RailwayStation>)train.getPassengerFrom(), (DictionaryReference<RailwayStation>)train.getPassengerTo()).getValue() : rzdPrice.getDirectionGroup().intValue();
    }

    private boolean isInfantOneYearsOld(RzdTariff correctedTariff, RzdPrice rzdPrice, boolean isSeatMotherWithChild) {
        if (correctedTariff != RzdTariff.BABY || !isSeatMotherWithChild) {
            return false;
        }
        Set<CarriageAttributeEx> carriageAttributesEx = CarriageAttributeEx.parseCarriageAttributes(rzdPrice.getSubcategory());
        boolean forChild = carriageAttributesEx.stream().filter(attr -> attr.getAttribute() == CarriageAttribute.CHILD).findAny().isPresent();
        return forChild;
    }

    private static boolean existsInMap(Map<String, List<ServiceClass>> map, Map<String, String> carrierCodeVariants, ServiceClass serviceClass) {
        if (CollectionUtil.isEmptyMap(carrierCodeVariants) || serviceClass == null) {
            return false;
        }
        for (Map.Entry<String, List<ServiceClass>> entry : map.entrySet()) {
            if (!carrierCodeVariants.containsValue(entry.getKey()) || !entry.getValue().contains(serviceClass)) continue;
            return true;
        }
        return false;
    }

    static {
        mapOf10age.put("\u0424\u041f\u041a", Arrays.asList(ServiceClass.A1, ServiceClass.M1));
        mapOf10age.put("\u0413\u0420\u0410\u041d\u0414", Arrays.asList(ServiceClass.A1, ServiceClass.I1, ServiceClass.M1));
    }
}

