/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.tools.docgen;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.java.plugin.PathResolver;
import org.java.plugin.registry.Documentation;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginElement;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.PluginPrerequisite;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.tools.docgen.ClassPathPageSource;
import org.java.plugin.util.IoUtil;
import org.onemind.jxp.FilePageSource;
import org.onemind.jxp.JxpProcessingContext;
import org.onemind.jxp.JxpProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DocGenerator {
    private final PluginRegistry registry;
    private final PathResolver pathResolver;
    private JxpProcessor processor;
    private Collection<PluginDescriptor> allPluginDescriptors;
    private Collection<PluginFragment> allPluginFragments;
    private Collection<ExtensionPoint> allExtensionPoints;
    private Collection<Extension> allExtensions;
    private String documentationOverview;
    private String stylesheet;
    private String outputEncoding = "UTF-8";

    private static String getRelativePath(int level) {
        StringBuilder result = new StringBuilder();
        if (level > 0) {
            for (int i = 0; i < level; ++i) {
                if (i > 0) {
                    result.append("/");
                }
                result.append("..");
            }
        } else {
            result.append(".");
        }
        return result.toString();
    }

    public DocGenerator(PluginRegistry aRegistry, PathResolver aPathResolver) throws Exception {
        this(aRegistry, aPathResolver, DocGenerator.class.getName().substring(0, DocGenerator.class.getName().lastIndexOf(46)).replace('.', '/') + "/templates/", null);
    }

    public DocGenerator(PluginRegistry aRegistry, PathResolver aPathResolver, String templatesPath, String templatesEncoding) throws Exception {
        this(aRegistry, aPathResolver, new JxpProcessor(new ClassPathPageSource(templatesPath, templatesEncoding)));
    }

    public DocGenerator(PluginRegistry aRegistry, PathResolver aPathResolver, File templatesFolder, String templatesEncoding) throws Exception {
        this(aRegistry, aPathResolver, new JxpProcessor(new FilePageSource(templatesFolder.getCanonicalPath())));
    }

    private DocGenerator(PluginRegistry aRegistry, PathResolver aPathResolver, JxpProcessor proc) {
        this.registry = aRegistry;
        this.pathResolver = aPathResolver;
        this.processor = proc;
        this.allPluginDescriptors = this.getAllPluginDescriptors();
        this.allPluginFragments = this.getAllPluginFragments();
        this.allExtensionPoints = this.getAllExtensionPoints();
        this.allExtensions = this.getAllExtensions();
    }

    public String getDocumentationOverview() {
        return this.documentationOverview;
    }

    public void setDocumentationOverview(String aDocumentationOverview) {
        this.documentationOverview = aDocumentationOverview;
    }

    public String getStylesheet() {
        return this.stylesheet;
    }

    public void setStylesheet(String aStylesheet) {
        this.stylesheet = aStylesheet;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(String encoding) {
        this.outputEncoding = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTemplateFile(Map<String, Object> ctx, String template, File outFile) throws Exception {
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(outFile, false)), this.outputEncoding);
        try {
            this.processor.process(template, new JxpProcessingContext(out, ctx));
        }
        finally {
            ((Writer)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTemplateContent(Map<String, Object> ctx, String template, File outFile) throws Exception {
        File tmpFile = File.createTempFile("~jpf-jxp", null);
        tmpFile.deleteOnExit();
        OutputStreamWriter tmpOut = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(tmpFile, false)), "UTF-8");
        try {
            tmpOut.write(template);
        }
        finally {
            ((Writer)tmpOut).close();
        }
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(outFile, false)), this.outputEncoding);
        try {
            JxpProcessor proc = new JxpProcessor(new FilePageSource(tmpFile.getParentFile().getCanonicalPath()));
            proc.process(tmpFile.getName(), new JxpProcessingContext(out, ctx));
        }
        finally {
            tmpFile.delete();
            ((Writer)out).close();
        }
    }

    public void generate(File destDir) throws Exception {
        Map<String, Object> ctx = this.createConext(0);
        this.processTemplateFile(ctx, "index.jxp", new File(destDir, "index.html"));
        this.generateCss(destDir);
        ctx = this.createConext(0);
        this.processTemplateFile(ctx, "menu.jxp", new File(destDir, "menu.html"));
        ctx = this.createConext(0);
        if (this.documentationOverview != null) {
            ctx.put("overview", this.documentationOverview.replaceAll("(?i)(?d)(?m).*<body>(.*)</body>.*", "$1"));
        } else {
            ctx.put("overview", "");
        }
        this.processTemplateFile(ctx, "overview.jxp", new File(destDir, "overview.html"));
        ctx = this.createConext(0);
        this.processTemplateFile(ctx, "allplugins.jxp", new File(destDir, "allplugins.html"));
        ctx = this.createConext(0);
        this.processTemplateFile(ctx, "allfragments.jxp", new File(destDir, "allfragments.html"));
        ctx = this.createConext(0);
        this.processTemplateFile(ctx, "allextpoints.jxp", new File(destDir, "allextpoints.html"));
        ctx = this.createConext(0);
        this.processTemplateFile(ctx, "allexts.jxp", new File(destDir, "allexts.html"));
        ctx = this.createConext(0);
        this.processTemplateFile(ctx, "tree.jxp", new File(destDir, "tree.html"));
        for (PluginDescriptor descriptor : this.registry.getPluginDescriptors()) {
            this.generateForPluginDescriptor(destDir, descriptor);
        }
    }

    private void generateCss(File destDir) throws Exception {
        Map<String, Object> ctx = this.createConext(0);
        if (this.stylesheet == null) {
            this.processTemplateFile(ctx, "stylesheet.jxp", new File(destDir, "stylesheet.css"));
        } else {
            this.processTemplateContent(ctx, this.stylesheet, new File(destDir, "stylesheet.css"));
        }
    }

    private void generateForPluginDescriptor(File baseDir, PluginDescriptor descr) throws Exception {
        File dir;
        File destDir = new File(baseDir, descr.getId());
        destDir.mkdirs();
        File srcDocsFolder = IoUtil.url2file(this.pathResolver.resolvePath(descr, descr.getDocsPath()));
        if (srcDocsFolder != null && srcDocsFolder.isDirectory()) {
            File destDocsFolder = new File(destDir, "extra");
            destDocsFolder.mkdir();
            IoUtil.copyFolder(srcDocsFolder, destDocsFolder, true);
        }
        LinkedList<PluginDescriptor> dependedPlugins = new LinkedList<PluginDescriptor>();
        block0: for (PluginDescriptor dependedDescr : this.registry.getPluginDescriptors()) {
            if (dependedDescr.getId().equals(descr.getId())) continue;
            for (PluginPrerequisite pre : dependedDescr.getPrerequisites()) {
                if (!pre.getPluginId().equals(descr.getId()) || !pre.matches()) continue;
                dependedPlugins.add(dependedDescr);
                continue block0;
            }
        }
        Map<String, Object> ctx = this.createConext(1);
        ctx.put("descriptor", descr);
        ctx.put("dependedPlugins", dependedPlugins);
        this.processTemplateFile(ctx, "plugin.jxp", new File(destDir, "index.html"));
        for (PluginFragment fragment : descr.getFragments()) {
            this.generateForPluginFragment(baseDir, fragment);
        }
        if (!descr.getExtensionPoints().isEmpty()) {
            File extPointsDir = new File(destDir, "extp");
            extPointsDir.mkdir();
            for (ExtensionPoint extPoint : descr.getExtensionPoints()) {
                ctx = this.createConext(3);
                ctx.put("extPoint", extPoint);
                dir = new File(extPointsDir, extPoint.getId());
                dir.mkdir();
                this.processTemplateFile(ctx, "extpoint.jxp", new File(dir, "index.html"));
            }
        }
        if (!descr.getExtensions().isEmpty()) {
            File extsDir = new File(destDir, "ext");
            extsDir.mkdir();
            for (Extension ext : descr.getExtensions()) {
                ctx = this.createConext(3);
                ctx.put("ext", ext);
                dir = new File(extsDir, ext.getId());
                dir.mkdir();
                this.processTemplateFile(ctx, "ext.jxp", new File(dir, "index.html"));
            }
        }
    }

    private void generateForPluginFragment(File baseDir, PluginFragment fragment) throws Exception {
        File destDir = new File(baseDir, fragment.getId());
        destDir.mkdirs();
        Map<String, Object> ctx = this.createConext(1);
        ctx.put("fragment", fragment);
        this.processTemplateFile(ctx, "fragment.jxp", new File(destDir, "index.html"));
    }

    private Map<String, Object> createConext(int level) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String relativePath = DocGenerator.getRelativePath(level);
        result.put("tool", new Tool(relativePath));
        result.put("relativePath", relativePath);
        result.put("registry", this.registry);
        result.put("allPluginDescriptors", this.allPluginDescriptors);
        result.put("allPluginFragments", this.allPluginFragments);
        result.put("allExtensionPoints", this.allExtensionPoints);
        result.put("allExtensions", this.allExtensions);
        return result;
    }

    private Collection<PluginDescriptor> getAllPluginDescriptors() {
        LinkedList<PluginDescriptor> result = new LinkedList<PluginDescriptor>();
        result.addAll(this.registry.getPluginDescriptors());
        Collections.sort(result, new IdentityComparator());
        return Collections.unmodifiableCollection(result);
    }

    private Collection<PluginFragment> getAllPluginFragments() {
        LinkedList<PluginFragment> result = new LinkedList<PluginFragment>();
        result.addAll(this.registry.getPluginFragments());
        Collections.sort(result, new IdentityComparator());
        return Collections.unmodifiableCollection(result);
    }

    private Collection<ExtensionPoint> getAllExtensionPoints() {
        LinkedList<ExtensionPoint> result = new LinkedList<ExtensionPoint>();
        for (PluginDescriptor descriptor : this.registry.getPluginDescriptors()) {
            result.addAll(descriptor.getExtensionPoints());
        }
        Collections.sort(result, new IdentityComparator());
        return Collections.unmodifiableCollection(result);
    }

    private Collection<Extension> getAllExtensions() {
        LinkedList<Extension> result = new LinkedList<Extension>();
        for (PluginDescriptor descriptor : this.registry.getPluginDescriptors()) {
            result.addAll(descriptor.getExtensions());
        }
        Collections.sort(result, new IdentityComparator());
        return Collections.unmodifiableCollection(result);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IdentityComparator
    implements Comparator<Identity> {
        IdentityComparator() {
        }

        @Override
        public int compare(Identity o1, Identity o2) {
            return o1.getId().compareTo(o2.getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Tool {
        private String relativePath;

        protected Tool(String aRelativePath) {
            this.relativePath = aRelativePath;
        }

        public String getLink(Documentation.Reference<?> ref) {
            PluginElement element;
            PluginFragment fragment;
            if (this.isAbsoluteUrl(ref.getRef())) {
                return ref.getRef();
            }
            Object idt = ref.getDeclaringIdentity();
            String id = idt instanceof PluginElement ? ((fragment = (element = (PluginElement)idt).getDeclaringPluginFragment()) != null ? fragment.getId() : element.getDeclaringPluginDescriptor().getId()) : idt.getId();
            return this.relativePath + "/" + id + "/extra/" + ref.getRef();
        }

        public boolean isAbsoluteUrl(String url) {
            try {
                String protocol = new URL(url).getProtocol();
                return protocol != null && protocol.length() > 0;
            }
            catch (MalformedURLException e) {
                return false;
            }
        }

        public String processDocText(String text) {
            if (text == null || text.length() == 0) {
                return "";
            }
            return text.replaceAll("(?d)(?m)\\$\\{relativePath\\}", this.relativePath);
        }
    }
}

