/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.sirena2000.keymanager;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.components.text.RichTextFlow;
import com.gridnine.xtrip.client.fx.core.lib.components.text.TextHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TilesSpace;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.ui.tab.BaseContentPane;
import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.standard.helpers.ListParametersHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.service.AssetService;
import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.gds.sirena2000.KeyInfo;
import com.gridnine.xtrip.common.gds.sirena2000.model.SirenaGdsAccount;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.midoffice.KeyPairEntry;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.gds.GdsAccountIndex;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.File;
import java.nio.file.Files;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ObservableObjectValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.stage.FileChooser;
import javafx.util.Pair;

class SirenaKeyManagerPane
extends BaseContentPane {
    protected final ObservableMutex mutex;
    protected final EntityBoxWidget<BaseGdsAccount> gdsAccountWidget;
    protected final EntityBoxWidget<SalesPoint> salesPointWidget;
    protected final DataViewWidget<KeyPairEntry> keyPairsWidget;

    private static void append(StringBuilder out, MessageType type, String message, Object ... params) {
        out.append("<b>").append(type.toString()).append("</b>: ").append(L10nResourcesManager.getStr((String)message, (Object[])params)).append("<br>");
    }

    private static byte[] getDigest(PublicKey key) throws Exception {
        return MessageDigest.getInstance("SHA-1").digest(key.getEncoded());
    }

    SirenaKeyManagerPane(ObservableMutex mtx) {
        this.mutex = mtx;
        GridContainer grid = new GridContainer(3);
        this.gdsAccountWidget = new EntityBoxWidget(BaseGdsAccount.class, false);
        this.gdsAccountWidget.setListParametersSupplier(() -> {
            IndexListParameters result = new IndexListParameters();
            result.setIndexType(GdsAccountIndex.class);
            result.getSearchCriterions().add(SearchCriterion.eq((String)GdsAccountIndex.Property.gds.name(), (Object)GdsName.SIRENA));
            ListParametersHelper.setColumns((IndexListParameters)result, (String[])new String[]{GdsAccountIndex.Property.name.name(), GdsAccountIndex.Property.agency.name()});
            return result;
        });
        this.gdsAccountWidget.setFieldName("\u0423\u0447\u0451\u0442\u043d\u0430\u044f \u0437\u0430\u043f\u0438\u0441\u044c \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
        grid.getCells().add((Object)new GridCell("\u0423\u0447\u0451\u0442\u043d\u0430\u044f \u0437\u0430\u043f\u0438\u0441\u044c \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", this.gdsAccountWidget));
        this.salesPointWidget = new EntityBoxWidget(SalesPoint.class, false);
        this.salesPointWidget.setFieldName("\u0422\u043e\u0447\u043a\u0430 \u043f\u0440\u043e\u0434\u0430\u0436");
        grid.getCells().add((Object)new GridCell("\u0422\u043e\u0447\u043a\u0430 \u043f\u0440\u043e\u0434\u0430\u0436", this.salesPointWidget));
        grid.getCells().add((Object)GridCell.NEW_ROW_MARKER);
        this.keyPairsWidget = new DataViewWidget(true, mtx);
        TableColumnSettings col = new TableColumnSettings();
        col.setId("alias");
        col.setDisplayName("Client ID");
        col.setSortable(false);
        this.keyPairsWidget.getTableView().getColumns().add((Object)col.createColumn(item -> item.getAlias()));
        col = new TableColumnSettings();
        col.setId("digest");
        col.setDisplayName("\u0414\u0430\u0439\u0434\u0436\u0435\u0441\u0442");
        col.setSortable(false);
        this.keyPairsWidget.getTableView().getColumns().add((Object)col.createColumn(item -> {
            KeyPair keyPair = item.getKeyPair();
            if (keyPair == null || keyPair.getPublic() == null) {
                return null;
            }
            try {
                return Base64.encode((byte[])SirenaKeyManagerPane.getDigest(keyPair.getPublic()));
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
                return null;
            }
        }));
        GridCell cell = new GridCell("\u041a\u043b\u044e\u0447\u0438", this.keyPairsWidget);
        cell.setColSpan(Integer.MAX_VALUE);
        grid.getCells().add((Object)cell);
        final Tile tile = new Tile("main", "\u041a\u043b\u044e\u0447\u0438 \u0421\u0438\u0440\u0435\u043d\u0430-2000", null, (Node)grid);
        tile.setHelp(() -> new QuickHelp("<html><b>\u0418\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442 \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043a\u043b\u044e\u0447\u0430\u043c\u0438 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0421\u0438\u0440\u0435\u043d\u0430-2000</b><br><br>\u0427\u0442\u043e\u0431\u044b \u043f\u0443\u043d\u043a\u0442\u044b \u043c\u0435\u043d\u044e \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043a\u043b\u044e\u0447\u0430\u043c\u0438 \u0441\u0442\u0430\u043b\u0438 \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u043c\u0438 \u043d\u0443\u0436\u043d\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c <i>\u0423\u0447\u0451\u0442\u043d\u0443\u044e \u0437\u0430\u043f\u0438\u0441\u044c \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f</i> \u0438 <i>\u0422\u043e\u0447\u043a\u0443 \u043f\u0440\u043e\u0434\u0430\u0436</i>.<br><br>\u0414\u043b\u044f \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u043d\u043e\u0432\u043e\u0433\u043e \u043a\u043b\u044e\u0447\u0430 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0421\u0438\u0440\u0435\u043d\u0430 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043f\u0440\u043e\u0434\u0435\u043b\u0430\u0442\u044c \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u0448\u0430\u0433\u0438:<br>1. \u0421\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0438 \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u043a\u043b\u044e\u0447 \u0432 \u041c\u041e\u041c - \u043a\u043d\u043e\u043f\u043a\u0430 <i>\u0421\u043e\u0437\u0434\u0430\u0442\u044c</i>.<br>2. \u041e\u043f\u0443\u0431\u043b\u0438\u043a\u043e\u0432\u0430\u0442\u044c \u043a\u043b\u044e\u0447 \u0432 \u0421\u0438\u0440\u0435\u043d\u0435 - \u043a\u043d\u043e\u043f\u043a\u0430 <i>\u041e\u043f\u0443\u0431\u043b\u0438\u043a\u043e\u0432\u0430\u0442\u044c</i>.<br>3. \u0421\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0434\u0430\u0439\u0434\u0436\u0435\u0441\u0442 \u043a\u043b\u044e\u0447\u0430 \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430 \u043d\u0430\u0436\u0430\u0432 \u043f\u0440\u0430\u0432\u0443\u044e \u043a\u043d\u043e\u043f\u043a\u0443 \u043c\u044b\u0448\u0438 \u0438 \u0432\u044b\u0431\u0440\u0430\u0432 \u043f\u0443\u043d\u043a\u0442 \u043c\u0435\u043d\u044e <i>\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0435\u043a\u0441\u0442</i>.<br>4. \u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0434\u0430\u0439\u0434\u0436\u0435\u0441\u0442 \u0432 \u0421\u0438\u0440\u0435\u043d\u0443 \u0447\u0435\u0440\u0435\u0437 \u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0437\u0430\u044f\u0432\u043a\u0430\u043c\u0438 https://private.sirena-travel.ru/demands/<br><br>\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441 \u043a\u043b\u044e\u0447\u0430 \u0432 \u0421\u0438\u0440\u0435\u043d\u0435 \u043c\u043e\u0436\u043d\u043e \u043d\u0430\u0436\u0430\u0432 \u043a\u043d\u043e\u043f\u043a\u0443 <i>\u0421\u0442\u0430\u0442\u0443\u0441</i>."));
        tile.getActions().addAll(this.createActions());
        this.gdsAccountWidget.valueProperty().addListener(src -> tile.revalidateActions());
        this.salesPointWidget.valueProperty().addListener(src -> tile.revalidateActions());
        this.keyPairsWidget.getTableView().getSelectionModel().selectedItemProperty().addListener(src -> tile.revalidateActions());
        this.keyPairsWidget.setHandler((DataViewHandler)new DataViewHandler<KeyPairEntry>(){

            protected void reloadData(int offset, List<Pair<String, SortOrder>> sorting) {
                Notifications.get().submitTask(() -> {
                    SearchQuery query = new SearchQuery();
                    query.getCriteria().getOrders().put(KeyPairEntry.Property.alias.name(), SortOrder.ASC);
                    SearchResult res = ((AssetService)RpcServiceManager.get().getService(AssetService.class)).search(ServiceInvocationContext.get(), KeyPairEntry.class, query);
                    FxUtil.submitToFxThread(() -> {
                        this.getData().setAll((Collection)res.getData());
                        tile.revalidateActions();
                    });
                }, this.getMutex());
            }

            protected int getOffset() {
                return 0;
            }

            protected int getLimit() {
                return Integer.MAX_VALUE;
            }
        });
        this.composePane((Node)new TilesSpace(1){
            {
                super(x0);
                this.addTiles(new Tile[]{tile});
            }
        }, null, null, null);
        FxUtil.submitToFxThread(() -> this.keyPairsWidget.reloadData());
    }

    private List<TileAction<Node, GridContainer>> createActions() {
        ArrayList<TileAction<Node, GridContainer>> result = new ArrayList<TileAction<Node, GridContainer>>();
        result.add(new TileAction<Node, GridContainer>(){

            public boolean isEnabled(Tile<Node, GridContainer> tile) {
                return SirenaKeyManagerPane.this.gdsAccountWidget.getValue() != null;
            }

            public double getWeight() {
                return 10.0;
            }

            public String getName(Tile<Node, GridContainer> tile) {
                return "\u0421\u043e\u0437\u0434\u0430\u0442\u044c";
            }

            public String getDescription(Tile<Node, GridContainer> tile) {
                return "\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u043a\u043b\u044e\u0447 \u0438 \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0435\u0433\u043e \u0432 \u0441\u043f\u0438\u0441\u043e\u043a.";
            }

            public void execute(Control source, Tile<Node, GridContainer> tile, boolean alt) {
                Notifications.get().submitTask(SirenaKeyManagerPane.this::doCreate, SirenaKeyManagerPane.this.mutex);
            }
        });
        result.add(new TileAction<Node, GridContainer>(){

            public boolean isEnabled(Tile<Node, GridContainer> tile) {
                return SirenaKeyManagerPane.this.gdsAccountWidget.getValue() != null;
            }

            public double getWeight() {
                return 20.0;
            }

            public String getName(Tile<Node, GridContainer> tile) {
                return "\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c";
            }

            public String getDescription(Tile<Node, GridContainer> tile) {
                return "\u0421\u0434\u0435\u043b\u0430\u0442\u044c \u043a\u043e\u043f\u0438\u044e \u043a\u043b\u044e\u0447\u0430 \u0438 \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0435\u0451 \u0432 \u0441\u043f\u0438\u0441\u043e\u043a.";
            }

            public void execute(Control source, Tile<Node, GridContainer> tile, boolean alt) {
                EntityBoxWidget widget = new EntityBoxWidget(BaseGdsAccount.class, false);
                widget.setListParametersSupplier(() -> {
                    IndexListParameters result = new IndexListParameters();
                    result.setIndexType(GdsAccountIndex.class);
                    result.getSearchCriterions().add(SearchCriterion.eq((String)GdsAccountIndex.Property.gds.name(), (Object)GdsName.SIRENA));
                    ListParametersHelper.setColumns((IndexListParameters)result, (String[])new String[]{GdsAccountIndex.Property.name.name(), GdsAccountIndex.Property.agency.name()});
                    return result;
                });
                widget.setFieldName("\u0423\u0447\u0451\u0442\u043d\u0430\u044f \u0437\u0430\u043f\u0438\u0441\u044c \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                new Dialog().setTitle("\u041a\u0443\u0434\u0430 \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043a\u043b\u044e\u0447?").setBody((Node)widget).setMessage("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0447\u0451\u0442\u043d\u0443\u044e \u0437\u0430\u043f\u0438\u0441\u044c, \u043a \u043a\u043e\u0442\u043e\u0440\u043e\u0439\n\u0431\u0443\u0434\u0435\u0442 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u0430 \u043a\u043e\u043f\u0438\u044f \u043a\u043b\u044e\u0447\u0430.").addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, "\u0417\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435", () -> {
                    EntityReference ref = widget.getValue();
                    Notifications.get().submitTask(() -> SirenaKeyManagerPane.this.doCopy((EntityReference<BaseGdsAccount>)ref), SirenaKeyManagerPane.this.mutex);
                }, (BooleanExpression)Bindings.isNotNull((ObservableObjectValue)widget.valueProperty())).show((Node)source);
            }
        });
        result.add(new TileAction<Node, GridContainer>(){

            public boolean isEnabled(Tile<Node, GridContainer> tile) {
                return SirenaKeyManagerPane.this.gdsAccountWidget.getValue() != null;
            }

            public double getWeight() {
                return 30.0;
            }

            public String getName(Tile<Node, GridContainer> tile) {
                return "\u0423\u0434\u0430\u043b\u0438\u0442\u044c";
            }

            public String getDescription(Tile<Node, GridContainer> tile) {
                return "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u043b\u044e\u0447 \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430.";
            }

            public void execute(Control source, Tile<Node, GridContainer> tile, boolean alt) {
                Dialog.confirm((Node)source, (String)"\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u043b\u044e\u0447 \u0434\u043b\u044f \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0439 \u0443\u0447\u0451\u0442\u043d\u043e\u0439 \u0437\u0430\u043f\u0438\u0441\u0438 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f?", () -> Notifications.get().submitTask(SirenaKeyManagerPane.this::doDelete, SirenaKeyManagerPane.this.mutex));
            }
        });
        result.add(new TileAction<Node, GridContainer>(){

            public boolean isEnabled(Tile<Node, GridContainer> tile) {
                return SirenaKeyManagerPane.this.gdsAccountWidget.getValue() != null && SirenaKeyManagerPane.this.salesPointWidget.getValue() != null;
            }

            public double getWeight() {
                return 40.0;
            }

            public String getName(Tile<Node, GridContainer> tile) {
                return "\u0421\u0442\u0430\u0442\u0443\u0441";
            }

            public String getDescription(Tile<Node, GridContainer> tile) {
                return "\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441 \u043a\u043b\u044e\u0447\u0430 \u0432 \u0421\u0438\u0440\u0435\u043d\u0435.";
            }

            public void execute(Control source, Tile<Node, GridContainer> tile, boolean alt) {
                Notifications.get().submitTask(SirenaKeyManagerPane.this::doStatus, SirenaKeyManagerPane.this.mutex);
            }
        });
        result.add(new TileAction<Node, GridContainer>(){

            public boolean isEnabled(Tile<Node, GridContainer> tile) {
                return SirenaKeyManagerPane.this.gdsAccountWidget.getValue() != null && SirenaKeyManagerPane.this.salesPointWidget.getValue() != null;
            }

            public double getWeight() {
                return 50.0;
            }

            public String getName(Tile<Node, GridContainer> tile) {
                return "\u041e\u043f\u0443\u0431\u043b\u0438\u043a\u043e\u0432\u0430\u0442\u044c";
            }

            public String getDescription(Tile<Node, GridContainer> tile) {
                return "\u041e\u043f\u0443\u0431\u043b\u0438\u043a\u043e\u0432\u0430\u0442\u044c \u043a\u043b\u044e\u0447 \u0432 \u0421\u0438\u0440\u0435\u043d\u0435.";
            }

            public void execute(Control source, Tile<Node, GridContainer> tile, boolean alt) {
                Dialog.confirm((Node)source, (String)"\u041e\u043f\u0443\u0431\u043b\u0438\u043a\u043e\u0432\u0430\u0442\u044c \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0421\u0438\u0440\u0435\u043d\u0430 \u043a\u043b\u044e\u0447 \u0434\u043b\u044f \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0439 \u0443\u0447\u0451\u0442\u043d\u043e\u0439 \u0437\u0430\u043f\u0438\u0441\u0438 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f?", () -> Notifications.get().submitTask(SirenaKeyManagerPane.this::doPublish, SirenaKeyManagerPane.this.mutex));
            }
        });
        result.add(new TileAction<Node, GridContainer>(){

            public boolean isEnabled(Tile<Node, GridContainer> tile) {
                return SirenaKeyManagerPane.this.gdsAccountWidget.getValue() != null;
            }

            public double getWeight() {
                return 60.0;
            }

            public String getName(Tile<Node, GridContainer> tile) {
                return "\u042d\u043a\u0441\u043f\u043e\u0440\u0442";
            }

            public String getDescription(Tile<Node, GridContainer> tile) {
                return "\u0412\u044b\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043a\u043b\u044e\u0447 \u0432 \u0444\u0430\u0439\u043b.";
            }

            public void execute(Control source, Tile<Node, GridContainer> tile, boolean alt) {
                FileChooser fileChooser = new FileChooser();
                fileChooser.setTitle("\u0424\u0430\u0439\u043b \u0434\u043b\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430 \u043a\u043b\u044e\u0447\u0430");
                File dir = ClientSettings.get().getFileChooserDirectory();
                if (UiUtil.isFileValid((File)dir) && dir.isDirectory()) {
                    fileChooser.setInitialDirectory(dir);
                } else {
                    fileChooser.setInitialDirectory(Environment.getDataFolder());
                }
                File file = fileChooser.showSaveDialog(SirenaKeyManagerPane.this.getScene().getWindow());
                if (file == null) {
                    return;
                }
                ClientSettings.get().setFileChooserDirectory(file.getParentFile());
                ClientSettings.get().save();
                Notifications.get().submitTask(() -> SirenaKeyManagerPane.this.doExport(file), SirenaKeyManagerPane.this.mutex);
            }
        });
        result.add(new TileAction<Node, GridContainer>(){

            public boolean isEnabled(Tile<Node, GridContainer> tile) {
                return true;
            }

            public double getWeight() {
                return 70.0;
            }

            public String getName(Tile<Node, GridContainer> tile) {
                return "\u0418\u043c\u043f\u043e\u0440\u0442";
            }

            public String getDescription(Tile<Node, GridContainer> tile) {
                return "\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043a\u043b\u044e\u0447 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430.";
            }

            public void execute(Control source, Tile<Node, GridContainer> tile, boolean alt) {
                FileChooser fileChooser = new FileChooser();
                fileChooser.setTitle("\u0424\u0430\u0439\u043b \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u043a\u043b\u044e\u0447\u0430");
                File dir = ClientSettings.get().getFileChooserDirectory();
                if (UiUtil.isFileValid((File)dir) && dir.isDirectory()) {
                    fileChooser.setInitialDirectory(dir);
                } else {
                    fileChooser.setInitialDirectory(Environment.getDataFolder());
                }
                File file = fileChooser.showOpenDialog(SirenaKeyManagerPane.this.getScene().getWindow());
                if (file == null) {
                    return;
                }
                ClientSettings.get().setFileChooserDirectory(file.getParentFile());
                ClientSettings.get().save();
                Notifications.get().submitTask(() -> SirenaKeyManagerPane.this.doImport(file), SirenaKeyManagerPane.this.mutex);
            }
        });
        return result;
    }

    protected void doCreate() throws Exception {
        ValueHolder accountRef = new ValueHolder();
        FxUtil.waitForFxThread(() -> accountRef.set((Object)this.gdsAccountWidget.getValue()));
        EntityContainer accountCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), (EntityReference)accountRef.get());
        String clientId = ((SirenaGdsAccount)accountCtr.getEntity()).getAccount();
        if (this.findKeyPairEntry(clientId) != null) {
            Notifications.get().showFlashNotification(String.format("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430.\n\u0414\u043b\u044f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 %s \u043a\u043b\u044e\u0447 \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442", clientId), null);
            return;
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("operation", "generate");
        data.put("ALIAS", clientId);
        ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processSync(ServiceInvocationContext.get(), "midoffice:key-pair-operation", data);
        FxUtil.submitToFxThread(() -> this.keyPairsWidget.reloadData());
    }

    protected void doCopy(EntityReference<BaseGdsAccount> targetAccountRef) throws Exception {
        EntityContainer targetAccountCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), targetAccountRef);
        String targetClientId = ((SirenaGdsAccount)targetAccountCtr.getEntity()).getAccount();
        if (this.findKeyPairEntry(targetClientId) != null) {
            Notifications.get().showFlashNotification(String.format("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430.\n\u0414\u043b\u044f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 %s \u043a\u043b\u044e\u0447 \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442", targetClientId), null);
            return;
        }
        ValueHolder accountRef = new ValueHolder();
        FxUtil.waitForFxThread(() -> accountRef.set((Object)this.gdsAccountWidget.getValue()));
        EntityContainer accountCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), (EntityReference)accountRef.get());
        String clientId = ((SirenaGdsAccount)accountCtr.getEntity()).getAccount();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("operation", "generate");
        data.put("SRC_ALIAS", clientId);
        data.put("ALIAS", targetClientId);
        ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processSync(ServiceInvocationContext.get(), "midoffice:key-pair-operation", data);
        FxUtil.submitToFxThread(() -> this.keyPairsWidget.reloadData());
    }

    protected void doDelete() throws Exception {
        ValueHolder accountRef = new ValueHolder();
        FxUtil.waitForFxThread(() -> accountRef.set((Object)this.gdsAccountWidget.getValue()));
        EntityContainer accountCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), (EntityReference)accountRef.get());
        String clientId = ((SirenaGdsAccount)accountCtr.getEntity()).getAccount();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("operation", "delete");
        data.put("ALIAS", clientId);
        ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processSync(ServiceInvocationContext.get(), "midoffice:key-pair-operation", data);
        FxUtil.submitToFxThread(() -> this.keyPairsWidget.reloadData());
    }

    protected void doStatus() throws Exception {
        ValueHolder accountRef = new ValueHolder();
        ValueHolder spRef = new ValueHolder();
        FxUtil.waitForFxThread(() -> {
            accountRef.set((Object)this.gdsAccountWidget.getValue());
            spRef.set((Object)this.salesPointWidget.getValue());
        });
        EntityContainer accountCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), (EntityReference)accountRef.get());
        String clientId = ((SirenaGdsAccount)accountCtr.getEntity()).getAccount();
        SalesContext salesContext = new SalesContext();
        salesContext.setSalesPoint((EntityReference)spRef.get());
        salesContext.setAgent(Prefetched.getData().getCurrentAgentData().getAgent());
        Map data = new HashMap<String, Object>();
        data.put("GDS", GdsName.SIRENA);
        data.put("SALES_CONTEXT", salesContext);
        data.put("GDS_ACCOUNT", accountCtr);
        data = ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processSync(ServiceInvocationContext.get(), "gds:sirena:key-info", data);
        this.displayKeyInfo((KeyInfo)data.get("KEY_INFO"), clientId);
    }

    protected void doPublish() throws Exception {
        ValueHolder accountRef = new ValueHolder();
        ValueHolder spRef = new ValueHolder();
        FxUtil.waitForFxThread(() -> {
            accountRef.set((Object)this.gdsAccountWidget.getValue());
            spRef.set((Object)this.salesPointWidget.getValue());
        });
        EntityContainer accountCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), (EntityReference)accountRef.get());
        String clientId = ((SirenaGdsAccount)accountCtr.getEntity()).getAccount();
        SalesContext salesContext = new SalesContext();
        salesContext.setSalesPoint((EntityReference)spRef.get());
        salesContext.setAgent(Prefetched.getData().getCurrentAgentData().getAgent());
        KeyPairEntry keyPairEntry = this.findKeyPairEntry(clientId);
        if (keyPairEntry == null) {
            Notifications.get().showFlashNotification(String.format("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430.\n\u0414\u043b\u044f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 %s \u043a\u043b\u044e\u0447 \u043d\u0435 \u0437\u0430\u0432\u0435\u0434\u0451\u043d", clientId), null);
            return;
        }
        Map data = new HashMap<String, Object>();
        data.put("GDS", GdsName.SIRENA);
        data.put("SALES_CONTEXT", salesContext);
        data.put("GDS_ACCOUNT", accountCtr);
        data.put("PUBLIC_KEY", keyPairEntry.getKeyPair().getPublic());
        data = ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processSync(ServiceInvocationContext.get(), "gds:sirena:publish-public-key", data);
        Notifications.get().showFlashNotification(String.format("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0446\u0438\u044e \u043a\u043b\u044e\u0447\u0430 \u0434\u043b\u044f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 %s \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d.", clientId), null);
        this.displayKeyInfo((KeyInfo)data.get("KEY_INFO"), clientId);
    }

    protected void doExport(File file) throws Exception {
        ValueHolder accountRef = new ValueHolder();
        FxUtil.waitForFxThread(() -> accountRef.set((Object)this.gdsAccountWidget.getValue()));
        EntityContainer accountCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), (EntityReference)accountRef.get());
        String clientId = ((SirenaGdsAccount)accountCtr.getEntity()).getAccount();
        KeyPairEntry keyPairEntry = this.findKeyPairEntry(clientId);
        if (keyPairEntry == null) {
            Notifications.get().showFlashNotification(String.format("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430.\n\u0414\u043b\u044f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 %s \u043a\u043b\u044e\u0447 \u043d\u0435 \u0437\u0430\u0432\u0435\u0434\u0451\u043d", clientId), null);
            return;
        }
        FxUtil.saveToFile((File)file, (byte[])XSUtil.toByteArray((XSSerializable)keyPairEntry));
        Notifications.get().showFlashNotification(String.format("\u041a\u043b\u044e\u0447 \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u0432 \u0444\u0430\u0439\u043b\n%s", file), null);
    }

    protected void doImport(File file) throws Exception {
        KeyPairEntry newKeyPairEntry = new KeyPairEntry();
        XUtil.fromBytes((byte[])Files.readAllBytes(file.toPath()), (XSerializable)newKeyPairEntry);
        String clientId = newKeyPairEntry.getAlias();
        KeyPairEntry oldKeyPairEntry = this.findKeyPairEntry(clientId);
        if (oldKeyPairEntry != null) {
            FxUtil.submitToFxThread(() -> Dialog.confirm((Node)this, (String)String.format("\u041a\u043b\u044e\u0447 \u0434\u043b\u044f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 %s \u0443\u0436\u0435 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435.\n\u0417\u0430\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u0442\u0430\u0440\u044b\u0439 \u043a\u043b\u044e\u0447 \u043d\u0430 \u043d\u043e\u0432\u044b\u0439?", clientId), () -> Notifications.get().submitTask(() -> this.doImport(newKeyPairEntry, oldKeyPairEntry), this.mutex)));
        } else {
            this.doImport(newKeyPairEntry, oldKeyPairEntry);
        }
    }

    private void doImport(KeyPairEntry newKeyPairEntry, KeyPairEntry oldKeyPairEntry) throws Exception {
        AssetService assetService = (AssetService)RpcServiceManager.get().getService(AssetService.class);
        if (oldKeyPairEntry != null) {
            assetService.delete(ServiceInvocationContext.get(), (BaseAsset)oldKeyPairEntry);
        }
        assetService.save(ServiceInvocationContext.get(), (BaseAsset)newKeyPairEntry);
        Notifications.get().showFlashNotification(String.format("\u041a\u043b\u044e\u0447 \u0438\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u0434\u043b\u044f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 %s", newKeyPairEntry.getAlias()), null);
        FxUtil.submitToFxThread(() -> this.keyPairsWidget.reloadData());
    }

    private void displayKeyInfo(KeyInfo keyInfo, String clientId) throws Exception {
        KeyPairEntry keyPairEntry;
        KeyPair keyPair;
        StringBuilder buf = new StringBuilder("<html>");
        if (keyInfo.getCurrentClientKeyDigest() != null) {
            SirenaKeyManagerPane.append(buf, MessageType.MESSAGE, "\u0414\u0430\u0439\u0434\u0436\u0435\u0441\u0442 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u043a\u043b\u044e\u0447\u0430: {0}", Base64.encode((byte[])keyInfo.getCurrentClientKeyDigest()));
            SirenaKeyManagerPane.append(buf, MessageType.MESSAGE, "\u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u043a\u043b\u044e\u0447\u0430: {0}", new SimpleDateFormat("dd.MM.yyyy").format(keyInfo.getCurrentClientKeyExpired()));
        }
        if (keyInfo.getUnconfirmedClientKeyDigest() != null) {
            SirenaKeyManagerPane.append(buf, MessageType.MESSAGE, "\u0414\u0430\u0439\u0434\u0436\u0435\u0441\u0442 \u043d\u0435\u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0451\u043d\u043d\u043e\u0433\u043e \u043a\u043b\u044e\u0447\u0430: {0}", Base64.encode((byte[])keyInfo.getUnconfirmedClientKeyDigest()));
        }
        if (keyInfo.getFutureClientKeyDigest() != null) {
            SirenaKeyManagerPane.append(buf, MessageType.MESSAGE, "\u0414\u0430\u0439\u0434\u0436\u0435\u0441\u0442 \u0431\u0443\u0434\u0443\u0449\u0435\u0433\u043e \u043a\u043b\u044e\u0447\u0430: {0}", Base64.encode((byte[])keyInfo.getFutureClientKeyDigest()));
        }
        KeyPair keyPair2 = keyPair = (keyPairEntry = this.findKeyPairEntry(clientId)) == null ? null : keyPairEntry.getKeyPair();
        if (keyPair == null) {
            SirenaKeyManagerPane.append(buf, MessageType.WARNING, "\u041a\u043b\u044e\u0447 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 MOM.", new Object[0]);
        } else if (keyInfo.getCurrentClientKeyDigest() == null) {
            if (keyInfo.getUnconfirmedClientKeyDigest() != null) {
                if (!Arrays.equals(SirenaKeyManagerPane.getDigest(keyPair.getPublic()), keyInfo.getUnconfirmedClientKeyDigest())) {
                    SirenaKeyManagerPane.append(buf, MessageType.ERROR, "\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043d\u0430 \u0434\u0430\u0439\u0434\u0436\u0435\u0441\u0442 \u043d\u0435 \u043f\u0440\u043e\u0439\u0434\u0435\u043d\u0430! \u041d\u0435\u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0451\u043d\u043d\u044b\u0439 \u043a\u043b\u044e\u0447 \u0432 Sirena \u043e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u043e\u0442 \u043a\u043b\u044e\u0447\u0430 \u0432 MOM!", new Object[0]);
                } else {
                    SirenaKeyManagerPane.append(buf, MessageType.MESSAGE, "\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u044c \u043a\u043b\u044e\u0447", new Object[0]);
                }
            } else {
                SirenaKeyManagerPane.append(buf, MessageType.MESSAGE, "\u041e\u0442\u043a\u0440\u044b\u0442\u044b\u0439 \u043a\u043b\u044e\u0447 \u043d\u0435 \u043e\u043f\u0443\u0431\u043b\u0438\u043a\u043e\u0432\u0430\u043d", new Object[0]);
            }
        } else if (!Arrays.equals(SirenaKeyManagerPane.getDigest(keyPair.getPublic()), keyInfo.getCurrentClientKeyDigest())) {
            SirenaKeyManagerPane.append(buf, MessageType.ERROR, "\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043d\u0430 \u0434\u0430\u0439\u0434\u0436\u0435\u0441\u0442 \u043d\u0435 \u043f\u0440\u043e\u0439\u0434\u0435\u043d\u0430! \u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u043a\u043b\u044e\u0447 \u0432 Sirena \u043e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u043e\u0442 \u043a\u043b\u044e\u0447\u0430 \u0432 MOM!", new Object[0]);
        } else if (keyInfo.getCurrentClientKeyExpired().before(new Date())) {
            SirenaKeyManagerPane.append(buf, MessageType.WARNING, "\u0417\u0430\u043a\u043e\u043d\u0447\u0438\u043b\u0441\u044f \u0441\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u043a\u043b\u044e\u0447\u0430", new Object[0]);
        }
        RichTextFlow rtf = new RichTextFlow(TextHandler.SIMPLE_HTML, buf.toString());
        FxUtil.submitToFxThread(() -> new Dialog().setTitle("\u0421\u0442\u0430\u0442\u0443\u0441 \u0432 \u0421\u0438\u0440\u0435\u043d\u0435 \u0434\u043b\u044f " + clientId).setBody((Node)rtf).addButton(DialogButtonStyle.ACCEPT_REGULAR).show((Node)this));
    }

    private KeyPairEntry findKeyPairEntry(String alias) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)KeyPairEntry.Property.alias.name(), (Object)alias));
        SearchResult result = ((AssetService)RpcServiceManager.get().getService(AssetService.class)).search(ServiceInvocationContext.get(), KeyPairEntry.class, query);
        return (KeyPairEntry)result.unique();
    }
}

