/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.corteos.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.RendererWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.RendererWidgetColumn;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.gds.corteos.entity.tasks.PersonReplaceDetailsListTask;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.renderer.StandardNodeRenderer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonReplaceDetailsType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class PersonReplaceDetailsListAction
implements IndexListAction {
    public double getWeight() {
        return 50.0;
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return true;
    }

    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.UPDATE;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        return PersonIndex.class.equals((Object)context.getIndexType());
    }

    public String getId() {
        return "person-replace-details";
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        ObservableSet selectedTypes = FXCollections.observableSet((Object[])new PersonReplaceDetailsType[0]);
        TableWidget tableWidget = new TableWidget(false);
        tableWidget.setItemsProvider(() -> new ReplaceDetail());
        tableWidget.setControlButtonsAvailability(ControlsPane.ADD_REMOVE);
        tableWidget.setColumns(this.createTableColumns((Set<PersonReplaceDetailsType>)selectedTypes));
        tableWidget.setOnRowsAction(event -> {
            if (event.getTarget() != tableWidget) {
                return;
            }
            if (event.getEventType().equals(TableRowEvent.ROW_ADD)) {
                int rowIndex = event.getRowIndex();
                ComboBoxWidget typeWidget = (ComboBoxWidget)((ComboBoxWidgetColumn)tableWidget.getColumn("type")).getWidget(rowIndex);
                RendererWidget valueWidget = (RendererWidget)((RendererWidgetColumn)tableWidget.getColumn("value")).getWidget(rowIndex);
                typeWidget.valueProperty().addListener((observable, oldValue, newValue) -> {
                    if (newValue != null) {
                        TypeWrapper wrapper = this.createWrapper((PersonReplaceDetailsType)newValue);
                        valueWidget.setRenderer(wrapper.getRenderer());
                        this.updateSelectedNames((TableWidget<ReplaceDetail>)tableWidget, (Set<PersonReplaceDetailsType>)selectedTypes);
                        wrapper.setListParametersSupplier(valueWidget.getValueNode());
                        valueWidget.setValue(null);
                    }
                });
            } else if (event.getEventType().equals(TableRowEvent.ROW_REMOVE)) {
                this.updateSelectedNames((TableWidget<ReplaceDetail>)tableWidget, (Set<PersonReplaceDetailsType>)selectedTypes);
            }
        });
        tableWidget.addRow(0);
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.Change_of_requisites);
        dialog.setBody((Node)tableWidget).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Action_Change, () -> this.write(tableWidget.getRowsData(), context), (BooleanExpression)Bindings.isNotEmpty((ObservableSet)selectedTypes)).setExpandToParent(true).show((Node)source);
    }

    private void updateSelectedNames(TableWidget<ReplaceDetail> tableWidget, Set<PersonReplaceDetailsType> selectedNames) {
        selectedNames.clear();
        ComboBoxWidgetColumn nameColumn = (ComboBoxWidgetColumn)tableWidget.getColumn("type");
        IntStream.range(0, tableWidget.getRowsCount()).forEach(idx -> selectedNames.add((PersonReplaceDetailsType)((ComboBoxWidget)nameColumn.getWidget(idx)).getValue()));
    }

    private List<TableWidgetColumn<ReplaceDetail, ?>> createTableColumns(Set<PersonReplaceDetailsType> selectedTypes) {
        ArrayList result = new ArrayList();
        ComboBoxWidgetColumn col = new ComboBoxWidgetColumn(ReplaceDetail::getType, (rec$, x$0) -> ((ReplaceDetail)rec$).setType(x$0));
        col.setId("type");
        col.setCaption(Messages.Field_Name);
        col.setPrefWidthEm(Double.valueOf(100.0));
        col.setLive(true);
        col.setNoNulls(true);
        col.setItemsSupplier(Suppliers.createEnumSupplier(PersonReplaceDetailsType.class, type -> !selectedTypes.contains(type)));
        result.add((TableWidgetColumn<ReplaceDetail, ?>)col);
        col = new RendererWidgetColumn(rec$ -> ((ReplaceDetail)rec$).getValue(), (rec$, x$0) -> ((ReplaceDetail)rec$).setValue(x$0));
        col.setId("value");
        col.setCaption(Messages.New_value);
        col.setPrefWidthEm(Double.valueOf(100.0));
        result.add((TableWidgetColumn<ReplaceDetail, ?>)col);
        return result;
    }

    public void write(Collection<ReplaceDetail> rowsData, IndexListPane<?, ?> context) {
        if (!context.getSelectedItems().isEmpty()) {
            List selectedItems = context.getSelectedItems();
            Notifications.get().enqueueAsyncTask((ClientTask)new PersonReplaceDetailsListTask(selectedItems.stream().map(PersonIndex::getSource).collect(Collectors.toList()), rowsData.stream().filter(replaceDetail -> replaceDetail.getType() != null && ((ReplaceDetail)replaceDetail).getValue() != null).collect(Collectors.toMap(ReplaceDetail::getType, rec$ -> ((ReplaceDetail)rec$).getValue(), (first, second) -> first))));
        } else {
            Notifications.get().enqueueAsyncTask((ClientTask)new PersonReplaceDetailsListTask(context.buildQuery(), rowsData.stream().filter(replaceDetail -> replaceDetail.getType() != null && ((ReplaceDetail)replaceDetail).getValue() != null).collect(Collectors.toMap(ReplaceDetail::getType, rec$ -> ((ReplaceDetail)rec$).getValue(), (first, second) -> first))));
        }
    }

    TypeWrapper createWrapper(PersonReplaceDetailsType type) {
        switch (type) {
            case NOT_CREATE_CORTEOS_ACCOUNT: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return StandardNodeRenderer.BOOLEAN;
                    }
                };
            }
        }
        throw Xeption.forDeveloper((String)("unsupported type: " + type), (Object[])new Object[0]);
    }

    private static class ReplaceDetail {
        private PersonReplaceDetailsType type;
        private Object value;

        private ReplaceDetail() {
        }

        public PersonReplaceDetailsType getType() {
            return this.type;
        }

        private void setType(PersonReplaceDetailsType type) {
            this.type = type;
        }

        private Object getValue() {
            return this.value;
        }

        private void setValue(Object param) {
            this.value = param;
        }
    }

    private static abstract class TypeWrapper {
        private TypeWrapper() {
        }

        abstract NodeRenderer getRenderer();

        void setListParametersSupplier(Node node) {
        }
    }
}

