/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.corteos.entity.tasks;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.gds.corteos.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.gds.ibus.corteos.IbusCorteosContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.corteos.CorteosDeleteStatus;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CorteosDeletePersonListTask
extends ClientTask {
    private final List<EntityIndex<Person>> indices;

    public CorteosDeletePersonListTask(List<EntityIndex<Person>> indices) {
        this.indices = (List)CollectionUtil.requireNonEmpty(indices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        MessageType messageType;
        List<EntityReference<Organization>> corteosOrganizations = this.getCorteosOrganizations();
        if (corteosOrganizations.isEmpty()) {
            this.showNotification(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.OrganizationsWithEnabledCorteosSyncNotFound, (Object[])new Object[0]));
            return;
        }
        this.setProgress((byte)5, "");
        List<EntityReference<Person>> personsToDelete = this.filterIndices(this.indices, corteosOrganizations);
        if (personsToDelete.isEmpty()) {
            this.showNotification(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ProfilesForDeleteNotSelected, (Object[])new Object[0]));
            return;
        }
        this.setProgress((byte)10, "");
        this.addMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.ProfilesForDeleteCount, (Object[])new Object[]{personsToDelete.size()})});
        int okCount = 0;
        int errorCount = 0;
        try {
            for (int i = 0; i < personsToDelete.size(); ++i) {
                EntityReference<Person> person = personsToDelete.get(i);
                Thread.sleep(1L);
                try {
                    Message personDeleteMessage = MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.ProfileDeleting, (Object[])new Object[]{person});
                    this.setProgress((byte)(90 * (i + 1) / personsToDelete.size() + 10), personDeleteMessage.getMessage().toString());
                    this.addMessages(new Message[]{personDeleteMessage});
                    CorteosDeleteStatus deleteStatus = this.deletePerson(person);
                    if (deleteStatus == CorteosDeleteStatus.OK) {
                        this.addMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.ProfileWasDeleted, (Object[])new Object[0])});
                        ++okCount;
                        continue;
                    }
                    this.addMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ProfileWasNotDeleted, (Object[])new Object[0])});
                    ++errorCount;
                    continue;
                }
                catch (Exception e) {
                    this.addMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ProfileDeleteError, (Throwable)e, (Object[])new Object[0])});
                    ++errorCount;
                }
            }
            messageType = okCount > 0 ? MessageType.MESSAGE : MessageType.ERROR;
        }
        catch (Throwable throwable) {
            this.showNotification(MessagesHelper.createMessage((MessageType)(okCount > 0 ? MessageType.MESSAGE : MessageType.ERROR), (String)Messages.ProfilesDeletedCount, (Object[])new Object[]{okCount, errorCount}));
            EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)personsToDelete.stream().map(item -> new EntityModification(item, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
            throw throwable;
        }
        this.showNotification(MessagesHelper.createMessage((MessageType)messageType, (String)Messages.ProfilesDeletedCount, (Object[])new Object[]{okCount, errorCount}));
        EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)personsToDelete.stream().map(item -> new EntityModification(item, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
    }

    protected String getTitle() {
        return Messages.CorteosDeleting;
    }

    private List<EntityReference<Organization>> getCorteosOrganizations() throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.corteosSyncEnabled.name(), (Object)Boolean.TRUE));
        return ((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(ServiceInvocationContext.get(), OrganizationIndex.class, query).stream().map(EntityIndex::getSource).collect(Collectors.toList());
    }

    private List<EntityReference<Person>> filterIndices(List<EntityIndex<Person>> indices, List<EntityReference<Organization>> organizations) throws Exception {
        ArrayList<EntityReference<Person>> result = new ArrayList<EntityReference<Person>>();
        for (EntityIndex<Person> index : indices) {
            long corteosProfilesCount;
            EntityContainer person = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), index.getSource());
            if (person == null || !CollectionUtil.containAtLeastOneCommonElement(organizations, (Collection)ProfileHelper.getEmploymentsRefs((Person)((Person)person.getEntity()), (boolean)false)) || (corteosProfilesCount = ((Person)person.getEntity()).getCorteosSettings().getProfileData().stream().filter(data -> data.getCorteosId() != null && !data.isDeleted()).count()) != 1L) continue;
            result.add((EntityReference<Person>)index.getSource());
        }
        return result;
    }

    private CorteosDeleteStatus deletePerson(EntityReference<Person> person) throws Exception {
        HashMap<String, EntityReference<Person>> contextMap = new HashMap<String, EntityReference<Person>>();
        contextMap.put(IbusCorteosContextKeys.PERSON_REFERENCE.name(), person);
        Set<String> returnKeys = Collections.singleton(IbusCorteosContextKeys.STATUS.name());
        Map ibusResult = ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processRouteSync(ServiceInvocationContext.get(), "corteos:person:delete-person", contextMap, returnKeys);
        return (CorteosDeleteStatus)ibusResult.get(IbusCorteosContextKeys.STATUS.name());
    }

    private void showNotification(Message message) {
        this.addMessages(new Message[]{message});
        Notifications.get().showMessages(new Message[]{message});
    }
}

