/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.corteos.entity.tasks;

import com.google.common.collect.Sets;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.gds.ibus.corteos.IbusCorteosContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.corteos.CorteosDeleteStatus;
import com.gridnine.xtrip.common.model.corteos.CorteosPersonProfileData;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class CorteosDeletePersonTask
extends ClientTask {
    private final EntityContainer<Person> person;
    private final Control source;
    private final ObservableMutex mutex;

    public CorteosDeletePersonTask(EntityContainer<Person> person, Control source, ObservableMutex mutex) {
        this.person = Objects.requireNonNull(person);
        this.source = Objects.requireNonNull(source);
        this.mutex = Objects.requireNonNull(mutex);
    }

    protected void execute() throws Exception {
        List corteosOrganizationIds = ((Person)this.person.getEntity()).getCorteosSettings().getProfileData().stream().filter(data -> data.getCorteosId() != null).map(CorteosPersonProfileData::getCorteosOrganizationId).filter(Objects::nonNull).collect(Collectors.toList());
        if (corteosOrganizationIds.isEmpty()) {
            this.showNotification(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)com.gridnine.xtrip.client.fx.gds.corteos.l10n.Messages.ProfileWasNotSynchronizedToCorteosBefore, (Object[])new Object[0]));
            return;
        }
        boolean corteosSyncEnabled = false;
        boolean deletedInCorteos = true;
        ArrayList<EntityReference> employmentsToDelete = new ArrayList<EntityReference>();
        EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
        for (PersonEmployment employment : ((Person)this.person.getEntity()).getEmployments()) {
            EntityContainer orgContainer;
            EntityReference orgReference;
            if (!MiscUtil.isBetween((Date)employment.getOpened(), (Date)employment.getClosed(), (Date)new Date()) || (orgReference = employment.getOrganization()) == null || EntityStorageHelper.isEmpty((EntityContainer)(orgContainer = entityService.load(ServiceInvocationContext.get(), orgReference))) || !((Organization)orgContainer.getEntity()).getCorteosSettings().isSyncEnabled() || ((Organization)orgContainer.getEntity()).getCorteosSettings().getCorteosId() == null) continue;
            corteosSyncEnabled = true;
            boolean deleted = ((Person)this.person.getEntity()).getCorteosSettings().getProfileData().stream().anyMatch(data -> data.isDeleted() && ((Organization)orgContainer.getEntity()).getCorteosSettings().getCorteosId().equals(data.getCorteosOrganizationId()));
            deletedInCorteos &= deleted;
            if (deleted) continue;
            employmentsToDelete.add(orgReference);
        }
        if (!corteosSyncEnabled) {
            this.showNotification(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)com.gridnine.xtrip.client.fx.gds.corteos.l10n.Messages.ProfileWasNotSynchronizedToCorteosForCurrentOrganizations, (Object[])new Object[0]));
            return;
        }
        if (deletedInCorteos) {
            this.showNotification(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)com.gridnine.xtrip.client.fx.gds.corteos.l10n.Messages.ProfileMarkedAsDeletedInCorteos, (Object[])new Object[0]));
            return;
        }
        if (employmentsToDelete.size() > 1) {
            CountDownLatch doneLatch = new CountDownLatch(1);
            FxUtil.waitForFxThread(() -> {
                EntityBoxWidget widget = new EntityBoxWidget(Organization.class, false);
                widget.setNoNulls(true);
                widget.setItemsSupplier(() -> employmentsToDelete, false);
                widget.setValue((EntityReference)employmentsToDelete.get(0));
                Dialog dialog = new Dialog();
                dialog.setTitle(com.gridnine.xtrip.client.fx.gds.corteos.l10n.Messages.ChooseEmploymentToDelete).setBody((Node)widget).setOnCloseRequest(doneLatch::countDown).addButton(DialogButtonStyle.DECLINE, doneLatch::countDown).addButton(DialogButtonStyle.ACCEPT_CONTINUE, Messages.General_Choose, () -> Notifications.get().submitTask(() -> {
                    try {
                        this.deletePerson((EntityReference<Person>)this.person.toReference(), (EntityReference<Organization>)widget.getValue());
                    }
                    finally {
                        doneLatch.countDown();
                    }
                }, this.mutex)).show((Node)this.source);
            });
            doneLatch.await();
        } else {
            this.deletePerson((EntityReference<Person>)this.person.toReference(), null);
        }
    }

    private void deletePerson(EntityReference<Person> reference, EntityReference<Organization> employmentToDelete) throws Exception {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.put(IbusCorteosContextKeys.PERSON_REFERENCE.name(), reference);
        contextMap.put(IbusCorteosContextKeys.ORGANIZATION_TO_DELETE.name(), employmentToDelete);
        HashSet returnKeys = Sets.newHashSet((Object[])new String[]{IbusCorteosContextKeys.STATUS.name(), IbusCorteosContextKeys.MESSAGES.name()});
        Map ibusResult = ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processRouteSync(ServiceInvocationContext.get(), "corteos:person:delete-person", contextMap, (Set)returnKeys);
        CorteosDeleteStatus deleteStatus = (CorteosDeleteStatus)ibusResult.get(IbusCorteosContextKeys.STATUS.name());
        List deleteMessages = (List)ibusResult.get(IbusCorteosContextKeys.MESSAGES.name());
        if (CollectionUtil.isNotEmpty((Collection)deleteMessages)) {
            deleteMessages.forEach(this::showNotification);
        }
        if (deleteStatus == CorteosDeleteStatus.OK) {
            this.showNotification(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)com.gridnine.xtrip.client.fx.gds.corteos.l10n.Messages.ProfileWasDeleted, (Object[])new Object[0]));
        } else {
            this.showNotification(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)com.gridnine.xtrip.client.fx.gds.corteos.l10n.Messages.ProfileWasNotDeleted, (Object[])new Object[0]));
        }
        EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, new EntityModification(reference, EntityModification.ModificationType.CHANGE)));
    }

    protected String getTitle() {
        return com.gridnine.xtrip.client.fx.gds.corteos.l10n.Messages.CorteosDeleting;
    }

    private void showNotification(Message message) {
        this.addMessages(new Message[]{message});
        Notifications.get().showMessages(new Message[]{message});
    }
}

