/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.corteos.entity.tasks;

import com.google.common.collect.Sets;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.gds.corteos.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.gds.ibus.corteos.IbusCorteosContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.corteos.CorteosSyncStatus;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CorteosSynchronizePersonTask
extends ClientTask {
    private final EntityContainer<Person> person;

    public CorteosSynchronizePersonTask(EntityContainer<Person> person) {
        this.person = Objects.requireNonNull(person);
    }

    protected void execute() throws Exception {
        boolean corteosSyncEnabled = false;
        boolean deletedInCorteos = true;
        EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
        for (PersonEmployment employment : ((Person)this.person.getEntity()).getEmployments()) {
            EntityContainer orgContainer;
            EntityReference orgReference;
            if (!MiscUtil.isBetween((Date)employment.getOpened(), (Date)employment.getClosed(), (Date)new Date()) || (orgReference = employment.getOrganization()) == null || EntityStorageHelper.isEmpty((EntityContainer)(orgContainer = entityService.load(ServiceInvocationContext.get(), orgReference))) || !((Organization)orgContainer.getEntity()).getCorteosSettings().isSyncEnabled() || ((Organization)orgContainer.getEntity()).getCorteosSettings().getCorteosId() == null) continue;
            corteosSyncEnabled = true;
            deletedInCorteos &= ((Person)this.person.getEntity()).getCorteosSettings().getProfileData().stream().anyMatch(data -> data.isDeleted() && ((Organization)orgContainer.getEntity()).getCorteosSettings().getCorteosId().equals(data.getCorteosOrganizationId()));
        }
        if (!corteosSyncEnabled) {
            this.showNotification(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ProfileDoesntHaveEmploymentsWithEnabledCorteosSync, (Object[])new Object[0]));
            return;
        }
        if (deletedInCorteos) {
            this.showNotification(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ProfileMarkedAsDeletedInCorteos, (Object[])new Object[0]));
            return;
        }
        EntityReference reference = this.person.toReference();
        HashMap<String, EntityReference> contextMap = new HashMap<String, EntityReference>();
        contextMap.put(IbusCorteosContextKeys.PERSON_REFERENCE.name(), reference);
        HashSet returnKeys = Sets.newHashSet((Object[])new String[]{IbusCorteosContextKeys.STATUS.name(), IbusCorteosContextKeys.MESSAGES.name()});
        Map ibusResult = ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processRouteSync(ServiceInvocationContext.get(), "corteos:person:sync-person", contextMap, (Set)returnKeys);
        CorteosSyncStatus syncStatus = (CorteosSyncStatus)ibusResult.get(IbusCorteosContextKeys.STATUS.name());
        List syncMessages = (List)ibusResult.get(IbusCorteosContextKeys.MESSAGES.name());
        if (CollectionUtil.isNotEmpty((Collection)syncMessages)) {
            syncMessages.forEach(this::showNotification);
        }
        if (syncStatus == CorteosSyncStatus.OK) {
            this.showNotification(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.ProfileWasSynchronized, (Object[])new Object[0]));
        } else {
            this.showNotification(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ProfileWasNotSynchronized, (Object[])new Object[0]));
        }
        EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, new EntityModification(reference, EntityModification.ModificationType.CHANGE)));
    }

    protected String getTitle() {
        return Messages.CorteosSynchronization;
    }

    private void showNotification(Message message) {
        this.addMessages(new Message[]{message});
        Notifications.get().showMessages(new Message[]{message});
    }
}

