/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.corteos.entity.tasks;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.gds.corteos.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.gds.ibus.corteos.IbusCorteosContextKeys;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.corteos.CorteosUpdateStatus;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class CorteosUpdatePersonListTask
extends ClientTask {
    private final List<EntityIndex<Person>> indices;
    private final SearchQuery searchQuery;

    public CorteosUpdatePersonListTask(List<EntityIndex<Person>> indices) {
        this.indices = (List)CollectionUtil.requireNonEmpty(indices);
        this.searchQuery = null;
    }

    public CorteosUpdatePersonListTask(SearchQuery searchQuery) {
        this.indices = new ArrayList<EntityIndex<Person>>();
        this.searchQuery = Objects.requireNonNull(searchQuery);
        this.searchQuery.setLimit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        MessageType messageType;
        List<EntityReference<Organization>> corteosOrganizations = this.getCorteosOrganizations();
        if (corteosOrganizations.isEmpty()) {
            this.showNotification(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.OrganizationsWithEnabledCorteosSyncNotFound, (Object[])new Object[0]));
            return;
        }
        this.setProgress((byte)5, "");
        List<EntityReference<Person>> personsToUpdate = this.filterIndices(corteosOrganizations);
        if (personsToUpdate.isEmpty()) {
            this.showNotification(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ProfilesForUpdateNotSelected, (Object[])new Object[0]));
            return;
        }
        this.setProgress((byte)10, "");
        this.addMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.ProfilesForUpdateCount, (Object[])new Object[]{personsToUpdate.size()})});
        int okCount = 0;
        int errorCount = 0;
        try {
            for (int i = 0; i < personsToUpdate.size(); ++i) {
                EntityReference<Person> person = personsToUpdate.get(i);
                Thread.sleep(1L);
                try {
                    Message personUpdateMessage = MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.ProfileUpdating, (Object[])new Object[]{person});
                    this.setProgress((byte)(90 * (i + 1) / personsToUpdate.size() + 10), personUpdateMessage.getMessage().toString());
                    this.addMessages(new Message[]{personUpdateMessage});
                    CorteosUpdateStatus updateStatus = this.updatePerson(person);
                    if (updateStatus == CorteosUpdateStatus.OK) {
                        this.addMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.ProfileWasUpdated, (Object[])new Object[0])});
                        ++okCount;
                        continue;
                    }
                    this.addMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ProfileWasNotUpdated, (Object[])new Object[0])});
                    ++errorCount;
                    continue;
                }
                catch (Exception e) {
                    this.addMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ProfileUpdateError, (Throwable)e, (Object[])new Object[0])});
                    ++errorCount;
                }
            }
            messageType = okCount > 0 ? MessageType.MESSAGE : MessageType.ERROR;
        }
        catch (Throwable throwable) {
            this.showNotification(MessagesHelper.createMessage((MessageType)(okCount > 0 ? MessageType.MESSAGE : MessageType.ERROR), (String)Messages.ProfilesUpdatedCount, (Object[])new Object[]{okCount, errorCount}));
            EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)personsToUpdate.stream().map(item -> new EntityModification(item, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
            throw throwable;
        }
        this.showNotification(MessagesHelper.createMessage((MessageType)messageType, (String)Messages.ProfilesUpdatedCount, (Object[])new Object[]{okCount, errorCount}));
        EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)personsToUpdate.stream().map(item -> new EntityModification(item, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
    }

    protected String getTitle() {
        return Messages.CorteosUpdating;
    }

    private List<EntityReference<Organization>> getCorteosOrganizations() throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.corteosSyncEnabled.name(), (Object)Boolean.TRUE));
        return ((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(ServiceInvocationContext.get(), OrganizationIndex.class, query).stream().map(EntityIndex::getSource).collect(Collectors.toList());
    }

    private List<EntityReference<Person>> filterIndices(List<EntityReference<Organization>> organizations) throws Exception {
        SearchQuery query;
        if (this.searchQuery == null) {
            query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqStringCriterion((String)"containerUid", (Collection)this.indices.stream().map(EntityIndex::getSource).map(EntityReference::getUid).collect(Collectors.toList())));
        } else {
            query = (SearchQuery)XCloneHelper.clone((XCloneable)this.searchQuery);
        }
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrContainsStringCriterion((String)PersonIndex.Property.employmentsUids.name(), (Collection)organizations.stream().map(EntityReference::getUid).collect(Collectors.toList())));
        query.getCriteria().getCriterions().add(SearchCriterion.isNotEmpty((String)PersonIndex.Property.corteosIds.name()));
        return ((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(ServiceInvocationContext.get(), PersonIndex.class, query).stream().map(EntityIndex::getSource).collect(Collectors.toList());
    }

    private CorteosUpdateStatus updatePerson(EntityReference<Person> person) throws Exception {
        HashMap<String, EntityReference<Person>> contextMap = new HashMap<String, EntityReference<Person>>();
        contextMap.put(IbusCorteosContextKeys.PERSON_REFERENCE.name(), person);
        Set<String> returnKeys = Collections.singleton(IbusCorteosContextKeys.STATUS.name());
        Map ibusResult = ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processRouteSync(ServiceInvocationContext.get(), "corteos:person:update-person", contextMap, returnKeys);
        CorteosUpdateStatus updateStatus = (CorteosUpdateStatus)ibusResult.get(IbusCorteosContextKeys.STATUS.name());
        return updateStatus;
    }

    private void showNotification(Message message) {
        this.addMessages(new Message[]{message});
        Notifications.get().showMessages(new Message[]{message});
    }
}

