/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.corteos.entity.tasks.dialog;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.BooleanValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.gds.corteos.entity.tasks.CorteosProductConnectTask;
import com.gridnine.xtrip.client.fx.gds.corteos.l10n.Messages;
import com.gridnine.xtrip.client.fx.gds.corteos.model.CorteosProductConnectPane;
import com.gridnine.xtrip.client.fx.gds.corteos.model.CorteosProductConnectPaneController;
import com.gridnine.xtrip.client.fx.settings.model.CorteosProductVM;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.ObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class CorteosProductConnectDialog {
    private final Control source;
    private final EntityContainer<BookingFile> bookingFile;
    private final List<BaseProduct> products;
    private final String selectedProductUid;

    public CorteosProductConnectDialog(Control source, EntityContainer<BookingFile> bookingFile, List<BaseProduct> products, String selectedProductUid) {
        this.source = Objects.requireNonNull(source);
        this.bookingFile = Objects.requireNonNull(bookingFile);
        this.products = (List)CollectionUtil.requireNonEmpty(products);
        this.selectedProductUid = selectedProductUid;
    }

    public void showDialog() {
        final CorteosProductConnectPane body = this.createBody();
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.CorteosConnectProducts).setAutoClose(false).setExpandToParent(false).setBody((Node)body).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, () -> this.runTask(dialog, body), (BooleanExpression)new BooleanBinding(){
            {
                this.bind(new Observable[]{body.getOrderNumberNode().valueProperty()});
                BooleanValueWidgetColumn column = (BooleanValueWidgetColumn)body.getProductsNode().getColumn("connect");
                this.bind((Observable[])IntStream.range(0, body.getProductsNode().getRowsCount()).mapToObj(arg_0 -> ((BooleanValueWidgetColumn)column).getWidget(arg_0)).map(BooleanValueWidget::valueProperty).toArray(ObjectProperty[]::new));
            }

            protected boolean computeValue() {
                if (body.getOrderNumberNode().getValue() == null || (Integer)body.getOrderNumberNode().getValue() <= 0) {
                    return false;
                }
                return body.getProductsNode().getRowsData().stream().filter(CorteosProductVM::isConnect).map(CorteosProductVM::getProductClass).distinct().count() == 1L;
            }
        }).setOnCloseRequest(() -> ((Dialog)dialog).close()).show((Node)this.source);
    }

    private CorteosProductConnectPane createBody() {
        BaseProduct selectedProduct;
        CorteosProductConnectPane body = new CorteosProductConnectPane(false);
        body.getProductsNode().setControlButtonsAvailability(ControlsPane.NONE);
        CorteosProductConnectPaneController controller = new CorteosProductConnectPaneController(body, false);
        List<Object> preSelectedProducts = this.products.size() == 1 ? this.products : ((selectedProduct = (BaseProduct)this.products.stream().filter(product -> this.selectedProductUid != null && this.selectedProductUid.equals(product.getUid())).findFirst().orElse(null)) != null ? this.products.stream().filter(product -> selectedProduct.equals(product) || selectedProduct.getReservation().equals((Object)product.getReservation())).collect(Collectors.toList()) : Collections.emptyList());
        controller.getProducts().readData(this.products.stream().map(prod -> {
            CorteosProductVM productVM = new CorteosProductVM();
            productVM.setProductTitle(BookingHelper.generateShortProductName((BaseProduct)prod));
            productVM.setProductUid(prod.getUid());
            productVM.setProductClass(prod.getClass());
            productVM.setConnect(preSelectedProducts.contains(prod));
            return productVM;
        }).collect(Collectors.toList()));
        if (this.products.size() == 1) {
            controller.getProducts().setReadonly(true);
        }
        return body;
    }

    private void runTask(Dialog dialog, CorteosProductConnectPane body) {
        List<String> selectedProductUids = body.getProductsNode().getRowsData().stream().filter(CorteosProductVM::isConnect).map(CorteosProductVM::getProductUid).collect(Collectors.toList());
        Notifications.get().enqueueAsyncTask((ClientTask)new CorteosProductConnectTask(this.bookingFile, selectedProductUids, (Integer)body.getOrderNumberNode().getValue()));
        dialog.close();
    }
}

