/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.corteos.handlers.dicts;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.model.dict.CommonReasonCodePanelController;
import com.gridnine.xtrip.client.fx.model.dict.CommonReasonCodePanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.CommonReasonCodeHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommonReasonCode;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public class CorteosReasonCodeHandler
extends CommonReasonCodeHandler {
    protected void configureStandardListParameters(DictListParameters params) {
        super.configureStandardListParameters(params);
        params.getColumns().add(DictHandlersHelper.COL_CODE_VARIANTS);
    }

    protected void configureController(List<BiConsumer<CommonReasonCode, CommonReasonCodePanelVM>> toVM, List<BiConsumer<CommonReasonCodePanelVM, CommonReasonCode>> fromVM) {
        super.configureController(toVM, fromVM);
        ControllersRegistry.register((ControllerInterceptor)new CommonReasonCodeControllerInterceptor());
        toVM.add((model, vm) -> DictHandlersHelper.codeVariantsToVM((Map)model.getCodeVariants(), (List)vm.getCodeVariants().getContent()));
        fromVM.add((vm, model) -> DictHandlersHelper.codeVariantsFromVM((List)vm.getCodeVariants().getContent(), (Map)model.getCodeVariants()));
    }

    class CommonReasonCodeControllerInterceptor
    extends ControllerInterceptor<CommonReasonCodePanelVM, CommonReasonCodePanelController> {
        CommonReasonCodeControllerInterceptor() {
        }

        protected Class<CommonReasonCodePanelController> getControllerClass() {
            return CommonReasonCodePanelController.class;
        }

        protected void onCreate(CommonReasonCodePanelController controller) {
            TableWidget codeSystemTable = (TableWidget)controller.getCodeVariants().getView().getContent();
            ComboBoxWidgetColumn codeSystemColumn = (ComboBoxWidgetColumn)codeSystemTable.getColumn("codeSystem");
            codeSystemColumn.setItemsSupplier(() -> Collections.singletonList(CodeSystem.CORTEOS));
        }
    }
}

