/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.corteos.handlers.person;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.IntValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TripleValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.model.profile.PersonCorteosSyncDataPanel;
import com.gridnine.xtrip.client.fx.model.profile.PersonExtSyncMainPanel;
import com.gridnine.xtrip.client.fx.model.profile.PersonSpaceController;
import com.gridnine.xtrip.client.fx.model.profile.PersonSpaceVM;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.model.CorteosOrganizationWrapper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.person.uidata.PersonUIData;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.util.StringConverter;

public class CorteosPersonControllerInterceptor
extends ControllerInterceptor<PersonSpaceVM, PersonSpaceController> {
    protected Class<PersonSpaceController> getControllerClass() {
        return PersonSpaceController.class;
    }

    protected void onCreate(PersonSpaceController controller) {
        if (!Prefetched.getData().isCorteosSyncEnabled()) {
            ((PersonExtSyncMainPanel)controller.getView().getExternalSystemSynchronizationTile().getFullNode()).getCorteosSyncCard().setHidden(true);
        } else {
            ((PersonExtSyncMainPanel)controller.getView().getExternalSystemSynchronizationTile().getFullNode()).getCorteosSyncCard().setHidden(false);
        }
        TableWidget tableWidget = (TableWidget)((PersonCorteosSyncDataPanel)((PersonExtSyncMainPanel)controller.getView().getExternalSystemSynchronizationTile().getFullNode()).getCorteosSyncCard().getContent()).getProfileDataCard().getContent();
        tableWidget.setOnRowsAction(event -> {
            if (event.getEventType().equals(TableRowEvent.ROW_ADD)) {
                int rowIndex = event.getRowIndex();
                IntValueWidget accountIdWidget = (IntValueWidget)tableWidget.getColumn("accountId").getWidget(rowIndex);
                IntValueWidget roleIdWidget = (IntValueWidget)tableWidget.getColumn("roleId").getWidget(rowIndex);
                ComboBoxWidget blockedWidget = (ComboBoxWidget)tableWidget.getColumn("blocked").getWidget(rowIndex);
                roleIdWidget.setValueValidator(value -> value > 0);
                this.updateAccountRelatedWidgets(accountIdWidget, roleIdWidget, (ComboBoxWidget<Boolean>)blockedWidget);
                accountIdWidget.valueProperty().addListener((s, o, n) -> this.updateAccountRelatedWidgets(accountIdWidget, roleIdWidget, (ComboBoxWidget<Boolean>)blockedWidget));
            }
        });
        TripleValueWidgetColumn blockedColumn = (TripleValueWidgetColumn)tableWidget.getColumn("blocked");
        ComboBoxWidgetColumn corteosOrganizationIdColumn = (ComboBoxWidgetColumn)tableWidget.getColumn("corteosOrganizationId");
        blockedColumn.setConverter((StringConverter)new StringConverter<Boolean>(){

            public String toString(Boolean object) {
                return object != null ? (String)StandardRenderers.BOOLEAN.apply((Object)object) : "\u2014";
            }

            public Boolean fromString(String string) {
                return null;
            }
        });
        corteosOrganizationIdColumn.setConverter((StringConverter)new StringConverter<CorteosOrganizationWrapper>(){

            public String toString(CorteosOrganizationWrapper object) {
                if (object == null) {
                    return "";
                }
                return String.format("%s (%s)", object.getOrganizationId(), object.getOrganizationReference() != null ? object.getOrganizationReference().getCaption() : " - ");
            }

            public CorteosOrganizationWrapper fromString(String string) {
                return null;
            }
        });
    }

    private void updateAccountRelatedWidgets(IntValueWidget accountIdWidget, IntValueWidget roleIdWidget, ComboBoxWidget<Boolean> blockedWidget) {
        boolean accountExists = accountIdWidget.getValue() != null;
        roleIdWidget.getViewState().setNotEditable(!accountExists);
        blockedWidget.getViewState().setNotEditable(!accountExists);
    }

    protected void afterReadData(PersonSpaceController controller, PersonSpaceVM model) {
        TableWidget tableWidget = (TableWidget)((PersonCorteosSyncDataPanel)((PersonExtSyncMainPanel)controller.getView().getExternalSystemSynchronizationTile().getFullNode()).getCorteosSyncCard().getContent()).getProfileDataCard().getContent();
        RootEntityPane rootEntityPane = RootEntityPane.lookup((Node)controller.getView());
        if (rootEntityPane != null) {
            List organizationIdItems = ((PersonUIData)rootEntityPane.getData().getSupplement()).getCorteosIdToOrganizationMap().entrySet().stream().map(entry -> {
                CorteosOrganizationWrapper wrapper = new CorteosOrganizationWrapper();
                wrapper.setOrganizationId((Integer)entry.getKey());
                wrapper.setOrganizationReference((EntityReference)entry.getValue());
                return wrapper;
            }).collect(Collectors.toList());
            ComboBoxWidgetColumn corteosOrganizationIdColumn = (ComboBoxWidgetColumn)tableWidget.getColumn("corteosOrganizationId");
            corteosOrganizationIdColumn.setItemsSupplier(() -> organizationIdItems);
            if (organizationIdItems.size() == 1) {
                tableWidget.setNewRowHandler(vm -> vm.setCorteosOrganizationId((CorteosOrganizationWrapper)organizationIdItems.get(0)));
            }
        }
    }
}

