/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.corteos.handlers.settings;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.gds.corteos.handlers.settings.CorteosSettingsControllerInterceptor;
import com.gridnine.xtrip.client.fx.settings.model.CorteosGdsAccountInnerContainerVM;
import com.gridnine.xtrip.client.fx.settings.model.CorteosGdsSettingsContainerVM;
import com.gridnine.xtrip.client.fx.settings.model.CorteosHotelProviderContainerVM;
import com.gridnine.xtrip.client.fx.settings.model.CorteosSettingsContainer;
import com.gridnine.xtrip.client.fx.settings.model.CorteosSettingsContainerController;
import com.gridnine.xtrip.client.fx.settings.model.CorteosSettingsContainerVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.corteos.CorteosGdsAccountSettings;
import com.gridnine.xtrip.common.model.corteos.CorteosGdsSettings;
import com.gridnine.xtrip.common.model.corteos.CorteosHotelProviderSettings;
import com.gridnine.xtrip.common.model.corteos.CorteosSettings;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class CorteosSettingsHandler
extends BaseRootEntityHandler<CorteosSettings, Void, CorteosSettingsContainerVM, CorteosSettingsContainer> {
    protected void configureController(List<BiConsumer<DataTransferPackage<CorteosSettings, Void>, CorteosSettingsContainerVM>> toVM, List<BiConsumer<CorteosSettingsContainerVM, DataTransferPackage<CorteosSettings, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new CorteosSettingsControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new CorteosSettingsControllerInterceptor.CorteosGdsAccountsControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new CorteosSettingsControllerInterceptor.CorteosOrganizationsControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new CorteosSettingsControllerInterceptor.CorteosHoldingsControllerInterceptor());
        toVM.add((dtp, vm) -> {
            CorteosSettings model = (CorteosSettings)dtp.getContainer().getEntity();
            vm.setName(model.getName());
            vm.setSyncEnabled(model.isSyncEnabled());
            vm.setLogin(model.getLogin());
            vm.setPassword(model.getPassword());
            vm.setServerAddress(model.getServerAddress());
            vm.setServerV31Address(model.getServerV31Address());
            vm.setServerV2Address(model.getServerV2Address());
            vm.setAgency(model.getAgency());
            vm.setAutoFillLatin(model.isAutoFillLatin());
            vm.setOnlyOneEmployment(model.isOnlyOneEmployment());
            vm.setTryManyRequests(model.isTryManyRequests());
            vm.setAssistantRoleId(model.getAssistantRoleId());
            VMHelper.transfer((Collection)model.getAviaGdsSettings(), (Collection)vm.getAviaGdsSettings(), settings -> new CorteosGdsSettingsContainerVM(), (settings, settingsVm) -> {
                settingsVm.setGdsName(settings.getGdsName());
                settingsVm.setValidator(settings.getValidator());
            });
            VMHelper.transfer((Collection)model.getRailwayGdsSettings(), (Collection)vm.getRailwayGdsSettings(), settings -> new CorteosGdsSettingsContainerVM(), (settings, settingsVm) -> {
                settingsVm.setGdsName(settings.getGdsName());
                settingsVm.setValidator(settings.getValidator());
            });
            VMHelper.transfer((Collection)model.getHotelGdsSettings(), (Collection)vm.getHotelGdsSettings(), settings -> new CorteosGdsSettingsContainerVM(), (settings, settingsVm) -> {
                settingsVm.setGdsName(settings.getGdsName());
                settingsVm.setValidator(settings.getValidator());
            });
            VMHelper.transfer((Collection)model.getAeroexpressGdsSettings(), (Collection)vm.getAeroexpressGdsSettings(), settings -> new CorteosGdsSettingsContainerVM(), (settings, settingsVm) -> {
                settingsVm.setGdsName(settings.getGdsName());
                settingsVm.setValidator(settings.getValidator());
            });
            VMHelper.transfer((Collection)model.getHotelProviderSettings(), (Collection)vm.getHotelProviderSettings(), settings -> new CorteosHotelProviderContainerVM(), (settings, settingsVm) -> {
                settingsVm.setProvider(settings.getProvider());
                VMHelper.transfer((Collection)settings.getGdsAccountSettings(), (Collection)settingsVm.getGdsAccounts().getContent(), gdsSettings -> new CorteosGdsAccountInnerContainerVM(), (gdsSettings, gdsSettingsVm) -> {
                    EntityReference gdsAccount = gdsSettings.getGdsAccount();
                    gdsSettingsVm.setGdsAccount(gdsAccount);
                    gdsSettingsVm.getOrghold().getOrganizations().getContent().clear();
                    gdsSettingsVm.getOrghold().getOrganizations().getContent().addAll(gdsSettings.getOrganizations());
                    gdsSettingsVm.getOrghold().getHoldings().getContent().clear();
                    gdsSettingsVm.getOrghold().getHoldings().getContent().addAll(gdsSettings.getHoldings());
                });
            });
        });
        fromVM.add((vm, dtp) -> {
            CorteosSettings model = (CorteosSettings)dtp.getContainer().getEntity();
            model.setName(vm.getName());
            model.setSyncEnabled(vm.isSyncEnabled());
            model.setLogin(vm.getLogin());
            model.setPassword(vm.getPassword());
            model.setServerAddress(vm.getServerAddress());
            model.setServerV31Address(vm.getServerV31Address());
            model.setServerV2Address(vm.getServerV2Address());
            model.setAgency(vm.getAgency());
            model.setAutoFillLatin(vm.isAutoFillLatin());
            model.setOnlyOneEmployment(vm.isOnlyOneEmployment());
            model.setTryManyRequests(vm.isTryManyRequests());
            model.setAssistantRoleId(vm.getAssistantRoleId());
            VMHelper.transfer((Collection)vm.getAviaGdsSettings(), (Collection)model.getAviaGdsSettings(), settingsVM -> new CorteosGdsSettings(), (settingsVm, settings) -> {
                settings.setGdsName(settingsVm.getGdsName());
                settings.setValidator(settingsVm.getValidator());
            });
            VMHelper.transfer((Collection)vm.getRailwayGdsSettings(), (Collection)model.getRailwayGdsSettings(), settingsVM -> new CorteosGdsSettings(), (settingsVm, settings) -> {
                settings.setGdsName(settingsVm.getGdsName());
                settings.setValidator(settingsVm.getValidator());
            });
            VMHelper.transfer((Collection)vm.getHotelGdsSettings(), (Collection)model.getHotelGdsSettings(), settingsVM -> new CorteosGdsSettings(), (settingsVm, settings) -> {
                settings.setGdsName(settingsVm.getGdsName());
                settings.setValidator(settingsVm.getValidator());
            });
            VMHelper.transfer((Collection)vm.getAeroexpressGdsSettings(), (Collection)model.getAeroexpressGdsSettings(), settingsVM -> new CorteosGdsSettings(), (settingsVm, settings) -> {
                settings.setGdsName(settingsVm.getGdsName());
                settings.setValidator(settingsVm.getValidator());
            });
            StringBuilder warning = new StringBuilder();
            vm.getHotelProviderSettings().forEach(hp -> {
                List holdings;
                List<EntityReference> nonDistinctHoldings;
                List organizations = hp.getGdsAccounts().getContent().stream().flatMap(gas -> gas.getOrghold().getOrganizations().getContent().stream()).collect(Collectors.toList());
                List<EntityReference> nonDistinctOrganizations = organizations.stream().filter(o -> Collections.frequency(organizations, o) > 1).distinct().collect(Collectors.toList());
                if (!nonDistinctOrganizations.isEmpty()) {
                    nonDistinctOrganizations.forEach(o -> warning.append(Messages.getOrganizationSetToMultipleGds((String)hp.getProvider().toString(), (String)o.getCaption(), (String)hp.getGdsAccounts().getContent().stream().filter(gai -> gai.getOrghold().getOrganizations().getContent().contains(o)).map(CorteosGdsAccountInnerContainerVM::getGdsAccount).filter(Objects::nonNull).map(EntityReference::getCaption).reduce((c1, c2) -> c1 + ", " + c2).orElse("")).getMessage().toString()).append(System.lineSeparator()));
                }
                if (!(nonDistinctHoldings = (holdings = hp.getGdsAccounts().getContent().stream().flatMap(gas -> gas.getOrghold().getHoldings().getContent().stream()).collect(Collectors.toList())).stream().filter(o -> Collections.frequency(holdings, o) > 1).distinct().collect(Collectors.toList())).isEmpty()) {
                    nonDistinctHoldings.forEach(o -> warning.append(Messages.getHoldingSetToMultipleGds((String)hp.getProvider().toString(), (String)o.getCaption(), (String)hp.getGdsAccounts().getContent().stream().filter(gai -> gai.getOrghold().getHoldings().getContent().contains(o)).map(CorteosGdsAccountInnerContainerVM::getGdsAccount).filter(Objects::nonNull).map(EntityReference::getCaption).reduce((c1, c2) -> c1 + ", " + c2).orElse("")).getMessage().toString()).append(System.lineSeparator()));
                }
            });
            if (warning.length() != 0) {
                Dialog.info((String)warning.toString());
            }
            VMHelper.transfer((Collection)vm.getHotelProviderSettings(), (Collection)model.getHotelProviderSettings(), settingsVM -> new CorteosHotelProviderSettings(), (settingsVm, settings) -> {
                settings.setProvider(settingsVm.getProvider());
                VMHelper.transfer((Collection)settingsVm.getGdsAccounts().getContent(), (Collection)settings.getGdsAccountSettings(), gdsSettings -> new CorteosGdsAccountSettings(), (gdsSettingsVm, gdsSettings) -> {
                    gdsSettings.setGdsAccount(gdsSettingsVm.getGdsAccount());
                    gdsSettings.getOrganizations().clear();
                    gdsSettings.getOrganizations().addAll(gdsSettingsVm.getOrghold().getOrganizations().getContent());
                    gdsSettings.getHoldings().clear();
                    gdsSettings.getHoldings().addAll(gdsSettingsVm.getOrghold().getHoldings().getContent());
                });
            });
        });
    }

    protected ViewController<CorteosSettingsContainer, CorteosSettingsContainerVM> createSpaceController(boolean readonly) {
        return new CorteosSettingsContainerController(readonly);
    }

    protected CorteosSettingsContainerVM createVM() {
        return new CorteosSettingsContainerVM();
    }

    public Class<CorteosSettings> getEntityClass() {
        return CorteosSettings.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return null;
    }
}

