/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.railway.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.model.dict.RailwayCarrierPanel;
import com.gridnine.xtrip.client.fx.model.dict.RailwayCarrierPanelController;
import com.gridnine.xtrip.client.fx.model.dict.RailwayCarrierPanelVM;
import com.gridnine.xtrip.client.fx.railway.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrier;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrierReference;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;

public class RailwayCarrierHandler
extends BaseDictHandler<RailwayCarrierPanel, RailwayCarrier, RailwayCarrierPanelVM> {
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.COL_CODE);
        params.getColumns().add(DictHandlersHelper.COL_CODE_VARIANTS);
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), (String)RailwayCarrier.Property.inn.name(), (String)Messages.INN, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), (String)RailwayCarrier.Property.kpp.name(), (String)Messages.KPP, (Renderer)StandardRenderers.GENERIC));
    }

    protected void configureController(List<BiConsumer<RailwayCarrier, RailwayCarrierPanelVM>> toVM, List<BiConsumer<RailwayCarrierPanelVM, RailwayCarrier>> fromVM) {
        toVM.add((model, vm) -> {
            vm.setRailwayCarrier(model.getCode());
            vm.setInn(model.getInn());
            vm.setKpp(model.getKpp());
            DictHandlersHelper.codeVariantsToVM((Map)model.getCodeVariants(), (List)vm.getCodeVariants().getContent());
            DictHandlersHelper.translationsToVM((Map)model.getTranslations(), (List)vm.getTranslations().getContent());
        });
        fromVM.add((vm, model) -> {
            model.setCode(StringUtils.trim((String)vm.getRailwayCarrier()));
            model.setInn(vm.getInn());
            model.setKpp(vm.getKpp());
            DictHandlersHelper.codeVariantsFromVM((List)vm.getCodeVariants().getContent(), (Map)model.getCodeVariants());
            DictHandlersHelper.translationsFromVM((List)vm.getTranslations().getContent(), (Map)model.getTranslations());
        });
    }

    public Class<RailwayCarrier> getDictType() {
        return RailwayCarrier.class;
    }

    public DictionaryReference<RailwayCarrier> createReference(String code) {
        return new RailwayCarrierReference(code);
    }

    protected RailwayCarrierPanelVM createVM() {
        return new RailwayCarrierPanelVM();
    }

    protected ViewController<RailwayCarrierPanel, RailwayCarrierPanelVM> createController() {
        return new RailwayCarrierPanelController(false);
    }
}

