/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.railway.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.model.dict.RailwayRoutePanel;
import com.gridnine.xtrip.client.fx.model.dict.RailwayRoutePanelController;
import com.gridnine.xtrip.client.fx.model.dict.RailwayRoutePanelVM;
import com.gridnine.xtrip.client.fx.railway.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayRoute;
import com.gridnine.xtrip.common.model.dict.railway.RailwayRouteReference;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;

public class RailwayRouteHandler
extends BaseDictHandler<RailwayRoutePanel, RailwayRoute, RailwayRoutePanelVM> {
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.COL_CODE);
        params.getColumns().add(DictHandlersHelper.COL_CODE_VARIANTS);
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), (String)RailwayRoute.Property.country.name(), (String)Messages.Country, (Renderer)StandardRenderers.GENERIC));
    }

    protected void configureController(List<BiConsumer<RailwayRoute, RailwayRoutePanelVM>> toVM, List<BiConsumer<RailwayRoutePanelVM, RailwayRoute>> fromVM) {
        toVM.add((model, vm) -> {
            vm.setRailwayRoute(model.getCode());
            vm.setRailwayRouteCountry(model.getCountry());
            DictHandlersHelper.codeVariantsToVM((Map)model.getCodeVariants(), (List)vm.getCodeVariants().getContent());
            DictHandlersHelper.translationsToVM((Map)model.getTranslations(), (List)vm.getTranslations().getContent());
        });
        fromVM.add((vm, model) -> {
            model.setCode(StringUtils.trim((String)vm.getRailwayRoute()));
            model.setCountry(vm.getRailwayRouteCountry());
            DictHandlersHelper.codeVariantsFromVM((List)vm.getCodeVariants().getContent(), (Map)model.getCodeVariants());
            DictHandlersHelper.translationsFromVM((List)vm.getTranslations().getContent(), (Map)model.getTranslations());
        });
    }

    public Class<RailwayRoute> getDictType() {
        return RailwayRoute.class;
    }

    public DictionaryReference<RailwayRoute> createReference(String code) {
        return new RailwayRouteReference(code);
    }

    protected RailwayRoutePanelVM createVM() {
        return new RailwayRoutePanelVM();
    }

    protected ViewController<RailwayRoutePanel, RailwayRoutePanelVM> createController() {
        return new RailwayRoutePanelController(false);
    }
}

