/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.railway.dicts.handlers.railwaystation;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.model.dict.RailwayStationPanelVM;
import com.gridnine.xtrip.client.fx.model.dict.RailwayStationVendorContainerVM;
import com.gridnine.xtrip.client.fx.model.dict.SpellVariantVM;
import com.gridnine.xtrip.client.fx.railway.dicts.handlers.railwaystation.RailwayStationHandlerConfigurator;
import com.gridnine.xtrip.client.fx.railway.dicts.handlers.railwaystation.StandardRailwayStationControllerInterceptor;
import com.gridnine.xtrip.client.fx.railway.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationVendorCard;
import com.gridnine.xtrip.common.util.ReflectionUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;

class StandardRailwayStationHandlerConfigurator
implements RailwayStationHandlerConfigurator {
    StandardRailwayStationHandlerConfigurator() {
    }

    @Override
    public void configureListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.COL_CODE_VARIANTS);
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
        params.getColumns().add(DictHandlersHelper.createColumn(RailwayStation.class, (String)RailwayStation.Property.country.name(), (String)Messages.Country, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(RailwayStation.class, (String)RailwayStation.Property.route.name(), (String)Messages.Railroad, (Renderer)StandardRenderers.GENERIC));
        params.getFilters().add(DictHandlersHelper.createColumn(RailwayStation.class, (String)RailwayStation.Property.country.name(), (String)Messages.Country, (Renderer)StandardRenderers.GENERIC));
        params.getFilters().add(DictHandlersHelper.createColumn(RailwayStation.class, (String)RailwayStation.Property.route.name(), (String)Messages.Railroad, (Renderer)StandardRenderers.GENERIC));
    }

    @Override
    public void configureController(List<BiConsumer<RailwayStation, RailwayStationPanelVM>> toVM, List<BiConsumer<RailwayStationPanelVM, RailwayStation>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)((ControllerInterceptor)ReflectionUtil.createBySystemPropertyName((ClassLoader)this.getClass().getClassLoader(), (String)"client.fx.railway.dicts.handlers.railwaystation.RailwayStationControllerInterceptor.class", null, StandardRailwayStationControllerInterceptor::new)));
        toVM.add((model, vm) -> {
            vm.getMain().setCode(model.getCode());
            L10nString localizationString = new L10nString();
            localizationString.getValues().putAll(model.getShortNames());
            vm.getMain().setName(localizationString);
            vm.getMain().setRoute(model.getRoute());
            vm.getMain().setCountry(model.getCountry());
            VMHelper.transfer((Collection)model.getSpellVariants(), (Collection)vm.getSpellVariants().getContent(), spell -> {
                SpellVariantVM spellVM = new SpellVariantVM();
                spellVM.setSpellVariant(spell);
                return spellVM;
            });
            DictHandlersHelper.codeVariantsToVM((Map)model.getCodeVariants(), (List)vm.getCodeVariants().getContent());
            DictHandlersHelper.translationsToVM((Map)model.getTranslations(), (List)vm.getTranslations().getContent());
            VMHelper.transfer((Collection)model.getVendorCards(), (Collection)vm.getVendorCard(), card -> new RailwayStationVendorContainerVM(), (card, cardVM) -> {
                cardVM.setCountry(card.getCountry());
                cardVM.setName(card.getShortNames());
                cardVM.setRoute(card.getRoute());
                cardVM.setType(card.getType());
                cardVM.setTranslation(card.getTranslations());
                VMHelper.transfer((Collection)card.getSpellVariants(), (Collection)cardVM.getSpellVariants());
            });
        });
        fromVM.add((vm, model) -> {
            model.setCode(StringUtils.trim((String)vm.getMain().getCode()));
            model.getShortNames().clear();
            if (vm.getMain().getName() != null) {
                model.getShortNames().putAll(vm.getMain().getName().getValues());
            }
            model.setRoute(vm.getMain().getRoute());
            model.setCountry(vm.getMain().getCountry());
            DictHandlersHelper.codeVariantsFromVM((List)vm.getCodeVariants().getContent(), (Map)model.getCodeVariants());
            DictHandlersHelper.translationsFromVM((List)vm.getTranslations().getContent(), (Map)model.getTranslations());
            VMHelper.transfer((Collection)vm.getVendorCard(), (Collection)model.getVendorCards(), card -> new RailwayStationVendorCard(), (cardVM, card) -> {
                card.setCountry(cardVM.getCountry());
                card.setRoute(cardVM.getRoute());
                card.setType(cardVM.getType());
                if (cardVM.getTranslation() == null) {
                    card.getTranslations().getValues().clear();
                } else {
                    L10nStringHelper.copy((L10nString)cardVM.getTranslation(), (L10nString)card.getTranslations());
                }
                if (cardVM.getName() == null) {
                    card.getShortNames().getValues().clear();
                } else {
                    L10nStringHelper.copy((L10nString)cardVM.getName(), (L10nString)card.getShortNames());
                }
                VMHelper.transfer((Collection)cardVM.getSpellVariants(), (Collection)card.getSpellVariants());
            });
        });
    }
}

