/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.railway.entity.handlers.product;

import com.gridnine.xtrip.client.fx.core.lib.widgets.extendedtable.ExtendedTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.model.booking.BaseProductVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileContractPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductCommissionsVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductFopVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatistic;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductValidationMessagesVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileRailwayMcoProductSalesChainPane;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileVendorFinanceDocumentsDataPanelVM;
import com.gridnine.xtrip.client.fx.railway.entity.handlers.product.helper.RailwayMcoProductFXHelper;
import com.gridnine.xtrip.client.fx.railway.l10n.Messages;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileRailwayMcoProductPanel;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileRailwayMcoProductPanelController;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileRailwayMcoProductPanelVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.common.fx.railway.model.uidata.RailwayMcoProductUIData;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductIndex;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.UUIDUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javafx.scene.Node;

public class RailwayMcoProductFXHandler
implements ProductFXHandler<RailwayMcoProduct, RailwayProductIndex, RailwayMcoProductUIData, Void> {
    public Class<RailwayMcoProduct> getProductClass() {
        return RailwayMcoProduct.class;
    }

    public Class<RailwayProductIndex> getProductIndexClass() {
        return RailwayProductIndex.class;
    }

    public String getDisplayName() {
        return ProductType.RAILWAY_MCO.toString();
    }

    public StatisticalData getStatisticalData(RailwayMcoProduct product) {
        return product.getStatisticalData();
    }

    public void newStatisticalData(RailwayMcoProduct product) {
        product.setStatisticalData(new StatisticalData());
    }

    public Collection<Traveller> getTravellers(RailwayMcoProduct product) {
        return product.getPassengers();
    }

    public void setAgent(RailwayMcoProduct product, EntityReference<Person> agent) {
        product.setCashier(agent);
    }

    public boolean isEMDOrExcessBagage(RailwayMcoProduct product) {
        return true;
    }

    public List<BaseProduct> getRelatedProducts(RailwayMcoProduct product) {
        return new ArrayList<BaseProduct>(product.getRelatedProducts());
    }

    public boolean removeRelatedProduct(RailwayMcoProduct product, BaseProduct removedProduct) {
        return product.getRelatedProducts().removeIf(p -> MiscUtil.equals((Object)p, (Object)removedProduct));
    }

    public void remove(RailwayMcoProduct product) {
        RailwayMcoProduct nextProduct;
        product.getReservation().getProducts().remove(product);
        RailwayMcoProduct previousProduct = product.getPreviousProduct();
        if (previousProduct != null) {
            previousProduct.setNextProduct(null);
        }
        if ((nextProduct = product.getNextProduct()) != null) {
            nextProduct.setPreviousProduct(null);
        }
    }

    public void fromVM(BaseProductVM vm, RailwayMcoProduct product, RailwayMcoProductUIData productData) {
        if (product.getStatus() == null) {
            product.setStatus(ProductStatus.SELL);
        }
        if (product.getTicketType() == null) {
            product.setTicketType(TicketType.OWN);
        }
        BookingFileRailwayMcoProductPanelVM productVM = (BookingFileRailwayMcoProductPanelVM)vm;
        RailwayMcoProductFXHelper.fromVMParameters(productVM, product, productData);
        RailwayMcoProductFXHelper.fromVMSegmentsVM(productVM, product);
        RailwayMcoProductFXHelper.fromVMCostVM(productVM.getCostAndRelated().getCost(), product);
        RailwayMcoProductFXHelper.fromVMRailwayAdditionalParameters(productVM, product);
        RailwayMcoProductFXHelper.fromVMRailwayMcoRelatedProducts(productVM.getCostAndRelated().getRelated(), product);
        GeneralProductFXHelper.fromVMCommissions((BaseProduct)product, (BookingFileProductCommissionsVM)productVM.getCommissions(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMFop((BaseProduct)product, (BookingFileProductFopVM)productVM.getFops(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMProductContract((BookingFileContractPanelVM)productVM.getFops().getContract(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMVendorFinanceDocumentsData((BookingFileVendorFinanceDocumentsDataPanelVM)productVM.getFops().getVendorFinanceDocumentsData(), (BaseProductUIData)productData);
        StatisticalData data = product.getStatisticalData();
        if (data == null) {
            data = new StatisticalData();
            product.setStatisticalData(data);
        }
        GeneralProductFXHelper.fromVMProductStatistic((BookingFile)product.getReservation().getBookingFile(), (BookingFileProductStatisticVM)productVM.getOtherParameters().getStatistic(), (StatisticalData)data, (BaseProductUIData)productData);
        product.setStatisticalData(data);
    }

    public RailwayMcoProduct getPreviousProduct(RailwayMcoProduct product) {
        return product.getPreviousProduct();
    }

    public RailwayMcoProduct getNextProduct(RailwayMcoProduct product) {
        return product.getNextProduct();
    }

    public RailwayMcoProduct createProduct() {
        return new RailwayMcoProduct();
    }

    public RailwayMcoProductUIData createUiData() {
        return new RailwayMcoProductUIData();
    }

    public BaseProductVM createVM(RailwayMcoProduct product) {
        return new BookingFileRailwayMcoProductPanelVM();
    }

    public String getRecordLocator(BaseProductVM vm) {
        return ((BookingFileRailwayMcoProductPanelVM)vm).getGeneral().getTravelerInfo().getInfo().getReservationValue();
    }

    public void toVM(RailwayMcoProduct product, RailwayMcoProductUIData productData, BaseProductVM vm, EntityReference<Organization> customerProfile) {
        List<ReasonCodeType> reasonCodeRailTypes = Arrays.asList(ReasonCodeType.REASON_CODE_RAIL, ReasonCodeType.REASON_CODE_NO_HOTEL, ReasonCodeType.REASON_CODE_DECLINED);
        BookingFileRailwayMcoProductPanelVM productVM = (BookingFileRailwayMcoProductPanelVM)vm;
        productVM.setStatus(product.getStatus());
        GeneralProductFXHelper.toVMProductFop((BaseProduct)product, (BaseProductUIData)productData, (BookingFileProductFopVM)productVM.getFops());
        GeneralProductFXHelper.toVMProductCommissions((BaseProduct)product, (BaseProductUIData)productData, (BookingFileProductCommissionsVM)productVM.getCommissions());
        GeneralProductFXHelper.toVMProductContract((BaseProductUIData)productData, (BookingFileContractPanelVM)productVM.getFops().getContract());
        GeneralProductFXHelper.toVMPrepaymentDocuments((BaseProductUIData)productData, (List)productVM.getFops().getPrepaymentDocuments());
        GeneralProductFXHelper.toVMVendorFinanceDocumentsData((BaseProductUIData)productData, (BookingFileVendorFinanceDocumentsDataPanelVM)productVM.getFops().getVendorFinanceDocumentsData());
        GeneralProductFXHelper.toVMProductStatistic((StatisticalData)product.getStatisticalData(), (BaseProductUIData)productData, reasonCodeRailTypes, RailwayMcoProduct.class, (BookingFileProductStatisticVM)productVM.getOtherParameters().getStatistic(), customerProfile);
        GeneralProductFXHelper.toVMValidationMessages((List)product.getValidationMessages(), (String)product.getUid(), (BookingFileProductValidationMessagesVM)productVM.getOtherParameters().getValidation());
        RailwayMcoProductFXHelper.toVMAllPanels(product, productData, productVM);
    }

    public ProductStatus getProductStatus(RailwayMcoProduct product) {
        return product.getStatus();
    }

    public boolean isDeletable(RailwayMcoProduct product) {
        return product.getNextProduct() == null;
    }

    public boolean isAwareOf(Node node) {
        return node instanceof BookingFileRailwayMcoProductPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node createNodeForNewProduct(BookingFileSpaceVM bookingFileVM, Void configuration, Map<String, Object> parameters) {
        BookingFile bookingFile = (BookingFile)parameters.get("bookingFile");
        Reservation reservation = (Reservation)parameters.get("reservation");
        BookingFileRailwayMcoProductPanelVM productVM = new BookingFileRailwayMcoProductPanelVM();
        productVM.setBookingFile(bookingFile);
        productVM.setProductFullNameWithSpaces(ProductType.RAILWAY_MCO.toString());
        MiscUtil.Pair<RailwayMcoProduct, RailwayMcoProductUIData> prototypeData = RailwayMcoProductFXHelper.getPrototypeData();
        RailwayMcoProduct product = (RailwayMcoProduct)prototypeData.getFirst();
        RailwayMcoProductUIData productSupplementData = (RailwayMcoProductUIData)prototypeData.getSecond();
        productVM.setProductUiData((BaseProductUIData)productSupplementData);
        String reservationUid = UUIDUtil.toString((UUID)UUID.randomUUID());
        if (reservation == null) {
            reservation = new Reservation(reservationUid);
        }
        if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
            bookingFile.getReservations().add(reservation);
            reservation.setBookingFile(bookingFile);
        }
        reservation.getProducts().add(product);
        product.setReservation(reservation);
        GeneralProductHelper.fillCommonCostCodes((BookingFile)bookingFile, (BaseProduct)product);
        try {
            this.toVM(product, productSupplementData, (BaseProductVM)productVM, null);
            BookingFileRailwayMcoProductPanel node = new BookingFileRailwayMcoProductPanel(false);
            node.getProperties().put((Object)"model-uid", (Object)product.getUid());
            RailwayMcoProductFXHelper.updateNode(node, bookingFileVM);
            BookingFileRailwayMcoProductPanelController controller = new BookingFileRailwayMcoProductPanelController(node, false);
            controller.readData(productVM);
            BookingFileRailwayMcoProductPanel bookingFileRailwayMcoProductPanel = node;
            return bookingFileRailwayMcoProductPanel;
        }
        finally {
            reservation.getProducts().remove(product);
            product.setReservation(null);
            if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
                bookingFile.getReservations().remove(reservation);
                reservation.setBookingFile(null);
            }
        }
    }

    public Node createNodeForExistingProduct(BookingFileSpaceVM bookingFileVM, Map<String, Object> parameters) {
        BookingFileRailwayMcoProductPanel node = new BookingFileRailwayMcoProductPanel(false);
        RailwayMcoProductFXHelper.updateNode(node, bookingFileVM);
        return node;
    }

    public ProductType getProductType(RailwayMcoProduct product) {
        return ProductType.RAILWAY_MCO;
    }

    public Set<ContractType> getHiddenContractTypes(Node node) {
        BookingFileRailwayMcoProductSalesChainPane paramsPane = ((BookingFileRailwayMcoProductPanel)node).getGeneralNode().getSalesChainNode();
        return GeneralProductFXHelper.getHiddenContractTypes((EntityReference)paramsPane.getAgencyValueNode().getValue(), (EntityReference)paramsPane.getSubagencyValueNode().getValue());
    }

    public void validate(String uid, Node node, List<Message> errors) {
        BookingFileRailwayMcoProductPanel panel = (BookingFileRailwayMcoProductPanel)node;
        String systemNumber = panel.getGeneralNode().getTicketInfoNode().getTicketNumberValueNode().getValue();
        boolean emptyPaymentType = ((ExtendedTableWidget)panel.getFopsNode().getFopTableCell().getPayload()).getTable().getRows().stream().anyMatch(item -> ((ComboBoxWidget)item.getWidget("paymentType")).getValue() == null);
        if (emptyPaymentType) {
            errors.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ProductPaymentTypeIsEmpty, (Object[])new Object[]{systemNumber}));
        }
    }

    public void validateStatisticalData(BookingFileSpace space, String uid, Node node, List<Message> errors) throws Exception {
        if (node instanceof BookingFileRailwayMcoProductPanel) {
            BookingFileRailwayMcoProductPanel panel = (BookingFileRailwayMcoProductPanel)node;
            Collection statisticUdidsVMS = ((TableWidget)((BookingFileProductStatistic)panel.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getUdidsCard().getContent()).getRowsData();
            GeneralProductFXHelper.validateStatisticalData((BookingFileSpace)space, (String)uid, (Collection)statisticUdidsVMS, errors);
        }
    }
}

