/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.railway.entity.handlers.product.controllerInterceptors;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.HyperlinkWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.MultiProvider;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileRailwayMcoRelatedProductsController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileRailwayMcoRelatedProductsTableVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileRailwayMcoRelatedProductsVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.railway.entity.handlers.product.controllerInterceptors.AddRailwayProductsDialog;
import com.gridnine.xtrip.client.fx.standard.helpers.BookingFileSpaceHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.scene.Node;

public class BookingFileRailwayMcoRelatedProductsControllerInterceptor
extends ControllerInterceptor<BookingFileRailwayMcoRelatedProductsVM, BookingFileRailwayMcoRelatedProductsController> {
    protected Class<BookingFileRailwayMcoRelatedProductsController> getControllerClass() {
        return BookingFileRailwayMcoRelatedProductsController.class;
    }

    protected void onCreate(BookingFileRailwayMcoRelatedProductsController controller) {
        TableWidget productTableWidget = controller.getView().getRelatedProductsNode();
        productTableWidget.setItemsProvider(this.createItemsProvider(controller, null));
        this.setOnRowsAction((TableWidget<BookingFileRailwayMcoRelatedProductsTableVM>)productTableWidget);
    }

    private void setOnRowsAction(TableWidget<BookingFileRailwayMcoRelatedProductsTableVM> productTableWidget) {
        productTableWidget.setOnRowsAction(event -> {
            if (event.getEventType().equals(TableRowEvent.ROW_ADD)) {
                int idx = event.getRowIndex();
                BookingFileRailwayMcoRelatedProductsControllerInterceptor.setActionLink(productTableWidget, idx);
            }
        });
    }

    protected void afterReadData(BookingFileRailwayMcoRelatedProductsController controller, BookingFileRailwayMcoRelatedProductsVM model) {
        TableWidget productTableWidget = controller.getView().getRelatedProductsNode();
        IntStream.range(0, productTableWidget.getRowsCount()).forEach(index -> BookingFileRailwayMcoRelatedProductsControllerInterceptor.setActionLink((TableWidget<BookingFileRailwayMcoRelatedProductsTableVM>)productTableWidget, index));
        productTableWidget.setItemsProvider(this.createItemsProvider(controller, model));
        this.setOnRowsAction((TableWidget<BookingFileRailwayMcoRelatedProductsTableVM>)productTableWidget);
    }

    private MultiProvider<BookingFileRailwayMcoRelatedProductsTableVM> createItemsProvider(final BookingFileRailwayMcoRelatedProductsController controller, final BookingFileRailwayMcoRelatedProductsVM model) {
        return new MultiProvider<BookingFileRailwayMcoRelatedProductsTableVM>(){

            public BookingFileRailwayMcoRelatedProductsTableVM createOne() {
                return new BookingFileRailwayMcoRelatedProductsTableVM();
            }

            public void createAny(Consumer<Collection<BookingFileRailwayMcoRelatedProductsTableVM>> consumer) {
                ArrayList alreadySelected = new ArrayList();
                controller.getRelatedProducts().writeData(alreadySelected);
                ArrayList<String> usedUids = new ArrayList<String>();
                if (model != null) {
                    usedUids.add(model.getProductUid());
                }
                usedUids.addAll(alreadySelected.stream().map(p -> p.getProductUID()).collect(Collectors.toList()));
                RootEntityPane rootEntityPane = Objects.requireNonNull(RootEntityPane.lookup((Node)controller.getView()));
                BookingFile bookingFile = (BookingFile)rootEntityPane.getData().getContainer().getEntity();
                List<RailwayProduct> products = bookingFile.getReservations().stream().flatMap(res -> res.getProducts().stream()).filter(p -> !usedUids.contains(p.getUid()) && p instanceof RailwayProduct).map(bp -> (RailwayProduct)bp).collect(Collectors.toList());
                AddRailwayProductsDialog dialog = new AddRailwayProductsDialog(rootEntityPane.getEditor(), products);
                dialog.showDialog(() -> {
                    List rows = dialog.getSelectedProducts().stream().map(selectedProduct -> {
                        RailwayProduct product = (RailwayProduct)bookingFile.getReservations().stream().flatMap(res -> res.getProducts().stream()).filter(arg_0 -> ((RailwayProduct)selectedProduct).equals(arg_0)).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)("Unknown product with uid " + selectedProduct.getUid()), (Object[])new Object[0]));
                        BookingFileRailwayMcoRelatedProductsTableVM productVM = new BookingFileRailwayMcoRelatedProductsTableVM();
                        productVM.setProduct(BookingHelper.generateShortProductName((BaseProduct)product));
                        productVM.setProductUID(product.getUid());
                        return productVM;
                    }).collect(Collectors.toList());
                    consumer.accept(rows);
                });
            }
        };
    }

    private static void setActionLink(TableWidget<BookingFileRailwayMcoRelatedProductsTableVM> productTableWidget, int ind) {
        HyperlinkWidgetColumn productHyperlinkWidgetColumn = (HyperlinkWidgetColumn)productTableWidget.getColumn("product");
        HyperlinkWidget hyperlinkWidget = (HyperlinkWidget)productHyperlinkWidgetColumn.getWidget(ind);
        String productUID = ((BookingFileRailwayMcoRelatedProductsTableVM)productTableWidget.getData(ind)).getProductUID();
        hyperlinkWidget.setOnAction(evt -> {
            BookingFileSpace bookingFileSpace = BookingFileSpaceHelper.lookupBookingFileSpace((Node)productTableWidget);
            CompactNavigatorWidget widget = (CompactNavigatorWidget)((BookingFileProductsFullPanel)bookingFileSpace.getProductsTile().getFullNode()).getContent();
            Node node = UiUtil.findViewWithModelUid((Iterable)widget.getViews(), (String)productUID);
            if (node != null) {
                widget.selectView(node);
            }
        });
    }
}

