/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.railway.tasks;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.railway.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.helpers.BookingFileSpaceHelper;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.ProductExchangeRefundProperties;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class RailwayProductRefundTask
extends ClientTask {
    private final String productUid;
    private final EntityReference<BookingFile> bookingFileReference;
    private final ProductExchangeRefundProperties refundProperties;
    private final boolean needSelectNewProduct;
    private final Control source;

    public RailwayProductRefundTask(String uid, EntityReference<BookingFile> bfRef, ProductExchangeRefundProperties props, boolean needSelect, Control src) {
        this.productUid = uid;
        this.bookingFileReference = bfRef;
        this.refundProperties = props;
        this.source = src;
        this.needSelectNewProduct = needSelect;
    }

    protected void execute() throws Exception {
        try {
            BookingFileService.ProductRPCResult result = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).refundProduct(ServiceInvocationContext.get(), this.productUid, this.bookingFileReference, this.refundProperties);
            this.addMessages(result.getResultMessageList());
            if (this.needSelectNewProduct && result.getResultProductUid() != null) {
                BookingFileSpace bookingFileSpace = BookingFileSpaceHelper.lookupBookingFileSpace((Node)this.source);
                RootEntityPane entityPane = RootEntityPane.lookup((Node)bookingFileSpace);
                Notifications.get().submitTask(() -> {
                    entityPane.reloadData();
                    FxUtil.submitToFxThread(() -> {
                        Node node = UiUtil.findViewWithModelUid((Iterable)((CompactNavigatorWidget)((BookingFileProductsFullPanel)bookingFileSpace.getProductsTile().getFullNode()).getContent()).getViews(), (String)result.getResultProductUid());
                        if (node != null) {
                            bookingFileSpace.expand(bookingFileSpace.getProductsTile());
                            ((CompactNavigatorWidget)((BookingFileProductsFullPanel)bookingFileSpace.getProductsTile().getFullNode()).getContent()).selectView(node);
                        }
                    });
                }, entityPane.getMutex());
            } else {
                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, new EntityModification(this.bookingFileReference, EntityModification.ModificationType.CHANGE)));
            }
        }
        catch (Exception e) {
            EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, new EntityModification(this.bookingFileReference, EntityModification.ModificationType.CHANGE)));
            ErrorHandler.handle((Throwable)e);
        }
    }

    protected String getTitle() {
        return Messages.Service_payback;
    }
}

