/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.railway.model.helpers;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Contractor;
import com.gridnine.xtrip.common.model.booking.FopType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.booking.railway.RailwayCrimeaMco;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PredefinedContractRelationType;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.profile.PredefinedSalesChainType;
import com.gridnine.xtrip.common.model.profile.SalesChainDescription;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductDictionaryHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayStationDictionaryHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public final class RailwayCrimeaMcoHelper {
    private static final String STATION_SEPARATOR = "-";
    private static final String ROUTE_SEPARATOR = " / ";
    private static final String UNKNOWN_STATION = "?";
    private static final String UNKNOWN_PASSENGER = "?";
    private static final String UNKNOWN_SCN = "?";
    private static final String NAME_SEPARATOR = " ";

    public static BigDecimal calculateTotalEquivalentFare(RailwayCrimeaMco product) {
        BigDecimal penalty;
        BigDecimal totalEquivalentFare = null;
        BigDecimal tariffEquivalentFare = product.getEquivalentFare();
        if (tariffEquivalentFare != null) {
            totalEquivalentFare = tariffEquivalentFare;
        }
        if ((penalty = product.getPenalty()) != null) {
            totalEquivalentFare = totalEquivalentFare == null ? penalty.negate() : totalEquivalentFare.subtract(penalty);
        }
        return totalEquivalentFare;
    }

    public static BigDecimal calculateTotalEquivalentVat(RailwayCrimeaMco product) {
        BigDecimal penaltyVat;
        BigDecimal totalEquivalentVat = null;
        BigDecimal tariffEquivalentVat = product.getEquivalentVat();
        if (tariffEquivalentVat != null) {
            totalEquivalentVat = tariffEquivalentVat;
        }
        if ((penaltyVat = product.getPenaltyVat()) != null) {
            totalEquivalentVat = totalEquivalentVat == null ? penaltyVat.negate() : totalEquivalentVat.subtract(penaltyVat);
        }
        return totalEquivalentVat;
    }

    public static String getShortNameString(RailwayCrimeaMco product) {
        StringBuilder productName = new StringBuilder();
        productName.append("\u0416/\u0414 \u041a\u0420\u0421 \u041a\u0440\u044b\u043c");
        String systemNumber = product.getSystemNumber();
        ProductStatus status = product.getStatus();
        if (systemNumber != null) {
            productName.append(NAME_SEPARATOR);
            if (systemNumber != null) {
                productName.append(systemNumber);
            }
        }
        if (status != null) {
            productName.append(NAME_SEPARATOR);
            productName.append(status);
        }
        return productName.toString();
    }

    public static String getNameString(RailwayCrimeaMco product) {
        return RailwayCrimeaMcoHelper.getShortNameString(product) + NAME_SEPARATOR + RailwayProductHelper.getTravellersString(product.getPassengers(), ", ");
    }

    public static String getShortRouteString(RailwayCrimeaMco product) {
        return RailwayCrimeaMcoHelper.getRouteString(product, true);
    }

    public static String getRouteString(RailwayCrimeaMco product) {
        return RailwayCrimeaMcoHelper.getRouteString(product, false);
    }

    private static String getRouteString(RailwayCrimeaMco product, boolean isShort) {
        StringBuilder routeString = new StringBuilder();
        String lastStationCode = null;
        DictionaryCache cache = DictionaryCache.get();
        for (RailwaySegment segment : product.getSegments()) {
            String departureStationName = "?";
            String arriveStationName = "?";
            String departureStationCode = null;
            String arriveStationCode = null;
            RailwayStation departureStation = null;
            RailwayStation arriveStation = null;
            if (segment != null) {
                departureStation = (RailwayStation)cache.resolveReference(segment.getDepartureStation());
                arriveStation = (RailwayStation)cache.resolveReference(segment.getArriveStation());
            }
            if (departureStation != null) {
                departureStationName = isShort ? RailwayStationDictionaryHelper.getAnyShortName(departureStation) : departureStation.toString();
                departureStationCode = departureStation.getCode();
            }
            if (arriveStation != null) {
                arriveStationName = isShort ? RailwayStationDictionaryHelper.getAnyShortName(arriveStation) : arriveStation.toString();
                arriveStationCode = arriveStation.getCode();
            }
            if (routeString.length() == 0) {
                routeString.append(departureStationName);
            } else if (!TextUtil.isSame(lastStationCode, (String)departureStationCode)) {
                routeString.append(ROUTE_SEPARATOR);
                routeString.append(departureStationName);
            }
            if (!TextUtil.isSame((String)departureStationCode, (String)arriveStationCode)) {
                routeString.append(STATION_SEPARATOR);
                routeString.append(arriveStationName);
            }
            lastStationCode = arriveStationCode;
        }
        return routeString.toString();
    }

    public static List<String> getTravellersNames(RailwayCrimeaMco product) {
        return RailwayProductHelper.getTravellersNames(product.getPassengers());
    }

    public static String getDepartureDateString(RailwayCrimeaMco product) {
        if (product.getSegments().isEmpty()) {
            return "?";
        }
        Date departureDate = ((RailwaySegment)product.getSegments().get(0)).getDepartureDate();
        if (departureDate == null) {
            return "?";
        }
        return LocaleManager.get().getCurrentLocaleData().getDateFormat().format(departureDate);
    }

    public static List<String> getSCNs(RailwayCrimeaMco product) {
        ArrayList<String> scns = new ArrayList<String>();
        scns.add(product.getScn() != null ? product.getScn() : "?");
        return scns;
    }

    public static ServiceLocationType getServiceLocationType(RailwayCrimeaMco product) {
        return RailwayCrimeaMcoHelper.getTransportationType(product) == TransportationType.DOMESTIC ? ServiceLocationType.DOMESTIC : ServiceLocationType.INTERNATIONAL;
    }

    public static TransportationType getTransportationType(RailwayCrimeaMco product) {
        if (product == null) {
            return null;
        }
        boolean domestic = false;
        boolean international = false;
        for (RailwaySegment segment : product.getSegments()) {
            DictionaryReference departureLocation = segment.getDepartureStation();
            DictionaryReference arriveLocation = segment.getArriveStation();
            Country departureCountry = RailwayProductDictionaryHelper.getCountry((DictionaryReference<RailwayStation>)departureLocation);
            Country arriveCountry = RailwayProductDictionaryHelper.getCountry((DictionaryReference<RailwayStation>)arriveLocation);
            if (arriveCountry == null || departureCountry == null) continue;
            if (departureCountry.isDomestic() && arriveCountry.isDomestic()) {
                domestic = true;
                continue;
            }
            international = true;
        }
        if (domestic && international) {
            return TransportationType.COMBINED;
        }
        if (domestic) {
            return TransportationType.DOMESTIC;
        }
        if (international) {
            return TransportationType.INTERNATIONAL;
        }
        return TransportationType.NONE;
    }

    public static void copy(RailwayCrimeaMco source, RailwayCrimeaMco target, boolean keepReservation) throws Exception {
        if (source == null || target == null) {
            return;
        }
        RailwayCrimeaMco sourcePrevProduct = source.getPreviousProduct();
        RailwayCrimeaMco sourceNextProduct = source.getNextProduct();
        RailwayCrimeaMco targetPrevProduct = target.getPreviousProduct();
        RailwayCrimeaMco targetNextProduct = target.getNextProduct();
        List targetRelatedProducts = target.getRelatedProducts();
        source.setPreviousProduct(null);
        source.setNextProduct(null);
        Reservation reservation = source.getReservation();
        ArrayList travellers = new ArrayList();
        travellers.addAll(source.getPassengers());
        source.setReservation(null);
        source.getPassengers().clear();
        ArrayList relatedProducts = new ArrayList();
        relatedProducts.addAll(source.getRelatedProducts());
        source.getRelatedProducts().clear();
        EntityReference agent = source.getAgent();
        EntityReference salesPoint = source.getSalesPoint();
        EntityReference<Organization> subagency = RailwayCrimeaMcoHelper.getSubagency(source);
        EntityReference<Organization> agency = RailwayCrimeaMcoHelper.getAgency(source);
        EntityReference<Organization> supplier = RailwayCrimeaMcoHelper.getSupplier(source);
        XCloneModelHelper.copy((BaseEntity)source, (BaseEntity)target, (boolean)true);
        source.getRelatedProducts().addAll(relatedProducts);
        target.setReservation(reservation);
        source.setReservation(reservation);
        target.getPassengers().addAll(travellers);
        source.getPassengers().addAll(travellers);
        source.setPreviousProduct(sourcePrevProduct);
        source.setNextProduct(sourceNextProduct);
        if (keepReservation && source.getReservation() != null && !source.getReservation().getProducts().contains(target)) {
            source.getReservation().getProducts().add(target);
        }
        target.setPreviousProduct(targetPrevProduct);
        target.setNextProduct(targetNextProduct);
        target.getRelatedProducts().clear();
        target.getRelatedProducts().addAll(targetRelatedProducts);
        target.setIssueDate(source.getIssueDate());
        target.setSystemNumber(source.getSystemNumber());
        target.setAgent(agent);
        target.setSalesPoint(salesPoint);
        RailwayCrimeaMcoHelper.setSubagency(target, subagency);
        RailwayCrimeaMcoHelper.setAgency(target, agency);
        RailwayCrimeaMcoHelper.setSupplier(target, supplier);
        List<RailwayProductFop> targetClientFops = RailwayCrimeaMcoHelper.getClientFops(target);
        List<RailwayProductFop> sourceClientFops = RailwayCrimeaMcoHelper.getClientFops(source);
        for (int i = 0; i < targetClientFops.size(); ++i) {
            targetClientFops.get(i).setAgent(sourceClientFops.get(i).getAgent());
        }
        List<RailwayProductFop> targetVendorFops = RailwayCrimeaMcoHelper.getVendorFops(target);
        List<RailwayProductFop> sourceVendorFops = RailwayCrimeaMcoHelper.getVendorFops(source);
        for (int i = 0; i < targetVendorFops.size(); ++i) {
            targetVendorFops.get(i).setAgent(sourceVendorFops.get(i).getAgent());
        }
    }

    public static void copy(RailwayCrimeaMco source, RailwayCrimeaMco target) throws Exception {
        if (source == null || target == null) {
            return;
        }
        RailwayCrimeaMco sourcePrevProduct = source.getPreviousProduct();
        RailwayCrimeaMco sourceNextProduct = source.getNextProduct();
        RailwayCrimeaMco targetPrevProduct = target.getPreviousProduct();
        RailwayCrimeaMco targetNextProduct = target.getNextProduct();
        List targetRelatedProducts = target.getRelatedProducts();
        source.setPreviousProduct(null);
        source.setNextProduct(null);
        Reservation reservation = source.getReservation();
        ArrayList travellers = new ArrayList();
        travellers.addAll(source.getPassengers());
        source.setReservation(null);
        source.getPassengers().clear();
        ArrayList relatedProducts = new ArrayList();
        relatedProducts.addAll(source.getRelatedProducts());
        source.getRelatedProducts().clear();
        EntityReference agent = source.getAgent();
        EntityReference salesPoint = source.getSalesPoint();
        EntityReference<Organization> subagency = RailwayCrimeaMcoHelper.getSubagency(source);
        EntityReference<Organization> agency = RailwayCrimeaMcoHelper.getAgency(source);
        EntityReference<Organization> supplier = RailwayCrimeaMcoHelper.getSupplier(source);
        XCloneModelHelper.copy((BaseEntity)source, (BaseEntity)target, (boolean)true);
        source.getRelatedProducts().addAll(relatedProducts);
        target.setReservation(reservation);
        source.setReservation(reservation);
        target.getPassengers().addAll(travellers);
        source.getPassengers().addAll(travellers);
        source.setPreviousProduct(sourcePrevProduct);
        source.setNextProduct(sourceNextProduct);
        target.setPreviousProduct(targetPrevProduct);
        target.setNextProduct(targetNextProduct);
        target.getRelatedProducts().clear();
        target.getRelatedProducts().addAll(targetRelatedProducts);
        target.setIssueDate(source.getIssueDate());
        target.setSystemNumber(source.getSystemNumber());
        target.setAgent(agent);
        target.setSalesPoint(salesPoint);
        RailwayCrimeaMcoHelper.setSubagency(target, subagency);
        RailwayCrimeaMcoHelper.setAgency(target, agency);
        RailwayCrimeaMcoHelper.setSupplier(target, supplier);
        List<RailwayProductFop> targetClientFops = RailwayCrimeaMcoHelper.getClientFops(target);
        List<RailwayProductFop> sourceClientFops = RailwayCrimeaMcoHelper.getClientFops(source);
        for (int i = 0; i < targetClientFops.size(); ++i) {
            targetClientFops.get(i).setAgent(sourceClientFops.get(i).getAgent());
        }
        List<RailwayProductFop> targetVendorFops = RailwayCrimeaMcoHelper.getVendorFops(target);
        List<RailwayProductFop> sourceVendorFops = RailwayCrimeaMcoHelper.getVendorFops(source);
        for (int i = 0; i < targetVendorFops.size(); ++i) {
            targetVendorFops.get(i).setAgent(sourceVendorFops.get(i).getAgent());
        }
        target.getShipments().clear();
        target.getPrepaymentDocuments().clear();
        target.getFopDetalizations().clear();
    }

    public static void updateFops(RailwayCrimeaMco product) {
        RailwayCrimeaMcoHelper.updateProductFops(product);
        RailwayCrimeaMcoHelper.updateFeeFops(product);
        RailwayCrimeaMcoHelper.updateDiscountFops(product);
    }

    public static void updateProductFops(RailwayCrimeaMco product) {
        RailwayCrimeaMcoHelper.updateProductFops(product, ContractType.VENDOR);
        RailwayCrimeaMcoHelper.updateProductFops(product, ContractType.SUBAGENCY);
        RailwayCrimeaMcoHelper.updateProductFops(product, ContractType.CLIENT);
    }

    public static void updateFeeFops(RailwayCrimeaMco product) {
        RailwayCrimeaMcoHelper.updateFeeFops(product, ContractType.VENDOR);
        RailwayCrimeaMcoHelper.updateFeeFops(product, ContractType.SUBAGENCY);
        RailwayCrimeaMcoHelper.updateFeeFops(product, ContractType.CLIENT);
    }

    public static void updateDiscountFops(RailwayCrimeaMco product) {
        RailwayCrimeaMcoHelper.updateDiscountFops(product, ContractType.VENDOR);
        RailwayCrimeaMcoHelper.updateDiscountFops(product, ContractType.SUBAGENCY);
        RailwayCrimeaMcoHelper.updateDiscountFops(product, ContractType.CLIENT);
    }

    private static void updateProductFops(RailwayCrimeaMco product, ContractType contractType) {
        BigDecimal totalEquivalentFare = MiscUtil.nonNull((BigDecimal)RailwayCrimeaMcoHelper.calculateTotalEquivalentFare(product));
        for (RailwayProductContractRelationData relation : RailwayCrimeaMcoHelper.getContractRelations(product)) {
            boolean exchange;
            if (GeneralProductHelper.getContractType((EntityReference)relation.getDescription()) != contractType) continue;
            List fops = relation.getFops();
            if (!RailwayCrimeaMcoHelper.isFareFopsRelevant(product)) {
                Collection<RailwayProductFop> productFops = RailwayProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, null, null, null);
                fops.removeAll(productFops);
                continue;
            }
            Collection<RailwayProductFop> ticketPaymentTypeFops = RailwayProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, Collections.singleton(PaymentType.TICKET), null, null);
            fops.removeAll(ticketPaymentTypeFops);
            boolean bl = exchange = product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE;
            if (exchange) {
                HashSet<PaymentType> nonTicketPaymentTypes = new HashSet<PaymentType>(Arrays.asList(PaymentType.values()));
                nonTicketPaymentTypes.remove(PaymentType.TICKET);
                Collection<RailwayProductFop> filteredVendorFops = RailwayProductHelper.filterFops(RailwayCrimeaMcoHelper.getVendorFops(product.getPreviousProduct()), null, nonTicketPaymentTypes, null, null);
                BigDecimal filteredVendorTotalEquivalentFop = RailwayProductHelper.calculateTotalEquivalentFop(filteredVendorFops, DictHelper.getLocalCurrencyCode(), FinanceHelper.getCurrencyRateType((String)DictHelper.getLocalCurrencyCode()), product.getPreviousProduct().getIssueDate(), (EntityReference<Organization>)GeneralProductHelper.getSupplier((BaseProduct)product.getPreviousProduct()));
                if (ticketPaymentTypeFops.isEmpty()) {
                    RailwayProductFop ticketPaymentTypeVendorFop = RailwayCrimeaMcoHelper.createFop(PaymentType.TICKET, filteredVendorTotalEquivalentFop);
                    fops.add(ticketPaymentTypeVendorFop);
                } else {
                    Money money = new Money();
                    money.setValue(filteredVendorTotalEquivalentFop);
                    money.setCurrency(DictHelper.getLocalCurrency2());
                    RailwayProductFop ticketPaymentTypeVendorFop = ticketPaymentTypeFops.iterator().next();
                    ticketPaymentTypeVendorFop.setAmount(money);
                    fops.add(ticketPaymentTypeVendorFop);
                }
            }
            BigDecimal difference = totalEquivalentFare;
            Collection<RailwayProductFop> productFops = RailwayProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, null, null, null);
            BigDecimal totalEquivalentFopValue = RailwayProductHelper.calculateTotalEquivalentFop(productFops, DictHelper.getLocalCurrencyCode(), FinanceHelper.getCurrencyRateType((String)DictHelper.getLocalCurrencyCode()), product.getIssueDate(), (EntityReference<Organization>)GeneralProductHelper.getSupplier((BaseProduct)product));
            totalEquivalentFopValue = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentFopValue, MiscUtil.negate((BigDecimal)RailwayProductHelper.calculateHiddenFeesEquivalentValue(productFops))});
            Collection commissions = GeneralProductHelper.filterCommissions((Collection)relation.getCommissions(), (Set)GeneralProductHelper.feePropertyTypes, null, (Set)GeneralProductHelper.hiddenCommissionCategories);
            ArrayList<GeneralProductCommission> unusedCommissions = new ArrayList<GeneralProductCommission>();
            unusedCommissions.addAll(commissions);
            for (RailwayProductFop productFop : RailwayProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, null, null, null)) {
                ArrayList<GeneralProductCommission> productCommissions = new ArrayList<GeneralProductCommission>();
                for (GeneralProductCommission fopCommission : productFop.getCommissions()) {
                    if (!unusedCommissions.contains(fopCommission)) continue;
                    unusedCommissions.remove(fopCommission);
                    GeneralProductCommission productCommission = (GeneralProductCommission)CollectionUtil.find((Iterable)commissions, (String)fopCommission.getUid());
                    if (productCommission == null) continue;
                    productFop.getAmount().setValue(MiscUtil.sum((BigDecimal[])new BigDecimal[]{productFop.getAmount().getValue(), MiscUtil.negate((BigDecimal)productCommission.getEquivalentAmount())}));
                    if (productFop.getAmount().getValue() != null && productFop.getAmount().getValue().compareTo(BigDecimal.ZERO) < 0) {
                        productFop.getAmount().setValue(BigDecimal.ZERO);
                    }
                    productCommissions.add(productCommission);
                }
                productFop.getCommissions().clear();
                productFop.getCommissions().addAll(productCommissions);
            }
            RailwayCrimeaMcoHelper.distributeCommissionsToFops(fops, unusedCommissions, GeneralProductHelper.serviceFeePropertyTypes, GeneralProductHelper.productFopTypes);
            for (RailwayProductFop productFop : RailwayProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, null, null, null)) {
                BigDecimal commissionsEquivalentValue = GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)productFop.getCommissions());
                Money productFopAmount = productFop.getAmount();
                Money amount = productFopAmount != null ? productFopAmount : new Money();
                amount.setValue(MiscUtil.sum((BigDecimal[])new BigDecimal[]{amount.getValue(), commissionsEquivalentValue}));
                productFop.setAmount(amount);
            }
            if ((difference = MiscUtil.sum((BigDecimal[])new BigDecimal[]{difference, MiscUtil.negate((BigDecimal)totalEquivalentFopValue)})).compareTo(BigDecimal.ZERO) == 0) continue;
            Collection<RailwayProductFop> cashPaymentTypeFops = RailwayProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, Collections.singleton(PaymentType.CASH), Collections.singleton(DictHelper.getLocalCurrency2()), null);
            if (!cashPaymentTypeFops.isEmpty()) {
                RailwayProductFop cashPaymentTypeFop = cashPaymentTypeFops.iterator().next();
                cashPaymentTypeFop.getAmount().setValue(MiscUtil.sum((BigDecimal[])new BigDecimal[]{cashPaymentTypeFop.getAmount().getValue(), difference}));
                continue;
            }
            Collection<RailwayProductFop> invoicePaymentTypeFops = RailwayProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, Collections.singleton(PaymentType.INVOICE), Collections.singleton(DictHelper.getLocalCurrency2()), null);
            if (!invoicePaymentTypeFops.isEmpty()) {
                RailwayProductFop invoicePaymentTypeFop = invoicePaymentTypeFops.iterator().next();
                invoicePaymentTypeFop.getAmount().setValue(MiscUtil.sum((BigDecimal[])new BigDecimal[]{invoicePaymentTypeFop.getAmount().getValue(), difference}));
                continue;
            }
            HashSet<PaymentType> nonTicketPaymentTypes = new HashSet<PaymentType>(Arrays.asList(PaymentType.values()));
            nonTicketPaymentTypes.remove(PaymentType.TICKET);
            Collection<RailwayProductFop> anyPaymentTypeFops = RailwayProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, nonTicketPaymentTypes, Collections.singleton(DictHelper.getLocalCurrency2()), null);
            if (!anyPaymentTypeFops.isEmpty()) {
                RailwayProductFop anyPaymentTypeFop = anyPaymentTypeFops.iterator().next();
                anyPaymentTypeFop.getAmount().setValue(MiscUtil.sum((BigDecimal[])new BigDecimal[]{anyPaymentTypeFop.getAmount().getValue(), difference}));
                continue;
            }
            RailwayProductFop cashPaymentTypeFop = RailwayCrimeaMcoHelper.createFop(PaymentType.CASH, difference);
            fops.add(cashPaymentTypeFop);
        }
    }

    public static void updateFeeFops(RailwayCrimeaMco product, ContractType contractType) {
        for (RailwayProductContractRelationData relation : RailwayCrimeaMcoHelper.getContractRelations(product)) {
            if (GeneralProductHelper.getContractType((EntityReference)relation.getDescription()) != contractType) continue;
            List fops = relation.getFops();
            Collection commissions = GeneralProductHelper.filterCommissions((Collection)relation.getCommissions(), (Set)GeneralProductHelper.feePropertyTypes, null, (Set)GeneralProductHelper.standardCommissionCategories);
            ArrayList<GeneralProductCommission> unusedCommissions = new ArrayList<GeneralProductCommission>();
            unusedCommissions.addAll(commissions);
            for (RailwayProductFop feeFop : RailwayProductHelper.filterFops(fops, GeneralProductHelper.feeFopTypes, null, null, null)) {
                ArrayList<GeneralProductCommission> feeCommissions = new ArrayList<GeneralProductCommission>();
                for (GeneralProductCommission fopCommission : feeFop.getCommissions()) {
                    if (!unusedCommissions.contains(fopCommission)) continue;
                    unusedCommissions.remove(fopCommission);
                    GeneralProductCommission feeCommission = (GeneralProductCommission)CollectionUtil.find((Iterable)commissions, (String)fopCommission.getUid());
                    if (feeCommission == null) continue;
                    feeCommissions.add(feeCommission);
                }
                if (feeCommissions.isEmpty()) {
                    fops.remove(feeFop);
                    continue;
                }
                feeFop.getCommissions().clear();
                feeFop.getCommissions().addAll(feeCommissions);
            }
            RailwayCrimeaMcoHelper.distributeCommissionsToFops(fops, unusedCommissions, GeneralProductHelper.serviceFeePropertyTypes, GeneralProductHelper.serviceFeeFopTypes);
            RailwayCrimeaMcoHelper.distributeCommissionsToFops(fops, unusedCommissions, GeneralProductHelper.paymentFeePropertyTypes, GeneralProductHelper.paymentFeeFopTypes);
            for (RailwayProductFop feeFop : RailwayProductHelper.filterFops(fops, GeneralProductHelper.feeFopTypes, null, null, null)) {
                BigDecimal commissionsEquivalentValue = GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)feeFop.getCommissions());
                Money money = new Money();
                money.setValue(commissionsEquivalentValue);
                money.setCurrency(DictHelper.getLocalCurrency2());
                feeFop.setAmount(money);
            }
        }
    }

    public static void updateDiscountFops(RailwayCrimeaMco product, ContractType contractType) {
        for (RailwayProductContractRelationData relation : RailwayCrimeaMcoHelper.getContractRelations(product)) {
            if (GeneralProductHelper.getContractType((EntityReference)relation.getDescription()) != contractType) continue;
            List fops = relation.getFops();
            Collection commissions = GeneralProductHelper.filterCommissions((Collection)relation.getCommissions(), (Set)GeneralProductHelper.discountPropertyTypes, null, null);
            ArrayList<GeneralProductCommission> unusedCommissions = new ArrayList<GeneralProductCommission>();
            unusedCommissions.addAll(commissions);
            for (RailwayProductFop discountFop : RailwayProductHelper.filterFops(fops, GeneralProductHelper.discountFopTypes, null, null, null)) {
                ArrayList<GeneralProductCommission> discountCommissions = new ArrayList<GeneralProductCommission>();
                for (GeneralProductCommission fopCommission : discountFop.getCommissions()) {
                    if (!unusedCommissions.contains(fopCommission)) continue;
                    unusedCommissions.remove(fopCommission);
                    GeneralProductCommission discountCommission = (GeneralProductCommission)CollectionUtil.find((Iterable)commissions, (String)fopCommission.getUid());
                    if (discountCommission == null) continue;
                    discountCommissions.add(discountCommission);
                }
                if (discountCommissions.isEmpty()) {
                    fops.remove(discountFop);
                    continue;
                }
                discountFop.getCommissions().clear();
                discountFop.getCommissions().addAll(discountCommissions);
            }
            RailwayCrimeaMcoHelper.distributeCommissionsToFops(fops, unusedCommissions, GeneralProductHelper.discountDiscountPropertyTypes, GeneralProductHelper.discountFopTypes);
            for (RailwayProductFop discountFop : RailwayProductHelper.filterFops(fops, GeneralProductHelper.discountFopTypes, null, null, null)) {
                BigDecimal commissionsEquivalentValue = GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)discountFop.getCommissions());
                commissionsEquivalentValue = MiscUtil.negate((BigDecimal)commissionsEquivalentValue);
                Money money = new Money();
                money.setValue(commissionsEquivalentValue);
                money.setCurrency(DictHelper.getLocalCurrency2());
                discountFop.setAmount(money);
            }
        }
    }

    private static void distributeCommissionsToFops(Collection<RailwayProductFop> fops, Collection<GeneralProductCommission> commissions, Set<Class<? extends BaseCommissionProperties>> commissionProperties, Set<FopType> fopTypes) {
        Collection filteredCommissions = GeneralProductHelper.filterCommissions(commissions, commissionProperties, null, null);
        if (filteredCommissions.isEmpty()) {
            return;
        }
        boolean done = RailwayCrimeaMcoHelper.distributeCommissionsToFops(fops, filteredCommissions, Collections.singleton(PaymentType.CASH), commissionProperties, fopTypes);
        if (!done) {
            done = RailwayCrimeaMcoHelper.distributeCommissionsToFops(fops, filteredCommissions, Collections.singleton(PaymentType.INVOICE), commissionProperties, fopTypes);
        }
        if (!done) {
            done = RailwayCrimeaMcoHelper.distributeCommissionsToFops(fops, filteredCommissions, null, commissionProperties, fopTypes);
        }
        if (!done) {
            RailwayProductFop cashPaymentTypeFop = RailwayCrimeaMcoHelper.createFop(PaymentType.CASH, BigDecimal.ZERO);
            cashPaymentTypeFop.getCommissions().addAll(filteredCommissions);
            fops.add(cashPaymentTypeFop);
        }
    }

    private static boolean distributeCommissionsToFops(Collection<RailwayProductFop> fops, Collection<GeneralProductCommission> commissions, Set<PaymentType> paymentTypes, Set<Class<? extends BaseCommissionProperties>> commissionProperties, Set<FopType> fopTypes) {
        Collection<RailwayProductFop> filteredFops = RailwayProductHelper.filterFops(fops, fopTypes, paymentTypes, Collections.singleton(DictHelper.getLocalCurrency2()), null);
        if (filteredFops.size() > 0) {
            RailwayProductFop filteredFop = filteredFops.iterator().next();
            filteredFop.getCommissions().addAll(commissions);
            return true;
        }
        return false;
    }

    private static RailwayProductFop createFop(PaymentType paymentType, BigDecimal amount) {
        RailwayProductFop fop = new RailwayProductFop();
        fop.setType(paymentType);
        Money money = new Money();
        money.setValue(amount);
        money.setCurrency(DictHelper.getLocalCurrency2());
        fop.setAmount(money);
        return fop;
    }

    public static SalesChain getSalesChain(RailwayCrimeaMco product) {
        SalesChain salesChain = product.getSalesChain();
        salesChain = salesChain != null ? salesChain : new SalesChain();
        product.setSalesChain(salesChain);
        if (salesChain.getDescription() == null) {
            salesChain.setDescription(GeneralProductHelper.getPredefinedDescription((PredefinedSalesChainType)PredefinedSalesChainType.OWN, null));
        }
        return salesChain;
    }

    public static RailwayProductContractRelationData getClientContractRelation(RailwayCrimeaMco product) {
        for (RailwayProductContractRelationData relation : RailwayCrimeaMcoHelper.getContractRelations(product)) {
            if (GeneralProductHelper.getContractType((EntityReference)relation.getDescription()) != ContractType.CLIENT) continue;
            return relation;
        }
        throw new IllegalStateException("client contract relation is absent in product");
    }

    public static List<RailwayProductContractRelationData> getContractRelations(RailwayCrimeaMco product) {
        List originalRelations = (List)product.getValue("contractRelations");
        SalesChain salesChain = RailwayCrimeaMcoHelper.getSalesChain(product);
        ArrayList<RailwayProductContractRelationData> subresult = new ArrayList<RailwayProductContractRelationData>();
        ArrayList toDelete = new ArrayList(originalRelations);
        boolean modified = false;
        for (EntityReference item : ((SalesChainDescription)EntityStorage.get().resolve(salesChain.getDescription()).getEntity()).getContractRelations()) {
            RailwayProductContractRelationData relation = RailwayProductHelper.findContractRelation((List<RailwayProductContractRelationData>)originalRelations, (EntityReference<ContractRelationDescription>)item);
            if (relation != null) {
                subresult.add(relation);
                toDelete.remove(relation);
                continue;
            }
            PredefinedContractRelationType predefinedType = ((ContractRelationDescription)EntityStorage.get().resolve(item).getEntity()).getPredefinedType();
            if ((predefinedType == PredefinedContractRelationType.AGENCY_TO_CLIENT || predefinedType == PredefinedContractRelationType.SUBAGENCY_TO_CLIENT) && (relation = RailwayProductHelper.findContractRelation((List<RailwayProductContractRelationData>)originalRelations, ContractType.CLIENT)) != null) {
                relation.setDescription(item);
                subresult.add(relation);
                toDelete.remove(relation);
                continue;
            }
            relation = new RailwayProductContractRelationData();
            relation.setDescription(item);
            subresult.add(relation);
            modified = true;
        }
        if (modified || !toDelete.isEmpty()) {
            originalRelations.clear();
            originalRelations.addAll(subresult);
        }
        return originalRelations;
    }

    public static List<GeneralProductCommission> getUnmodifiableCommissions(RailwayCrimeaMco product, ContractType contractType) {
        ArrayList<GeneralProductCommission> filteredCommissions = new ArrayList<GeneralProductCommission>();
        for (RailwayProductContractRelationData relation : RailwayCrimeaMcoHelper.getContractRelations(product)) {
            if (contractType != null && GeneralProductHelper.getContractType((EntityReference)relation.getDescription()) != contractType) continue;
            filteredCommissions.addAll(relation.getCommissions());
        }
        return filteredCommissions;
    }

    public static RailwayProductContractRelationData getVendorContractRelation(RailwayCrimeaMco product) {
        for (RailwayProductContractRelationData relation : RailwayCrimeaMcoHelper.getContractRelations(product)) {
            if (GeneralProductHelper.getContractType((EntityReference)relation.getDescription()) != ContractType.VENDOR) continue;
            return relation;
        }
        throw new IllegalStateException("vendor contract relation is absent in product");
    }

    public static List<RailwayProductFop> getVendorFops(RailwayCrimeaMco product) {
        return RailwayCrimeaMcoHelper.getVendorContractRelation(product).getFops();
    }

    public static List<RailwayProductFop> getSubagentFops(RailwayCrimeaMco product, boolean autoUpdateSalesChain) {
        RailwayProductContractRelationData relation = RailwayCrimeaMcoHelper.getSubagentContractRelation(product, autoUpdateSalesChain);
        return relation == null ? Collections.emptyList() : relation.getFops();
    }

    public static List<RailwayProductFop> getClientFops(RailwayCrimeaMco product) {
        return RailwayCrimeaMcoHelper.getClientContractRelation(product).getFops();
    }

    public static RailwayProductContractRelationData getSubagentContractRelation(RailwayCrimeaMco product, boolean autoUpdateSalesChain) {
        for (RailwayProductContractRelationData relation : RailwayCrimeaMcoHelper.getContractRelations(product)) {
            if (GeneralProductHelper.getContractType((EntityReference)relation.getDescription()) != ContractType.SUBAGENCY) continue;
            return relation;
        }
        SalesChain salesChain = RailwayCrimeaMcoHelper.getSalesChain(product);
        if (GeneralProductHelper.isOwnPredefinedSalesChainType((PredefinedSalesChainType)((SalesChainDescription)EntityStorage.get().resolve(salesChain.getDescription()).getEntity()).getPredefinedType())) {
            if (!autoUpdateSalesChain) {
                return null;
            }
            salesChain.setDescription(GeneralProductHelper.getPredefinedDescription((PredefinedSalesChainType)PredefinedSalesChainType.SUBAGENT, (EntityReference)salesChain.getDescription()));
            Contractor contractor = new Contractor();
            contractor.setDescription(GeneralProductHelper.findPredefinedContractorDescription((PredefinedContractorType)PredefinedContractorType.SUBAGENCY));
            contractor.setContractor(GeneralProductHelper.getContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.AGENCY));
            List lst = salesChain.getContractors();
            lst.add(lst.size() - 1, contractor);
            for (RailwayProductContractRelationData relation : RailwayCrimeaMcoHelper.getContractRelations(product)) {
                if (GeneralProductHelper.getContractType((EntityReference)relation.getDescription()) != ContractType.SUBAGENCY) continue;
                return relation;
            }
        }
        throw new IllegalStateException("subagent contract relation is absent in product");
    }

    public static EntityReference<Organization> getSupplier(RailwayCrimeaMco product) {
        return GeneralProductHelper.getContractor((SalesChain)RailwayCrimeaMcoHelper.getSalesChain(product), (PredefinedContractorType)PredefinedContractorType.SUPPLIER);
    }

    public static void setSupplier(RailwayCrimeaMco product, EntityReference<Organization> value) {
        GeneralProductHelper.setContractor((SalesChain)RailwayCrimeaMcoHelper.getSalesChain(product), (PredefinedContractorType)PredefinedContractorType.SUPPLIER, value);
    }

    public static EntityReference<Organization> getAgency(RailwayCrimeaMco product) {
        return GeneralProductHelper.getContractor((SalesChain)RailwayCrimeaMcoHelper.getSalesChain(product), (PredefinedContractorType)PredefinedContractorType.AGENCY);
    }

    public static void setAgency(RailwayCrimeaMco product, EntityReference<Organization> value) {
        GeneralProductHelper.setContractor((SalesChain)RailwayCrimeaMcoHelper.getSalesChain(product), (PredefinedContractorType)PredefinedContractorType.AGENCY, value);
    }

    public static EntityReference<Organization> getSubagency(RailwayCrimeaMco product) {
        return GeneralProductHelper.getContractor((SalesChain)RailwayCrimeaMcoHelper.getSalesChain(product), (PredefinedContractorType)PredefinedContractorType.SUBAGENCY);
    }

    public static boolean isFareFopsRelevant(RailwayCrimeaMco product) {
        return GeneralProductHelper.getHandler((BaseProduct)product).isFareFopsRelevant((BaseProduct)product);
    }

    public static void setSubagency(RailwayCrimeaMco product, EntityReference<Organization> value) {
        GeneralProductHelper.setContractor((SalesChain)RailwayCrimeaMcoHelper.getSalesChain(product), (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, value);
    }

    public static boolean removeProduct(RailwayCrimeaMco product) {
        if (product.getNextProduct() != null) {
            return false;
        }
        product.getReservation().getProducts().remove(product);
        if (product.getPreviousProduct() != null) {
            product.getPreviousProduct().setNextProduct(null);
        }
        for (BaseProduct connectedProduct : BookingHelper.getConnectedProducts((BaseProduct)product)) {
            ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)connectedProduct);
            if (handler == null) continue;
            handler.removeRelatedProduct(connectedProduct, (BaseProduct)product);
            if (!(connectedProduct instanceof ProductVoiding)) continue;
            handler.removeProduct(connectedProduct);
        }
        return true;
    }

    public static boolean removeRelatedProduct(RailwayCrimeaMco product, BaseProduct relatedProduct) {
        product.getRelatedProducts().remove(relatedProduct);
        return true;
    }

    public static Date getFirstDepartureDate(RailwayCrimeaMco product) {
        if (product.getSegments().isEmpty()) {
            return null;
        }
        return ((RailwaySegment)product.getSegments().get(0)).getDepartureDate();
    }

    public static String getCities(RailwayCrimeaMco product, Locale locale) {
        return RailwayProductHelper.getCities(product.getSegments(), locale);
    }

    public static String getCountries(RailwayCrimeaMco product, Locale locale) {
        return RailwayProductHelper.getCountries(product.getSegments(), locale);
    }
}

