/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.railway.reports.render.salesreports.spgd;

import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.railway.parsers.TransactionType;
import com.gridnine.xtrip.common.railway.reports.render.salesreports.spgd.SPGDDivergenceReportTicket;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.ExcelColumn;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class SPGDDivergencePoiWorksheetHandler
extends BasePoiWorksheetHandler<SPGDDivergenceReportTicket> {
    private static final int START_ROW_INDEX = 8;
    private static final int ROW_SHIFT_AMOUNT = 7;
    private static final int COLUMN_AMOUNT = 13;
    private HSSFSheet currentSheet;
    private int currentRow;

    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<SPGDDivergenceReportTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, data, globalData);
        this.currentSheet = sheet;
        this.currentSheet.setForceFormulaRecalculation(true);
        this.currentRow = 8;
        List tickets = data.getTickets();
        if (!tickets.isEmpty()) {
            for (int n = 0; n < tickets.size(); ++n) {
                SPGDDivergenceReportTicket ticket = (SPGDDivergenceReportTicket)tickets.get(n);
                this.addRow(ticket, n != 0);
            }
        }
    }

    private void addRow(SPGDDivergenceReportTicket ticket, boolean insertRow) throws Exception {
        if (insertRow) {
            ExcelUtils.insertRow((HSSFSheet)this.currentSheet, (int)(this.currentRow - 1), (int)13, (int)7);
        }
        for (Column column : Column.values()) {
            this.setFieldValue(ticket, column);
        }
        ++this.currentRow;
    }

    private void setFieldValue(SPGDDivergenceReportTicket ticket, Column column) throws Exception {
        switch (column) {
            case DATA_CODE: {
                String dataCode = ticket.getDataCode();
                if (dataCode == null) break;
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)dataCode);
                break;
            }
            case BLANK_TYPE: {
                break;
            }
            case SYSTEM_NUMBER: {
                String systemNumber = ticket.getSystemNumber();
                if (systemNumber == null) break;
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)systemNumber);
                break;
            }
            case SEGMENT_NUMBER: {
                Integer segmentNumber = ticket.getSegmentNumber();
                if (segmentNumber == null) break;
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)segmentNumber.toString());
                break;
            }
            case TRANSACTION_TYPE: {
                TransactionType transactionType = ticket.getTransactionType();
                if (transactionType == null) break;
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)transactionType.toString());
                break;
            }
            case AVS_PERIOD_DATE: {
                Date avsPeriodEnd = ticket.getAVSPeriodEnd();
                if (avsPeriodEnd == null) break;
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)avsPeriodEnd.toString());
                break;
            }
            case PAYMENT_TYPE: {
                PaymentType paymentType = ticket.getPaymentType();
                if (paymentType == null) break;
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)paymentType.toString());
                break;
            }
            case VALIDATING_CARRIER: {
                String validatingCarrier = ticket.getValidatingCarrier();
                if (validatingCarrier == null) break;
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)validatingCarrier);
                break;
            }
            case SEGMENT_CARRIER: {
                String segmentCarrier = ticket.getSegmentCarrier();
                if (segmentCarrier == null) break;
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)segmentCarrier);
                break;
            }
            case EQUIVALENT_FARE: {
                BigDecimal equivalentFare = ticket.getEquivalentFare();
                if (equivalentFare == null) break;
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)equivalentFare);
                break;
            }
            case PENALTY: {
                BigDecimal penalty = ticket.getPenalty();
                if (penalty == null) break;
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)penalty);
                break;
            }
            case TAX_AGS: {
                BigDecimal taxAgs = ticket.getTaxAgs();
                if (taxAgs == null) break;
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)taxAgs);
                break;
            }
            case TAX_TCH: {
                BigDecimal taxTch = ticket.getTaxTch();
                if (taxTch == null) break;
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)taxTch);
                break;
            }
        }
    }

    private static enum Column {
        DATA_CODE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.A;
            }
        }
        ,
        BLANK_TYPE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.B;
            }
        }
        ,
        SYSTEM_NUMBER{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.C;
            }
        }
        ,
        SEGMENT_NUMBER{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.D;
            }
        }
        ,
        TRANSACTION_TYPE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.E;
            }
        }
        ,
        AVS_PERIOD_DATE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.F;
            }
        }
        ,
        PAYMENT_TYPE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.G;
            }
        }
        ,
        VALIDATING_CARRIER{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.H;
            }
        }
        ,
        SEGMENT_CARRIER{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.I;
            }
        }
        ,
        EQUIVALENT_FARE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.J;
            }
        }
        ,
        PENALTY{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.K;
            }
        }
        ,
        TAX_AGS{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.L;
            }
        }
        ,
        TAX_TCH{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.M;
            }
        };


        public abstract ExcelColumn getExcelColumn();
    }
}

