/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.res.FxRes;
import com.gridnine.xtrip.client.fx.core.service.WindowTitleService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.stage.Stage;

class TtitleServiceImpl
implements WindowTitleService {
    private final Stage stage;
    private String workspaceName;
    private String user;
    private Date startDate;
    private ScheduledFuture<?> scheduledFuture;

    TtitleServiceImpl(Stage stg) {
        this.stage = stg;
        this.updateTitle();
    }

    public void dispose() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
    }

    @Override
    public void setWorkspaceName(String value) {
        this.workspaceName = value;
        if (this.scheduledFuture == null) {
            this.updateTitle();
        }
    }

    @Override
    public void setUser(String value) {
        this.user = value;
        if (this.scheduledFuture == null) {
            this.updateTitle();
        }
    }

    @Override
    public void setStartDate(Date value) {
        this.startDate = value;
        if (value != null) {
            if (this.scheduledFuture == null) {
                this.scheduledFuture = Notifications.get().getScheduler().scheduleAtFixedRate(this::updateTitle, 0L, 998L, TimeUnit.MILLISECONDS);
            }
        } else {
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(true);
                this.scheduledFuture = null;
            }
            this.updateTitle();
        }
    }

    private void updateTitle() {
        StringBuilder buf = new StringBuilder();
        buf.append(TextUtil.isBlank((String)this.workspaceName) ? FxRes.getTheme().getTitle() : this.workspaceName);
        if (!TextUtil.isBlank((String)this.user)) {
            buf.append(" \u2014 ").append(this.user);
        }
        if (this.startDate != null) {
            long timeSinceStart = (System.currentTimeMillis() - this.startDate.getTime()) / 1000L;
            buf.append(" \u2014 ").append(Messages.General_Worklog_is_open).append(String.format(" %02d:%02d:%02d", timeSinceStart / 3600L, timeSinceStart % 3600L / 60L, timeSinceStart % 60L));
        }
        FxUtil.submitToFxThread(() -> this.stage.setTitle(buf.toString()));
    }
}

