/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.acl;

import com.gridnine.xtrip.client.fx.core.acl.AclCheckEntry;
import com.gridnine.xtrip.client.fx.core.acl.AclService;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.meta.ui.BaseUiContainer;
import com.gridnine.xtrip.common.meta.ui.UiMetaRegistry;
import com.gridnine.xtrip.common.meta.ui.UiTilesSpace;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionGroupResources;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public final class FxAclUtil {
    private static final ConcurrentMap<AclQuery, Boolean> CACHE = new ConcurrentHashMap<AclQuery, Boolean>();

    public static String getUiAclResource(String nodeClassName) {
        UiMetaRegistry registry = UiMetaRegistry.get();
        UiTilesSpace space = (UiTilesSpace)registry.getSpaces().get(nodeClassName);
        if (space != null) {
            if (space.getAcl() != null) {
                return space.getAcl().getId();
            }
        } else {
            BaseUiContainer ctr = (BaseUiContainer)registry.getContainers().get(nodeClassName);
            if (ctr != null && ctr.getAcl() != null) {
                return ctr.getAcl().getId();
            }
        }
        return StandardRestrictionGroupResources.GROUP_UI.getId();
    }

    public static Set<String> applyACL(Map<String, AclQuery> queries) throws Exception {
        if (queries.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        HashMap<String, AclQuery> forInvocation = new HashMap<String, AclQuery>();
        for (Map.Entry<String, AclQuery> entry : queries.entrySet()) {
            Boolean granted = (Boolean)CACHE.get(entry.getValue());
            if (granted != null) {
                if (!granted.booleanValue()) continue;
                result.add(entry.getKey());
                continue;
            }
            forInvocation.put(entry.getKey(), entry.getValue());
        }
        if (forInvocation.isEmpty()) {
            return result;
        }
        result.addAll(AclService.get().applyAcl(forInvocation));
        for (Map.Entry<String, Object> entry : forInvocation.entrySet()) {
            if (((AclQuery)entry.getValue()).getEntries().stream().anyMatch(item -> item.getReference() != null)) continue;
            CACHE.put((AclQuery)entry.getValue(), result.contains(entry.getKey()));
        }
        return result;
    }

    public static Map<String, Boolean> applyACL(Class<? extends BaseEntity> entityClass, String entityUid, Integer versionNumber) throws Exception {
        return AclService.get().applyAcl(entityClass, entityUid, versionNumber);
    }

    public static List<AclCheckEntry> asCheckEntries(Map<String, AclQuery> queries, Set<String> results) {
        return queries.entrySet().stream().map(entry -> new AclCheckEntry((String)entry.getKey(), (AclQuery)entry.getValue(), results.contains(entry.getKey()))).sorted((lhs, rhs) -> lhs.getKey().compareTo(rhs.getKey())).collect(Collectors.toList());
    }

    private FxAclUtil() {
    }
}

