/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.activity;

import com.gridnine.xtrip.client.fx.core.activity.ActivitiesView;
import com.gridnine.xtrip.client.fx.core.activity.ActivityHandler;
import com.gridnine.xtrip.client.fx.core.activity.ActivityState;
import com.gridnine.xtrip.client.fx.core.activity.NavToolable;
import com.gridnine.xtrip.client.fx.core.activity.NavigationParameters;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavTool;
import com.gridnine.xtrip.client.fx.core.ui.navigation.WorkspaceModificationEvent;
import com.gridnine.xtrip.client.fx.core.ui.tab.TabContentWrapper;
import com.gridnine.xtrip.client.fx.core.ui.tab.TabPaneTab;
import com.gridnine.xtrip.client.fx.core.util.ActivityTracker;
import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.HasPersistableState;
import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.assets.ActivityItem;
import com.gridnine.xtrip.common.fx.assets.FxWorkspace;
import com.gridnine.xtrip.common.fx.assets.FxWorkspaceItem;
import com.gridnine.xtrip.common.fx.rpc.service.AssetService;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.util.Pair;

public class ActivityManager {
    static final String ACTIVITY_STATE_KEY = "activityState";
    private static final String ACTIVITY_CALLBACK_KEY = "activityCallback";
    private static final String VIEW_STATE_KEY = "viewState";
    final ActivitiesView activitiesView;
    private final Consumer<WorkspaceModificationEvent> workspaceModificationListener = event -> {
        FxWorkspace workspace = event.getWorkspace();
        FxUtil.submitToFxThread(() -> this.update(workspace));
    };
    private final MemoryMonitor memoryMonitor;

    public static ActivityManager get() {
        if (!Environment.isTest()) {
            return Holder.INSTANCE;
        }
        return (ActivityManager)Environment.getPublished(ActivityManager.class);
    }

    private static void deletePersistedViewState(ActivityState<?, ?> state) {
        File file = new File(Environment.getDataFolder(), "view-states/" + state.getToken());
        if (file.isFile()) {
            file.delete();
        }
    }

    static void persistViewState(TabPaneTab tab, ActivityState<?, ?> state, boolean force) {
        Object view = state.getView();
        if (!(view instanceof HasPersistableState)) {
            return;
        }
        if (!state.isStateful()) {
            if (force) {
                tab.getProperties().put((Object)VIEW_STATE_KEY, (Object)((HasPersistableState)view).persistState());
            }
            return;
        }
        Serializable viewStateData = ((HasPersistableState)view).persistState();
        File folder = new File(Environment.getDataFolder(), "view-states");
        folder.mkdirs();
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(new File(folder, state.getToken())));){
            out.writeObject(viewStateData);
        }
        catch (IOException e) {
            ErrorHandler.handle(e);
        }
    }

    private static void restoreViewState(TabPaneTab tab, ActivityState<?, ?> state) {
        File file;
        Object view = state.getView();
        if (!(view instanceof HasPersistableState)) {
            return;
        }
        Serializable viewStateData = (Serializable)tab.getProperties().remove((Object)VIEW_STATE_KEY);
        if (viewStateData == null && (file = new File(Environment.getDataFolder(), "view-states/" + state.getToken())).isFile()) {
            try (ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));){
                viewStateData = (Serializable)in.readObject();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (viewStateData != null) {
            ((HasPersistableState)view).restoreState(viewStateData);
        }
    }

    public ActivityManager(ActivitiesView view) {
        this.activitiesView = view;
        this.memoryMonitor = new MemoryMonitor();
        FxUtil.runInFxThread(this::init);
    }

    private void update(FxWorkspace workspace) {
        List entries = CollectionUtil.flatTreeStream((Collection)workspace.getItems(), FxWorkspaceItem::getSubItems).map(item -> new Pair(item, this.activitiesView.getTabs().stream().filter(value -> item.getUid().equals(((ActivityState)value.getProperties().get((Object)ACTIVITY_STATE_KEY)).getToken())).findFirst().orElse(null))).filter(item -> item.getValue() != null).collect(Collectors.toList());
        for (Pair entry : entries) {
            ActivityState state;
            ActivityHandler handler;
            FxWorkspaceItem item2 = (FxWorkspaceItem)entry.getKey();
            TabPaneTab tab = (TabPaneTab)entry.getValue();
            NavTool<?> tool = NavTool.forId(item2.getToolId());
            if (tool == null) continue;
            XSerializable data = null;
            if (item2.getParameters() != null) {
                try {
                    data = (XSerializable)tool.cleanParameters(tool.getSerializer().deserialize(item2.getParameters()));
                }
                catch (Exception e) {
                    ErrorHandler.handle(e);
                }
            }
            if (!((handler = (state = (ActivityState)tab.getProperties().get((Object)ACTIVITY_STATE_KEY)).getHandler()) instanceof NavToolable)) continue;
            NavToolable navToolable = (NavToolable)((Object)handler);
            if (navToolable.isSupported(tool)) {
                NavigationParameters<XSerializable> navigationParameters = new NavigationParameters<XSerializable>();
                navigationParameters.setTitle(item2.getName());
                navigationParameters.setDescription(item2.getName());
                navigationParameters.setParameters(data);
                navToolable.update(state, navigationParameters);
                continue;
            }
            tab.close();
            tool.execute(item2.getUid(), item2.getName(), item2.getName(), data, true, false, true);
        }
    }

    private void init() {
        this.activitiesView.getSelectionModel().selectedItemProperty().addListener((s, o, n) -> {
            ActivityState state = n == null ? null : (ActivityState)n.getProperties().get((Object)ACTIVITY_STATE_KEY);
            ClientSettings.get().setSelectedActivity(state == null || !state.isStateful() ? null : state.getToken());
            ClientSettings.get().save();
        });
        EventBus.get().subscribe(WorkspaceModificationEvent.TYPE, this.workspaceModificationListener);
    }

    public void loadState() throws Exception {
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        AssetService assetService = (AssetService)RpcServiceManager.get().getService(AssetService.class);
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ActivityItem.Property.owner.name(), (Object)sic.getUser()));
        query.getCriteria().getOrders().put(ActivityItem.Property.created.name(), SortOrder.ASC);
        List assets = assetService.search(sic, ActivityItem.class, query).getData();
        ArrayList states = new ArrayList(assets.size());
        for (ActivityItem asset : assets) {
            try {
                ActivityHandler<?, ?> handler = ActivityHandler.forId(asset.getHandlerId());
                if (handler == null) {
                    try {
                        assetService.delete(sic, (BaseAsset)asset);
                    }
                    catch (Exception e) {
                        ErrorHandler.handle(e);
                    }
                    continue;
                }
                states.add(new ActivityState(handler, asset));
            }
            catch (Exception e) {
                ErrorHandler.handle(e);
                try {
                    assetService.delete(sic, (BaseAsset)asset);
                }
                catch (Exception e2) {
                    ErrorHandler.handle(e2);
                }
            }
        }
        FxUtil.runInFxThread(() -> {
            ArrayList<TabPaneTab> tabs = new ArrayList<TabPaneTab>(states.size());
            for (ActivityState state : states) {
                tabs.add(this.createTab(state, null));
            }
            this.activitiesView.getTabs().setAll(tabs);
        });
    }

    public void unloadTabs() {
        this.memoryMonitor.unloadTabsContent();
    }

    public <V extends Node, P> void navigate(String token, ActivityHandler<V, P> handler, NavigationParameters<P> parameters) {
        this.navigate(token, handler, parameters, true, null, false);
    }

    public <V extends Node, P> void navigate(String token, ActivityHandler<V, P> handler, NavigationParameters<P> parameters, boolean stateful) {
        this.navigate(token, handler, parameters, stateful, null, false);
    }

    public <V extends Node, P> void navigate(String token, ActivityHandler<V, P> handler, NavigationParameters<P> parameters, Consumer<V> callback) {
        this.navigate(token, handler, parameters, true, callback, false);
    }

    public <V extends Node, P> void navigate(String token, ActivityHandler<V, P> handler, NavigationParameters<P> parameters, boolean stateful, Consumer<V> callback, boolean background) {
        ActivityState state = new ActivityState(token, parameters.getTitle(), parameters.getDescription(), handler, parameters.getParameters(), stateful);
        FxUtil.runInFxThread(() -> this.addInternal(state, callback, background));
    }

    public ActivityState<?, ?> findState(String token) {
        TabPaneTab tab = this.findActivityTab(token);
        if (tab == null) {
            return null;
        }
        return (ActivityState)tab.getProperties().get((Object)ACTIVITY_STATE_KEY);
    }

    public void find(String token, boolean activate, Consumer<Node> callback) {
        TabPaneTab tab = this.findActivityTab(token);
        if (tab == null) {
            return;
        }
        if (tab.getContent() != null) {
            if (callback != null) {
                callback.accept(((TabContentWrapper)tab.getContent()).getContent());
            }
            return;
        }
        if (!activate) {
            return;
        }
        if (callback != null) {
            tab.getProperties().put((Object)ACTIVITY_CALLBACK_KEY, callback);
        }
        this.activitiesView.getSelectionModel().select((Object)tab);
    }

    private <V extends Node, P> void addInternal(ActivityState<V, P> state, Consumer<V> callback, boolean background) {
        TabPaneTab existingTab = this.findActivityTab(state.getToken());
        if (existingTab != null) {
            if (existingTab.getContent() == null && callback != null) {
                existingTab.getProperties().put((Object)ACTIVITY_CALLBACK_KEY, callback);
            }
            this.activitiesView.getSelectionModel().select((Object)existingTab);
            if (existingTab.getContent() != null && callback != null) {
                callback.accept(((TabContentWrapper)existingTab.getContent()).getContent());
            }
            return;
        }
        TabPaneTab tab = this.createTab(state, callback);
        this.activitiesView.getTabs().add((Object)tab);
        if (!background) {
            this.activitiesView.getSelectionModel().select((Object)tab);
        }
    }

    private <V extends Node, P> TabPaneTab createTab(ActivityState<V, P> state, Consumer<V> callback) {
        TabPaneTab result = new TabPaneTab();
        this.updateTab(result, state);
        ChangeListener stateListener = (obj, oldValue, newValue) -> FxUtil.runInFxThread(() -> this.updateTab(result, state));
        state.titleProperty().addListener(stateListener);
        state.descriptionProperty().addListener(stateListener);
        result.getProperties().put((Object)ACTIVITY_STATE_KEY, state);
        if (callback != null) {
            result.getProperties().put((Object)ACTIVITY_CALLBACK_KEY, callback);
        }
        result.selectedProperty().addListener((obj, oldValue, newValue) -> {
            if (!newValue.booleanValue() || result.getContent() != null) {
                return;
            }
            ActivityTracker.addItem("activityContentCreated", state.toString());
            Notifications.get().submitTask(() -> {
                this.memoryMonitor.checkAvailableMemory();
                Object view = state.getHandler().getOrCreateView(state);
                FxUtil.submitToFxThread(() -> {
                    result.setContent((Node)new TabContentWrapper((Node)view));
                    ActivityManager.restoreViewState(result, state);
                    Consumer tabCallback = (Consumer)result.getProperties().remove((Object)ACTIVITY_CALLBACK_KEY);
                    if (tabCallback != null) {
                        FxUtil.submitToFxThread(() -> tabCallback.accept(view));
                    }
                });
            }, state.getMutex());
        });
        ChangeListener acquiredListener = (src, oldValue, newValue) -> {
            result.setProgress(newValue != false ? -1.0 : 100.0);
            result.setBusy((boolean)newValue);
            this.updateTab(result, state);
        };
        state.getMutex().acquiredProperty().addListener(acquiredListener);
        Runnable closingProcedure = () -> {
            state.titleProperty().removeListener(stateListener);
            state.descriptionProperty().removeListener(stateListener);
            state.getMutex().acquiredProperty().removeListener(acquiredListener);
            Object view = state.getView();
            ActivityManager.deletePersistedViewState(state);
            if (view instanceof Disposable) {
                ((Disposable)view).dispose();
            }
            this.activitiesView.getTabs().remove((Object)result);
            state.delete(() -> {
                if (state.getView() != null) {
                    state.getHandler().onClosed(state);
                }
            });
            ActivityTracker.addItem("activityClosed", state.toString());
        };
        result.setOnCloseRequest((EventHandler<Event>)((EventHandler)evt -> {
            evt.consume();
            if (state.getHandler().isSaveRequired(state)) {
                new Dialog().setTitle(Messages.General_Accepting_required).setMessage(Messages.General_Is_saving_required).setSupplmentalMessage((String)state.titleProperty().get()).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.AUXILARY, Messages.General_Dont_save, () -> state.getHandler().handleClosing(state, closingProcedure)).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.General_Save, () -> {
                    if (!state.getHandler().validate(state)) {
                        return;
                    }
                    Notifications.get().submitTask(() -> {
                        state.getHandler().saveChanges(state);
                        FxUtil.submitToFxThread(() -> state.getHandler().handleClosing(state, closingProcedure));
                    }, state.getMutex());
                }).showGlobal();
            } else {
                state.getHandler().handleClosing(state, closingProcedure);
            }
        }));
        result.setOnClosed((EventHandler<Event>)((EventHandler)evt -> state.getHandler().handleClosing(state, closingProcedure)));
        return result;
    }

    private <V extends Node, P> void updateTab(TabPaneTab tab, ActivityState<V, P> state) {
        tab.setHighlighted(state.getHandler().isHighlighted(state));
        String title = (String)state.titleProperty().get();
        String description = (String)state.descriptionProperty().get();
        if (!TextUtil.isBlank((String)title)) {
            tab.setText(title);
            tab.setTooltip(new Tooltip(TextUtil.isBlank((String)description) ? title : description));
        } else {
            tab.setText(Messages.General_Without_name);
            tab.setTooltip(TextUtil.isBlank((String)description) ? null : new Tooltip(description));
        }
    }

    public void remove(String token, boolean force) {
        FxUtil.runInFxThread(() -> {
            TabPaneTab tab = this.findActivityTab(token);
            if (tab == null) {
                return;
            }
            ActivityState state = (ActivityState)tab.getProperties().get((Object)ACTIVITY_STATE_KEY);
            if (!force && state.getHandler().isSaveRequired(state)) {
                return;
            }
            state.titleProperty().unbind();
            state.descriptionProperty().unbind();
            Object view = state.getView();
            ActivityManager.deletePersistedViewState(state);
            if (view instanceof Disposable) {
                ((Disposable)view).dispose();
            }
            this.activitiesView.getTabs().remove((Object)tab);
            state.delete(() -> {
                if (state.getView() != null) {
                    state.getHandler().onClosed(state);
                }
            });
        });
    }

    private TabPaneTab findActivityTab(String token) {
        if (token == null) {
            return null;
        }
        for (TabPaneTab tab : this.activitiesView.getTabs()) {
            ActivityState state = (ActivityState)tab.getProperties().get((Object)ACTIVITY_STATE_KEY);
            if (state == null || !token.equals(state.getToken())) continue;
            return tab;
        }
        return null;
    }

    public List<String> getSelectionHistory() {
        return this.activitiesView.getSelectionHistory().stream().map(item -> ((ActivityState)item.getProperties().get((Object)ACTIVITY_STATE_KEY)).getToken()).collect(Collectors.toList());
    }

    private class MemoryMonitor {
        private boolean checkInProgress;

        MemoryMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkAvailableMemory() {
            if (this.checkInProgress) {
                return;
            }
            this.checkInProgress = true;
            try {
                Runtime rt = Runtime.getRuntime();
                long allocatedMemory = rt.totalMemory() - rt.freeMemory();
                long presumableFreeMemory = rt.maxMemory() - allocatedMemory;
                long threshold = 0x6400000L;
                if (presumableFreeMemory > threshold) {
                    return;
                }
                try {
                    FxUtil.waitForFxThread(this::unloadTabsContent);
                }
                catch (Exception e) {
                    ErrorHandler.handle(e);
                }
                rt.gc();
            }
            finally {
                this.checkInProgress = false;
            }
        }

        void unloadTabsContent() {
            ActivityState state;
            ArrayList<TabPaneTab> toBeUnloaded = new ArrayList<TabPaneTab>();
            TabPaneTab selectedTab = (TabPaneTab)ActivityManager.this.activitiesView.getSelectionModel().getSelectedItem();
            for (TabPaneTab tab : ActivityManager.this.activitiesView.getSelectionHistory()) {
                if (tab == selectedTab || tab.getContent() == null || (state = (ActivityState)tab.getProperties().get((Object)ActivityManager.ACTIVITY_STATE_KEY)) == null || !state.isStateful() || state.getHandler().isSaveRequired(state)) continue;
                toBeUnloaded.add(tab);
            }
            if (toBeUnloaded.isEmpty()) {
                return;
            }
            Notifications.get().showFlashNotification(Messages.General_Memory_optimization, null);
            for (TabPaneTab tab : toBeUnloaded) {
                tab.setContent(null);
                tab.getProperties().remove((Object)ActivityManager.ACTIVITY_CALLBACK_KEY);
                state = (ActivityState)tab.getProperties().get((Object)ActivityManager.ACTIVITY_STATE_KEY);
                Object view = state.getView();
                ActivityManager.persistViewState(tab, state, true);
                if (view instanceof Disposable) {
                    ((Disposable)view).dispose();
                }
                state.setView(null);
                state.titleProperty().unbind();
                state.descriptionProperty().unbind();
            }
        }
    }

    private static class Holder {
        public static final ActivityManager INSTANCE = (ActivityManager)Environment.getPublished(ActivityManager.class);

        private Holder() {
        }
    }
}

