/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.activity;

import com.gridnine.xtrip.client.fx.core.activity.ActivitiesView;
import com.gridnine.xtrip.client.fx.core.activity.ActivityManager;
import com.gridnine.xtrip.client.fx.core.activity.ActivityState;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.registry.basic.AppStopHook;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.ui.tab.TabPaneTab;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public class ActivityManagerAppStopHook
implements AppStopHook {
    private final ActivitiesView activitiesView;

    public ActivityManagerAppStopHook(ActivityManager activityManager) {
        this.activitiesView = activityManager.activitiesView;
    }

    @Override
    public String getId() {
        return "activity-manager-stop-hook";
    }

    @Override
    public double getWeight() {
        return 10.0;
    }

    @Override
    public void shutdownRequested(AppStopHook.ShutdownCallback callback) {
        ArrayList<Object> unsavedTitles = new ArrayList<Object>();
        try {
            for (TabPaneTab tab : this.activitiesView.getTabs()) {
                ActivityState state;
                if (tab.getContent() == null || (state = (ActivityState)tab.getProperties().get((Object)"activityState")) == null || !state.getHandler().isSaveRequired(state)) continue;
                unsavedTitles.add(state.titleProperty().get());
            }
        }
        catch (Exception e) {
            ErrorHandler.handle(e);
        }
        if (unsavedTitles.isEmpty()) {
            Notifications.get().submitTask(() -> this.unlockAndClose(callback), Messages.General_Shutting_down);
            return;
        }
        String supMessage = unsavedTitles.stream().limit(5L).collect(Collectors.joining("\n"));
        if (unsavedTitles.size() > 5) {
            supMessage = supMessage + "\n...";
        }
        new Dialog().setTitle(Messages.General_Accept_required).setMessage(Messages.General_Unsaved_changes).setSupplmentalMessage(supMessage).setOnCloseRequest(() -> callback.accept(false)).addButton(DialogButtonStyle.DECLINE, () -> callback.accept(false)).addButton(DialogButtonStyle.AUXILARY, Messages.General_Exit_without_save, () -> Notifications.get().submitTask(() -> this.unlockAndClose(callback), Messages.General_Shutting_down)).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.General_Exit_with_save, () -> Notifications.get().submitTask(() -> this.saveAndClose(callback), Messages.General_Save_changes_and_shutdown)).showGlobal();
    }

    private void saveAndClose(AppStopHook.ShutdownCallback callback) {
        ArrayList toSave = new ArrayList();
        try {
            FxUtil.waitForFxThread(() -> {
                for (TabPaneTab tab : this.activitiesView.getTabs()) {
                    try {
                        ActivityState state = (ActivityState)tab.getProperties().get((Object)"activityState");
                        if (state == null || !state.getHandler().isSaveRequired(state) || !state.getHandler().validate(state)) continue;
                        toSave.add(state);
                    }
                    catch (Exception e) {
                        LoggerFactory.getLogger(this.getClass()).error("failed checking activity midifications state", (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("failed collecting to be saved activities", (Throwable)e);
        }
        for (ActivityState state : toSave) {
            try {
                state.getHandler().saveChanges(state);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("failed saving activity", (Throwable)e);
            }
        }
        this.unlockAndClose(callback);
    }

    private void unlockAndClose(AppStopHook.ShutdownCallback callback) {
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        ArrayList toUnlock = new ArrayList();
        try {
            FxUtil.waitForFxThread(() -> {
                for (TabPaneTab tab : this.activitiesView.getTabs()) {
                    try {
                        boolean ignorePersistViewState;
                        ActivityState state = (ActivityState)tab.getProperties().get((Object)"activityState");
                        if (state == null) continue;
                        if (sic.getUser().equals(state.getLockOwner())) {
                            toUnlock.add(state);
                        }
                        if (ignorePersistViewState = Boolean.parseBoolean(System.getProperty("client.fx.ActivityManagerAppStopHook.ignorePersistViewState"))) continue;
                        ActivityManager.persistViewState(tab, state, false);
                    }
                    catch (Exception e) {
                        LoggerFactory.getLogger(this.getClass()).error("failed checking activity lock state", (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("failed collecting to be unlocked activities", (Throwable)e);
        }
        if (!toUnlock.isEmpty()) {
            for (ActivityState state : toUnlock) {
                try {
                    state.getHandler().unLock(state, true);
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(this.getClass()).error("failed unlocking activity", (Throwable)e);
                }
            }
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        callback.accept(true);
    }
}

