/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.assets.editor;

import com.gridnine.xtrip.client.fx.core.acl.FxAclUtil;
import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.action.ActionsPane;
import com.gridnine.xtrip.client.fx.core.assets.AssetHandler;
import com.gridnine.xtrip.client.fx.core.assets.AssetModification;
import com.gridnine.xtrip.client.fx.core.assets.AssetModificationEvent;
import com.gridnine.xtrip.client.fx.core.assets.editor.AssetEditorAction;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.kb.KeyBindings;
import com.gridnine.xtrip.client.fx.core.kb.ShortcutHandler;
import com.gridnine.xtrip.client.fx.core.kb.StandardKeyBindingActions;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.ViewWalker;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TilesSpace;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.StandardNotifications;
import com.gridnine.xtrip.client.fx.core.ui.tab.BaseContentPane;
import com.gridnine.xtrip.client.fx.core.ui.tab.ContentError;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.service.AssetService;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;

public class AssetEditorPane<A extends BaseAsset>
extends BaseContentPane
implements ShortcutHandler {
    private final ObservableMutex mutex;
    protected final Set<String> actionsAcl = new HashSet<String>();
    private final ActionsPane<AssetEditorAction> actionsPane = new ActionsPane<AssetEditorAction>(){

        @Override
        protected boolean isDefault(AssetEditorAction action) {
            return false;
        }

        @Override
        protected boolean isEnabled(AssetEditorAction action) {
            if (AssetEditorPane.this.getMutex().isAcquired() || !AssetEditorPane.this.actionsAcl.contains(action.getId())) {
                return false;
            }
            return action.isEnabled(AssetEditorPane.this);
        }

        @Override
        protected void execute(Control source, AssetEditorAction action, boolean alt) {
            action.execute(source, AssetEditorPane.this, alt);
        }

        @Override
        protected String getName(AssetEditorAction action) {
            return action.getName(AssetEditorPane.this);
        }

        @Override
        protected String getDescription(AssetEditorAction action) {
            return action.getDescription(AssetEditorPane.this);
        }

        @Override
        protected ActionIcon getIcon(AssetEditorAction action) {
            return action.getIcon(AssetEditorPane.this);
        }
    };
    private final ReadOnlyStringWrapper title = new ReadOnlyStringWrapper((Object)this, "title");
    private final SimpleStringProperty description = new SimpleStringProperty((Object)this, "description");
    private final AssetHandler<A> handler;
    private final ReadOnlyStringWrapper assetUid = new ReadOnlyStringWrapper((Object)this, "assetUid");
    protected final ViewController<?, A> controller;
    private final TilesSpace contentSpace;
    private A data;
    private boolean dataLoadFailed;
    private final InvalidationListener acquiredListener;

    public AssetEditorPane(ObservableMutex mtx, final AssetHandler<A> hndlr, String uid) {
        this.mutex = mtx;
        this.handler = hndlr;
        this.assetUid.set(uid);
        this.getStyleClass().add((Object)"xtrip-editor-pane");
        this.controller = this.handler.createEditorController(this.mutex);
        Object view = this.controller.getView();
        this.contentSpace = new TilesSpace(1, (Node)view){
            final /* synthetic */ Node val$view;
            {
                this.val$view = node;
                super(columns);
                this.addTiles(new Tile<Object, Node>("main", hndlr.getName(), null, this.val$view));
            }
        };
        this.actionsPane.populate(this.getActions());
        this.acquiredListener = observable -> this.actionsPane.revalidate();
        this.mutex.acquiredProperty().addListener(this.acquiredListener);
        this.composePane((Node)this.contentSpace, this.buildHeader(), this.actionsPane, null);
        Notifications.get().submitTask(this::reloadActionsACL, this.mutex);
    }

    @Override
    public void dispose() {
        this.mutex.acquiredProperty().removeListener(this.acquiredListener);
        super.dispose();
    }

    private List<AssetEditorAction> getActions() {
        return ClientRegistry.get().allOf(AssetEditorAction.TYPE).values().stream().filter(action -> action.isAvailable(this)).collect(Collectors.toList());
    }

    public Node getEditor() {
        return this.controller.getView();
    }

    @Override
    public void handleShortcut(KeyEvent event) {
        if (this.mutex.isAcquired()) {
            return;
        }
        KeyBindings kb = KeyBindings.get();
        if (kb.getKeyCombination(StandardKeyBindingActions.RELOAD).match(event)) {
            this.doReload();
            event.consume();
        } else {
            this.actionsPane.handleShortcut(event);
        }
    }

    public void reloadData() {
        if (this.assetUid.get() == null || this.isDisposed()) {
            return;
        }
        this.actionsAcl.clear();
        try {
            ServiceInvocationContext ctx = ServiceInvocationContext.get();
            HashMap<String, AclQuery> map = new HashMap<String, AclQuery>();
            map.put(this.handler.getAssetType().getName(), AclQuery.AclQueryBuilder.get().entry(StandardRestrictionResourceOperations.VIEW.getId(), this.handler.getAssetType().getName()).build());
            Set<String> grantedIds = FxAclUtil.applyACL(map);
            if (!grantedIds.contains(this.handler.getAssetType().getName())) {
                FxUtil.waitForFxThread(() -> this.handleLoadError(ContentError.ACCESS_DENIED));
                return;
            }
            List assets = ((AssetService)RpcServiceManager.get().getService(AssetService.class)).find(ctx, this.handler.getAssetType(), BaseAsset.Property.uid.name(), (Object)this.assetUid.get()).getData();
            FxUtil.waitForFxThread(() -> {
                if (assets.size() == 0) {
                    this.handleLoadError(ContentError.NOT_FOUND);
                } else {
                    this.readData((BaseAsset)assets.get(0));
                }
            });
            this.reloadActionsACL();
        }
        catch (Exception e) {
            ErrorHandler.handle(e);
        }
    }

    private void reloadActionsACL() throws Exception {
        HashSet<String> enabled = new HashSet<String>();
        HashMap<String, AclQuery> map = new HashMap<String, AclQuery>();
        for (AssetEditorAction action : this.getActions()) {
            AclQuery query = action.getACLQuery(this);
            if (query == null) {
                enabled.add(action.getId());
                continue;
            }
            map.put(action.getId(), query);
        }
        Set<String> granted = FxAclUtil.applyACL(map);
        this.actionsAcl.clear();
        this.actionsAcl.addAll(enabled);
        this.actionsAcl.addAll(granted);
    }

    public void saveData() throws Exception {
        ValueHolder<Object> asset = new ValueHolder<Object>();
        if (this.assetUid.get() != null) {
            List assets = ((AssetService)RpcServiceManager.get().getService(AssetService.class)).find(ServiceInvocationContext.get(), this.handler.getAssetType(), BaseAsset.Property.uid.name(), (Object)this.assetUid.get()).getData();
            if (assets.size() > 0) {
                asset.set(assets.get(0));
            }
        } else {
            asset.set(this.handler.getAssetType().newInstance());
        }
        if (asset.get() == null) {
            throw Xeption.forEndUser((String)Messages.General_Document_saving_failed, (Object[])new Object[0]);
        }
        this.actionsAcl.clear();
        FxUtil.waitForFxThread(() -> this.writeData((BaseAsset)asset.get()));
        asset.set(((AssetService)RpcServiceManager.get().getService(AssetService.class)).save(ServiceInvocationContext.get(), (BaseAsset)asset.get()));
        FxUtil.waitForFxThread(() -> this.readData((BaseAsset)asset.get()));
        this.reloadActionsACL();
        StandardNotifications.SAVED.show(((BaseAsset)asset.get()).toString());
        EventBus.get().publishAsync(new AssetModificationEvent(new AssetModification((BaseAsset)asset.get(), AssetModification.ModificationType.CHANGE)));
    }

    public boolean validate() {
        ArrayList<Message> messages = new ArrayList<Message>();
        this.validateData(messages);
        this.contentSpace.setMessages(messages);
        if (!MessagesHelper.hasErrorMessage(messages)) {
            return true;
        }
        StandardNotifications.VALIDATION_FAILED.show(null);
        return false;
    }

    public ObservableMutex getMutex() {
        return this.mutex;
    }

    public ReadOnlyStringProperty titleProperty() {
        return this.title;
    }

    public ReadOnlyStringProperty descriptionProperty() {
        return this.description;
    }

    public AssetHandler<A> getAssetHandler() {
        return this.handler;
    }

    public String getAssetUid() {
        return this.assetUid.get();
    }

    public ReadOnlyStringProperty assetUidProperty() {
        return this.assetUid;
    }

    public A getData() {
        return this.data;
    }

    public boolean isDataChanged() {
        return !this.dataLoadFailed && this.controller.isDataChanged();
    }

    public void readData(A model) {
        if (this.isDisposed()) {
            return;
        }
        this.data = model;
        this.assetUid.set(model != null ? model.getUid() : null);
        ViewWalker.saveState(this.controller.getView());
        if (this.controller.isAwareOfControllersRegistry()) {
            this.controller.readData(model);
        } else {
            ControllersRegistry.beforeReadData(this.controller, model);
            this.controller.readData(model);
            ControllersRegistry.afterReadData(this.controller, model);
        }
        this.updateTitle(model);
        this.actionsPane.revalidate();
        FxUtil.submitToFxThread(() -> ViewWalker.restoreState(this.controller.getView()));
    }

    protected void writeData(A model) {
        this.data = model;
        this.assetUid.set(model.getUid());
        if (this.controller.isAwareOfControllersRegistry()) {
            this.controller.writeData(model);
        } else {
            ControllersRegistry.beforeWriteData(this.controller, model);
            this.controller.writeData(model);
            ControllersRegistry.afterWriteData(this.controller, model);
        }
        this.updateTitle(model);
    }

    private void validateData(List<Message> messages) {
        if (!this.controller.isAwareOfControllersRegistry()) {
            ControllersRegistry.validateData(this.controller, messages);
        }
        this.controller.validateData(messages);
    }

    private Node buildHeader() {
        ArrayList<Object> nodes = new ArrayList<Object>();
        Label caption = new Label();
        GridPane.setHgrow((Node)caption, (Priority)Priority.ALWAYS);
        caption.textProperty().bind((ObservableValue)this.title);
        nodes.add(caption);
        Button button = new Button();
        button.setGraphic((Node)new IconNode(StandardIconShapes.RELOAD_12x12, (Styleable)button, StandardIconIntentions.BASIC_BUTTON_ACTION, (Styleable)button));
        button.getStyleClass().add((Object)"xtrip-button");
        UiUtil.setTooltip((Node)button, Messages.General_Refresh_document_data);
        button.setOnAction(evt -> this.doReload());
        nodes.add(button);
        GridPane result = new GridPane();
        result.getStyleClass().add((Object)"editor-header-pane");
        result.addRow(0, nodes.toArray(new Node[nodes.size()]));
        return result;
    }

    private void doReload() {
        if (this.isDataChanged()) {
            new Dialog().setTitle(Messages.General_Accepting_required).setMessage(Messages.General_Is_saving_required).setSupplmentalMessage((String)this.titleProperty().get()).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.AUXILARY, Messages.General_Dont_save, () -> Notifications.get().submitTask(this::reloadData, this.mutex)).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.General_Save, () -> {
                if (!this.validate()) {
                    return;
                }
                Notifications.get().submitTask(this::saveData, this.mutex);
            }).show((Node)this);
        } else {
            Notifications.get().submitTask(this::reloadData, this.mutex);
        }
    }

    private void updateTitle(A model) {
        String str = model == null ? Messages.General_Without_name : this.handler.format(model);
        this.title.set(str);
        this.description.set(this.handler.getName() + ": " + str);
    }

    private void handleLoadError(ContentError error) {
        if (this.isDisposed()) {
            return;
        }
        this.data = null;
        this.dataLoadFailed = true;
        this.composePane(error.createNode(String.format("<p>Handler ID: <code>%s</code><br>Asset UID: <code>%s</code></p>", this.handler.getId(), this.assetUid.get())), null, null, null);
        this.title.set(error.getTitle());
        this.description.set(null);
    }
}

