/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.assets.list;

import com.gridnine.xtrip.client.fx.core.acl.FxAclUtil;
import com.gridnine.xtrip.client.fx.core.action.Action;
import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.action.ActionsPane;
import com.gridnine.xtrip.client.fx.core.assets.AssetHandler;
import com.gridnine.xtrip.client.fx.core.assets.AssetListParameters;
import com.gridnine.xtrip.client.fx.core.assets.AssetModification;
import com.gridnine.xtrip.client.fx.core.assets.AssetModificationEvent;
import com.gridnine.xtrip.client.fx.core.assets.list.AssetsListAction;
import com.gridnine.xtrip.client.fx.core.assets.list.AssetsListPaneConfiguration;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.list.ListPane;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.service.AssetService;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import java.util.stream.Collectors;
import javafx.scene.control.Control;
import javafx.scene.control.SelectionMode;

public class AssetsListPane
extends ListPane<BaseAsset, AssetsListPaneConfiguration> {
    private final Consumer<AssetModificationEvent> modificationEventHandler = evt -> FxUtil.runInFxThread(() -> {
        AssetHandler<?> handler = this.getAssetHandler();
        for (AssetModification modification : evt.getModifications()) {
            if (!handler.getAssetType().isAssignableFrom(modification.getAsset().getClass())) continue;
            this.reloadData();
            return;
        }
    });
    protected final Set<String> actionsAcl = new HashSet<String>();

    public AssetsListPane(ObservableMutex mutex, MultiSupplier<AssetsListPaneConfiguration> supplier) {
        super(supplier, mutex);
        this.selectConfiguration(0);
    }

    public AssetsListPane(ObservableMutex mutex, final Class<? extends BaseAsset> assetType, final AssetListParameters parameters, final SelectionMode selectionMode, final boolean actionsEnabled) {
        super(new MultiSupplier<AssetsListPaneConfiguration>(){

            @Override
            public int count() {
                return 1;
            }

            @Override
            public String getDisplayName(int idx) {
                return null;
            }

            @Override
            public AssetsListPaneConfiguration get(int idx) {
                AssetsListPaneConfiguration result = new AssetsListPaneConfiguration(AssetHandler.forAssetClass(assetType));
                result.setPatternSearchEnabled(true);
                result.setSelectionMode(selectionMode);
                result.setActionsEnabled(actionsEnabled);
                result.applyParameters(parameters);
                return result;
            }
        }, mutex);
        this.selectConfiguration(0);
    }

    @Override
    protected void loadData(ObjIntConsumer<List<BaseAsset>> callback) throws Exception {
        ValueHolder queryHolder = new ValueHolder();
        FxUtil.waitForFxThread(() -> queryHolder.set(this.buildQuery()));
        List searchResult = ((AssetService)RpcServiceManager.get().getService(AssetService.class)).search(ServiceInvocationContext.get(), this.getAssetHandler().getAssetType(), (SearchQuery)queryHolder.get()).getData();
        callback.accept(new ArrayList(searchResult), ((SearchQuery)queryHolder.get()).getOffset());
    }

    public SearchQuery buildQuery() {
        SearchQuery result = new SearchQuery();
        for (TableColumnSettings colSet : ((AssetsListPaneConfiguration)this.getConfiguration()).getColumnsSettings()) {
            if (colSet.getId() == null) continue;
            result.getPreferredProperties().add(colSet.getId());
        }
        result.setLimit(((AssetsListPaneConfiguration)this.getConfiguration()).getLimit());
        result.setOffset(this.getOffset());
        result.getCriteria().getCriterions().addAll(((AssetsListPaneConfiguration)this.getConfiguration()).getSearchCriterions());
        String patternText = this.getPatternText();
        if (!TextUtil.isBlank((String)patternText)) {
            SearchCriterion criterion = null;
            for (String field : ((AssetsListPaneConfiguration)this.getConfiguration()).getPatternSearchFields()) {
                SearchCriterion crt = null;
                for (String str : patternText.split(" ")) {
                    if (TextUtil.isBlank((String)str)) continue;
                    String pattern = '%' + str.trim().toLowerCase() + '%';
                    crt = crt == null ? SearchCriterion.ilike((String)field, (String)pattern) : SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{crt, SearchCriterion.ilike((String)field, (String)pattern)});
                }
                if (crt == null) continue;
                if (criterion == null) {
                    criterion = crt;
                    continue;
                }
                criterion = SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{criterion, crt});
            }
            if (criterion != null) {
                result.getCriteria().getCriterions().add(criterion);
            }
        }
        for (Map.Entry<String, SortOrder> entry : this.getSortOrder().entrySet()) {
            if (entry.getValue() == null) continue;
            result.getCriteria().getOrders().put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.getFiltersData().entrySet()) {
            Object value;
            String propertyId = entry.getKey();
            List values = (List)entry.getValue();
            if (values.size() == 1 && values.get(0) != null) {
                value = values.get(0);
                if (this.getAssetHandler().isCollection(propertyId)) {
                    if (value.getClass().isEnum()) {
                        value = ((Enum)value).name();
                    }
                    result.getCriteria().getCriterions().add(SearchCriterion.contains((String)propertyId, (Object)String.valueOf(value)));
                    continue;
                }
                if (value instanceof String) {
                    result.getCriteria().getCriterions().add(SearchCriterion.ilike((String)propertyId, (String)('%' + String.valueOf(value).trim().toLowerCase() + '%')));
                    continue;
                }
                result.getCriteria().getCriterions().add(SearchCriterion.eq((String)propertyId, value));
                continue;
            }
            if (values.size() != 2) continue;
            value = values.get(0);
            if (value != null) {
                if (value instanceof Date) {
                    value = MiscUtil.clearTime((Date)((Date)value));
                }
                result.getCriteria().getCriterions().add(SearchCriterion.ge((String)propertyId, value));
            }
            if ((value = values.get(1)) == null) continue;
            if (value instanceof Date) {
                value = MiscUtil.setDayEndTime((Date)((Date)value));
            }
            result.getCriteria().getCriterions().add(SearchCriterion.le((String)propertyId, value));
        }
        return result;
    }

    @Override
    protected String getQueryInfo() {
        ValueHolder queryHolder = new ValueHolder();
        try {
            FxUtil.waitForFxThread(() -> queryHolder.set(this.buildQuery()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getAssetHandler().getAssetType().getName() + ' ' + ((SearchQuery)queryHolder.get()).toString();
    }

    @Override
    protected Object getItemValue(BaseAsset item, String columnId) {
        return this.getAssetHandler().getValue(item, columnId);
    }

    @Override
    protected ActionsPane<?> createActionsPane() {
        ActionsPane<AssetsListAction> result = new ActionsPane<AssetsListAction>(){

            @Override
            protected boolean isDefault(AssetsListAction action) {
                return action.isDefault();
            }

            @Override
            protected boolean isEnabled(AssetsListAction action) {
                if (AssetsListPane.this.getMutex().isAcquired() || !AssetsListPane.this.actionsAcl.contains(action.getId())) {
                    return false;
                }
                return action.isEnabled(AssetsListPane.this);
            }

            @Override
            protected void execute(Control source, AssetsListAction action, boolean alt) {
                action.execute(source, AssetsListPane.this, alt);
            }

            @Override
            protected String getName(AssetsListAction action) {
                return action.getName(AssetsListPane.this);
            }

            @Override
            protected String getDescription(AssetsListAction action) {
                return action.getDescription(AssetsListPane.this);
            }

            @Override
            protected ActionIcon getIcon(AssetsListAction action) {
                return action.getIcon(AssetsListPane.this);
            }
        };
        result.populate(this.collectActions());
        return result;
    }

    protected Collection<AssetsListAction> collectActions() {
        return ClientRegistry.get().allOf(AssetsListAction.TYPE).values().stream().filter(action -> action.isAvailable(this)).collect(Collectors.toList());
    }

    @Override
    protected <A extends Action<?>> void executeAction(Control source, A action) {
        AssetsListAction ala = (AssetsListAction)action;
        if (ala.isEnabled(this)) {
            ala.execute(source, this, false);
        }
    }

    @Override
    protected AclQuery getListACLQuery() {
        return new AclQuery(StandardRestrictionResourceOperations.VIEW.getId(), this.getAssetHandler().getAssetType().getName());
    }

    public AssetHandler<?> getAssetHandler() {
        return ((AssetsListPaneConfiguration)this.getConfiguration()).getHandler();
    }

    public Consumer<AssetModificationEvent> getModificationEventHandler() {
        return this.modificationEventHandler;
    }

    @Override
    protected void newConfigurationPopulated() {
        super.newConfigurationPopulated();
        ActionsPane<?> actionsPane = this.getActionsPane();
        if (actionsPane == null) {
            return;
        }
        this.actionsAcl.clear();
        Notifications.get().submitTask(() -> {
            HashSet<String> enabled = new HashSet<String>();
            HashMap<String, AclQuery> map = new HashMap<String, AclQuery>();
            for (AssetsListAction action : this.collectActions()) {
                AclQuery query = action.getACLQuery(this);
                if (query == null) {
                    enabled.add(action.getId());
                    continue;
                }
                map.put(action.getId(), query);
            }
            Set<String> granted = FxAclUtil.applyACL(map);
            this.actionsAcl.clear();
            this.actionsAcl.addAll(enabled);
            this.actionsAcl.addAll(granted);
            FxUtil.submitToFxThread(actionsPane::revalidate);
        }, this.getMutex());
    }

    @Override
    protected void buildConfigurationInfo(StringBuilder buf, AssetsListPaneConfiguration config) {
        super.buildConfigurationInfo(buf, config);
        buf.append("Asset class: ").append(config.getHandler().getAssetType().getName()).append('\n');
        buf.append("Asset handler class: ").append(config.getHandler().getClass().getName()).append('\n');
        buf.append("Query: ").append(this.buildQuery().toString()).append('\n');
        buf.append("Actions (class, ID, title [flags]):\n");
        for (AssetsListAction action : this.collectActions()) {
            buf.append('\t').append(action.getClass().getName()).append('\t').append(action.getId()).append('\t').append(action.getName(this));
            if (!action.isEnabled(this)) {
                buf.append(" [disabled]");
            }
            if (!this.actionsAcl.contains(action.getId())) {
                buf.append(" [forbidden]");
            }
            buf.append('\n');
        }
    }
}

