/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.dialogs;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.TextUtil;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PopupControl;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.stage.PopupWindow;

public class LightDialog {
    private String title;
    private Node body;
    private String actionCaption = Messages.General_OK;
    private Runnable actionHandler;
    private BooleanExpression actionAvailability;

    public LightDialog setTitle(String value) {
        this.title = value;
        return this;
    }

    public LightDialog setBody(Node value) {
        this.body = value;
        return this;
    }

    public LightDialog setActionCaption(String value) {
        this.actionCaption = value;
        return this;
    }

    public LightDialog setActionHandler(Runnable value) {
        this.actionHandler = value;
        return this;
    }

    public LightDialog setActionAvailability(BooleanExpression value) {
        this.actionAvailability = value;
        return this;
    }

    public void show(Region anchor) {
        if (TextUtil.isBlank((String)this.title) && this.body == null) {
            throw Xeption.forDeveloper((String)"illegal dialog configuration - neither title nor body provided", (Object[])new Object[0]);
        }
        GridPane pane = new GridPane();
        pane.getStyleClass().add((Object)"xtrip-light-dialog-pane");
        PopupControl popup = UiUtil.createPopup((Parent)pane);
        int row = 0;
        if (!TextUtil.isBlank((String)this.title)) {
            Label label = new Label(this.title);
            GridPane.setColumnSpan((Node)label, (Integer)2);
            pane.add((Node)label, 0, row++);
        }
        if (this.body != null) {
            GridPane.setHgrow((Node)this.body, (Priority)Priority.ALWAYS);
            GridPane.setVgrow((Node)this.body, (Priority)Priority.ALWAYS);
            GridPane.setFillHeight((Node)this.body, (Boolean)Boolean.TRUE);
            pane.add(this.body, 0, row);
        }
        Button button = new Button(this.actionCaption);
        button.setOnAction(evt -> {
            popup.hide();
            if (this.actionHandler != null) {
                this.actionHandler.run();
            }
        });
        if (this.actionAvailability != null) {
            button.disableProperty().bind((ObservableValue)this.actionAvailability.not());
        }
        GridPane.setVgrow((Node)button, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)button, (Priority)Priority.NEVER);
        GridPane.setFillHeight((Node)button, (Boolean)Boolean.TRUE);
        pane.add((Node)button, 1, row);
        pane.addEventFilter(KeyEvent.KEY_PRESSED, evt -> {
            if (evt.getCode() == KeyCode.ESCAPE) {
                popup.hide();
                evt.consume();
                return;
            }
            if (evt.getCode() == KeyCode.ENTER && !button.isDisable()) {
                popup.hide();
                evt.consume();
                if (this.actionHandler != null) {
                    this.actionHandler.run();
                }
            }
        });
        UiUtil.showPopup((PopupWindow)popup, anchor);
        if (this.body != null) {
            FxUtil.submitToFxThread(() -> ((Node)this.body).requestFocus());
        }
    }
}

