/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.dicts.editor;

import com.gridnine.xtrip.client.fx.core.acl.AclCheckEntry;
import com.gridnine.xtrip.client.fx.core.acl.FxAclUtil;
import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.action.ActionsPane;
import com.gridnine.xtrip.client.fx.core.devtools.DevTools;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.dicts.DictHandler;
import com.gridnine.xtrip.client.fx.core.dicts.DictionaryModification;
import com.gridnine.xtrip.client.fx.core.dicts.DictionaryModificationEvent;
import com.gridnine.xtrip.client.fx.core.dicts.editor.DictEditorAction;
import com.gridnine.xtrip.client.fx.core.entity.raw.RawEntityEditor;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.kb.KeyBindings;
import com.gridnine.xtrip.client.fx.core.kb.ShortcutHandler;
import com.gridnine.xtrip.client.fx.core.kb.StandardKeyBindingActions;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomContextMenu;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomMenuItem;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TilesSpace;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextAreaWidget;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.StandardNotifications;
import com.gridnine.xtrip.client.fx.core.ui.tab.BaseContentPane;
import com.gridnine.xtrip.client.fx.core.ui.tab.ContentError;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ModelCheckUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.fx.rpc.service.AssetService;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.assets.DictionaryVersion;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.Predefinable;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.GZIPUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;

public class DictEditorPane<D extends BaseDictionary>
extends BaseContentPane
implements ShortcutHandler {
    private final SimpleStringProperty title = new SimpleStringProperty((Object)this, "title");
    private final SimpleStringProperty description = new SimpleStringProperty((Object)this, "description");
    private final ObservableMutex mutex;
    final Set<String> actionsAcl = new HashSet<String>();
    private final ActionsPane<DictEditorAction> actionsPane = new ActionsPane<DictEditorAction>(){

        @Override
        protected boolean isDefault(DictEditorAction action) {
            return false;
        }

        @Override
        protected boolean isEnabled(DictEditorAction action) {
            if (DictEditorPane.this.getMutex().isAcquired() || !DictEditorPane.this.actionsAcl.contains(action.getId())) {
                return false;
            }
            return action.isEnabled(DictEditorPane.this);
        }

        @Override
        protected void execute(Control source, DictEditorAction action, boolean alt) {
            action.execute(source, DictEditorPane.this, alt);
        }

        @Override
        protected String getName(DictEditorAction action) {
            return action.getName(DictEditorPane.this);
        }

        @Override
        protected String getDescription(DictEditorAction action) {
            return action.getDescription(DictEditorPane.this);
        }

        @Override
        protected ActionIcon getIcon(DictEditorAction action) {
            return action.getIcon(DictEditorPane.this);
        }
    };
    protected final DictHandler<D> dictHandler;
    private final ReadOnlyStringWrapper code = new ReadOnlyStringWrapper((Object)this, "code");
    private final String fixedVersionUid;
    private final Integer fixedVersionNumber;
    private final ViewController<?, D> controller;
    private ViewController<?, D> adminController;
    private final StackPane contentPane;
    private D data;
    private boolean dataLoadFailed;
    private final InvalidationListener acquiredListener;
    private List<AclCheckEntry> lastAclCheck;

    public DictEditorPane(ObservableMutex mtx, DictHandler<D> handler, String dictCode, String versionUid, Integer versionNumber) {
        this.mutex = mtx;
        this.dictHandler = handler;
        this.code.set(dictCode);
        this.getStyleClass().add((Object)"xtrip-editor-pane");
        this.controller = this.dictHandler.createEditorController();
        this.contentPane = new StackPane();
        this.initView();
        this.actionsPane.populate(this.getActions());
        this.acquiredListener = obj -> this.actionsPane.revalidate();
        this.mutex.acquiredProperty().addListener(this.acquiredListener);
        this.composePane((Node)this.contentPane, this.buildHeader(), this.actionsPane, null);
        Notifications.get().submitTask(this::reloadActionsACL, mtx);
        this.fixedVersionUid = versionUid;
        this.fixedVersionNumber = versionNumber;
    }

    public DictEditorPane(ObservableMutex mtx, DictHandler<D> handler, String dictCode) {
        this(mtx, handler, dictCode, null, null);
    }

    @Override
    public void dispose() {
        this.mutex.acquiredProperty().removeListener(this.acquiredListener);
        super.dispose();
    }

    @Override
    public void handleShortcut(KeyEvent event) {
        if (this.mutex.isAcquired()) {
            return;
        }
        KeyBindings kb = KeyBindings.get();
        if (kb.getKeyCombination(StandardKeyBindingActions.RELOAD).match(event)) {
            this.doReload();
            event.consume();
        } else {
            this.actionsPane.handleShortcut(event);
        }
    }

    private void initView() {
        this.getViewController().setReadonly(this.dictHandler.isReadonly());
        Object view = this.getViewController().getView();
        if (view instanceof TilesSpace) {
            this.contentPane.getChildren().setAll((Object[])new Node[]{view});
        } else {
            this.contentPane.getChildren().setAll((Object[])new Node[]{new TilesSpace(1, (Node)view){
                final /* synthetic */ Node val$view;
                {
                    this.val$view = node;
                    super(columns);
                    this.addTiles(new Tile<Object, Node>("main", Messages.General_Dict + ' ' + DictHandler.format(DictEditorPane.this.dictHandler), null, this.val$view));
                }
            }});
        }
    }

    public Node getEditor() {
        return this.controller.getView();
    }

    private ViewController<?, D> getViewController() {
        return this.adminController != null ? this.adminController : this.controller;
    }

    private List<DictEditorAction> getActions() {
        return ClientRegistry.get().allOf(DictEditorAction.TYPE).values().stream().filter(action -> action.isAvailable(this)).collect(Collectors.toList());
    }

    private Node buildHeader() {
        ArrayList<Object> nodes = new ArrayList<Object>();
        Label caption = new Label();
        GridPane.setHgrow((Node)caption, (Priority)Priority.ALWAYS);
        caption.textProperty().bind((ObservableValue)this.title);
        nodes.add(caption);
        Button button = new Button();
        button.setGraphic((Node)new IconNode(StandardIconShapes.RELOAD_12x12, (Styleable)button, StandardIconIntentions.BASIC_BUTTON_ACTION, (Styleable)button));
        button.getStyleClass().add((Object)"xtrip-button");
        UiUtil.setTooltip((Node)button, Messages.General_Refresh_dict_data);
        button.setOnAction(evt -> this.doReload());
        nodes.add(button);
        GridPane result = new GridPane();
        result.getStyleClass().add((Object)"editor-header-pane");
        result.addRow(0, nodes.toArray(new Node[nodes.size()]));
        result.setOnMouseClicked(evt -> {
            if (!evt.isAltDown() || evt.getButton() != MouseButton.PRIMARY) {
                return;
            }
            CustomContextMenu menu = new CustomContextMenu();
            menu.getItems().addAll(this.collectAdminTools());
            menu.show((Node)result, evt.getScreenX(), evt.getScreenY());
        });
        return result;
    }

    private void doReload() {
        if (this.isDataChanged()) {
            new Dialog().setTitle(Messages.General_Accepting_required).setMessage(Messages.General_Is_saving_required).setSupplmentalMessage((String)this.titleProperty().get()).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.AUXILARY, Messages.General_Dont_save, () -> Notifications.get().submitTask(this::reloadData, this.mutex)).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.General_Save, () -> {
                if (!this.validate()) {
                    return;
                }
                Notifications.get().submitTask(this::saveData, this.mutex);
            }).show((Node)this);
        } else {
            Notifications.get().submitTask(this::reloadData, this.mutex);
        }
    }

    private List<MenuItem> collectAdminTools() {
        CustomMenuItem item;
        ArrayList<MenuItem> result = new ArrayList<MenuItem>();
        if (this.adminController == null) {
            item = new CustomMenuItem("XML content mode");
            item.setOnAction(evt -> {
                if (!this.getViewController().isReadonly()) {
                    try {
                        if (this.data == null) {
                            this.data = (BaseDictionary)this.dictHandler.getDictType().newInstance();
                        }
                        this.writeData(this.data);
                    }
                    catch (Exception e) {
                        ErrorHandler.handle(e);
                    }
                }
                this.adminController = RawEntityEditor.createEntityController(this.getDictHandler().getDictType());
                this.initView();
                if (this.data != null) {
                    this.readData(this.data);
                } else {
                    this.updateTitle(null);
                }
            });
            result.add((MenuItem)item);
        } else {
            item = new CustomMenuItem("Standard content mode");
            item.setOnAction(evt -> {
                if (!this.adminController.isReadonly()) {
                    try {
                        if (this.data == null) {
                            this.data = (BaseDictionary)this.dictHandler.getDictType().newInstance();
                        }
                        this.writeData(this.data);
                    }
                    catch (Exception e) {
                        ErrorHandler.handle(e);
                    }
                }
                this.adminController = null;
                this.initView();
                if (this.data != null) {
                    this.readData(this.data);
                } else {
                    this.updateTitle(null);
                }
            });
            result.add((MenuItem)item);
        }
        item = new CustomMenuItem("UI Technical Data");
        item.setOnAction(evt -> {
            TextAreaWidget widget = new TextAreaWidget(true);
            widget.setValue(this.buildTechData());
            widget.setMonospace(true);
            widget.getViewState().setNotEditable(true);
            new Dialog().setTitle("Editor UI Technical Data").setBody((Node)widget).addButton(DialogButtonStyle.DECLINE, "Close").setExpandToParent(true).show((Node)this);
        });
        result.add((MenuItem)item);
        item = new CustomMenuItem("Save and Compare Data");
        item.setOnAction(evt -> Notifications.get().submitTask(() -> {
            D data1 = this.getData();
            this.saveData();
            D data2 = this.getData();
            try {
                ModelCheckUtil.compare(data1, data2);
                Dialog.info((Node)this, "Data matched.");
            }
            catch (ModelCheckUtil.MatchFailedException me) {
                Dialog.message((Node)this, "Data not matched", me.getPath() + "\n\n" + me.getDetails());
            }
        }, this.mutex));
        result.add((MenuItem)item);
        return result;
    }

    private String buildTechData() {
        StringBuilder result = new StringBuilder();
        result.append("Dictionary handler class: ").append(this.dictHandler.getClass().getName()).append('\n');
        result.append("Dictionary handler ID: ").append(this.dictHandler.getId()).append('\n');
        result.append('\n');
        result.append("ACL check result (key, query, granted)\n");
        if (this.lastAclCheck != null) {
            for (AclCheckEntry entry : this.lastAclCheck) {
                result.append("\t").append(entry.getKey()).append(", ").append(entry.getQuery()).append(", ").append(entry.isGranted()).append('\n');
            }
        } else {
            result.append("\tno data\n");
        }
        result.append('\n');
        result.append("Actions (class, ID, title [flags])\n");
        for (DictEditorAction action : this.getActions()) {
            result.append(action.getClass().getName()).append('\t').append(action.getId()).append('\t').append(action.getName(this));
            if (!action.isEnabled(this)) {
                result.append(" [disabled]");
            }
            if (!this.actionsAcl.contains(action.getId())) {
                result.append(" [forbidden]");
            }
            result.append('\n');
        }
        result.append('\n').append(DevTools.getStructuredInfo(this.contentPane.getChildren().get(0)));
        return result.toString();
    }

    public void reloadData() {
        if (this.code.get() == null || this.isDisposed()) {
            return;
        }
        this.actionsAcl.clear();
        try {
            BaseDictionary dict;
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            HashMap<String, AclQuery> map = new HashMap<String, AclQuery>();
            map.put(this.dictHandler.getDictType().getName(), AclQuery.AclQueryBuilder.get().entry(StandardRestrictionResourceOperations.VIEW.getId(), this.dictHandler.getDictType().getName()).build());
            Set<String> grantedIds = FxAclUtil.applyACL(map);
            this.lastAclCheck = FxAclUtil.asCheckEntries(map, grantedIds);
            if (!grantedIds.contains(this.dictHandler.getDictType().getName())) {
                FxUtil.waitForFxThread(() -> this.handleLoadError(ContentError.ACCESS_DENIED));
                return;
            }
            if (this.fixedVersionUid == null) {
                DictService dictService = (DictService)RpcServiceManager.get().getService(DictService.class);
                dict = dictService.load(sic, this.dictHandler.createReference(this.code.get()));
            } else {
                AssetService assetService = (AssetService)RpcServiceManager.get().getService(AssetService.class);
                DictionaryVersion version = (DictionaryVersion)assetService.load(sic, DictionaryVersion.class, this.fixedVersionUid);
                dict = (BaseDictionary)XUtil.deserialize((byte[])GZIPUtil.gunzip((byte[])version.getData()));
            }
            FxUtil.waitForFxThread(() -> {
                if (dict == null) {
                    this.handleLoadError(ContentError.NOT_FOUND);
                } else {
                    this.readData(dict);
                }
            });
            this.reloadActionsACL();
        }
        catch (Exception e) {
            ErrorHandler.handle(e);
        }
    }

    private void reloadActionsACL() throws Exception {
        HashSet<String> enabled = new HashSet<String>();
        HashMap<String, AclQuery> map = new HashMap<String, AclQuery>();
        for (DictEditorAction action : this.getActions()) {
            AclQuery query = action.getACLQuery(this);
            if (query == null) {
                enabled.add(action.getId());
                continue;
            }
            map.put(action.getId(), query);
        }
        Set<String> granted = FxAclUtil.applyACL(map);
        this.actionsAcl.clear();
        this.actionsAcl.addAll(enabled);
        this.actionsAcl.addAll(granted);
    }

    public void saveData() throws Exception {
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        DictService dictService = (DictService)RpcServiceManager.get().getService(DictService.class);
        ValueHolder<Object> dict = new ValueHolder<Object>();
        if (this.code.get() == null) {
            if (dict.get() == null) {
                dict.set(this.dictHandler.getDictType().newInstance());
            }
        } else {
            dict.set(dictService.load(sic, this.dictHandler.createReference(this.code.get())));
        }
        if (dict.get() == null) {
            throw Xeption.forEndUser((String)Messages.General_Document_saving_failed, (Object[])new Object[0]);
        }
        this.actionsAcl.clear();
        FxUtil.waitForFxThread(() -> this.writeData((BaseDictionary)dict.get()));
        dict.set(dictService.save(sic, (BaseDictionary)dict.get()));
        FxUtil.waitForFxThread(() -> this.readData((BaseDictionary)dict.get()));
        this.reloadActionsACL();
        StandardNotifications.SAVED.show(((BaseDictionary)dict.get()).toString());
        EventBus.get().publishAsync(new DictionaryModificationEvent(new DictionaryModification(this.dictHandler.createReference(((BaseDictionary)dict.get()).getCode()), DictionaryModification.ModificationType.CHANGE)));
    }

    public boolean validate() {
        ArrayList<Message> messages = new ArrayList<Message>();
        this.validateData(messages);
        ((TilesSpace)this.contentPane.getChildren().get(0)).setMessages(messages);
        if (!MessagesHelper.hasErrorMessage(messages)) {
            return true;
        }
        StandardNotifications.VALIDATION_FAILED.show(null);
        return false;
    }

    public ObservableMutex getMutex() {
        return this.mutex;
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public ReadOnlyStringProperty descriptionProperty() {
        return this.description;
    }

    public DictHandler<D> getDictHandler() {
        return this.dictHandler;
    }

    public String getCode() {
        return this.code.get();
    }

    public ReadOnlyStringProperty codeProperty() {
        return this.code;
    }

    public D getData() {
        return this.data;
    }

    public void readData(D dict) {
        if (this.isDisposed()) {
            return;
        }
        this.data = dict;
        this.updateTitle(dict);
        this.code.set(dict == null ? null : dict.getCode());
        ViewController<?, D> viewController = this.getViewController();
        if (viewController.isAwareOfControllersRegistry()) {
            viewController.readData(dict);
        } else {
            ControllersRegistry.beforeReadData(viewController, dict);
            viewController.readData(dict);
            ControllersRegistry.afterReadData(viewController, dict);
        }
        if (this.dictHandler.isReadonly() || this.data instanceof Predefinable && ((Predefinable)this.data).isPredefined()) {
            viewController.setReadonly(true);
        } else {
            viewController.setReadonly(false);
        }
        this.actionsPane.revalidate();
    }

    private void writeData(D dict) {
        ViewController<?, D> viewController = this.getViewController();
        if (viewController.isAwareOfControllersRegistry()) {
            viewController.writeData(dict);
        } else {
            ControllersRegistry.beforeWriteData(viewController, dict);
            viewController.writeData(dict);
            ControllersRegistry.afterWriteData(viewController, dict);
        }
        this.data = dict;
        this.updateTitle(dict);
        this.code.set(dict.getCode());
    }

    private void updateTitle(D dict) {
        String str;
        String string = str = dict == null ? Messages.General_Without_name : this.dictHandler.format(dict);
        if (this.fixedVersionNumber != null) {
            str = str + ", " + Messages.General_Version + ' ' + (this.fixedVersionNumber + 1);
        }
        this.title.set(str);
        this.description.set(DictHandler.format(this.dictHandler) + ": " + str);
    }

    public boolean isDataChanged() {
        return !this.dataLoadFailed && this.getViewController().isDataChanged();
    }

    private void validateData(List<Message> messages) {
        ViewController<?, D> viewController = this.getViewController();
        if (!viewController.isAwareOfControllersRegistry()) {
            ControllersRegistry.validateData(viewController, messages);
        }
        viewController.validateData(messages);
    }

    private void handleLoadError(ContentError error) {
        if (this.isDisposed()) {
            return;
        }
        this.data = null;
        this.dataLoadFailed = true;
        this.composePane(error.createNode(String.format("<p>Handler ID: <code>%s</code><br>Dictionary code: <code>%s</code></p>", this.dictHandler.getId(), this.code.get())), null, null, null);
        this.title.set(error.getTitle());
        this.description.set(null);
    }
}

