/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.dicts.list;

import com.gridnine.xtrip.client.fx.core.acl.FxAclUtil;
import com.gridnine.xtrip.client.fx.core.action.Action;
import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.action.ActionsPane;
import com.gridnine.xtrip.client.fx.core.dicts.DictHandler;
import com.gridnine.xtrip.client.fx.core.dicts.DictionaryModification;
import com.gridnine.xtrip.client.fx.core.dicts.DictionaryModificationEvent;
import com.gridnine.xtrip.client.fx.core.dicts.list.DictsListAction;
import com.gridnine.xtrip.client.fx.core.dicts.list.DictsListPaneConfiguration;
import com.gridnine.xtrip.client.fx.core.list.ListPane;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.service.GlobalSettingsService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.DictItem;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import java.util.stream.Collectors;
import javafx.scene.control.Control;
import javafx.scene.control.TableColumn;

public class DictsListPane
extends ListPane<DictItem<?>, DictsListPaneConfiguration> {
    private final Consumer<DictionaryModificationEvent> modificationEventHandler = evt -> {
        if (evt.getModifications().isEmpty()) {
            return;
        }
        FxUtil.runInFxThread(() -> {
            DictHandler<?> handler = this.getDictHandler();
            for (DictionaryModification mod : evt.getModifications()) {
                if (!handler.getDictType().isAssignableFrom(mod.getReference().getType())) continue;
                this.reloadData();
                return;
            }
        });
    };
    protected final Set<String> actionsAcl = new HashSet<String>();

    public DictsListPane(ObservableMutex mutex, MultiSupplier<DictsListPaneConfiguration> configurator) {
        super(configurator, mutex);
        this.selectConfiguration(0);
    }

    @Override
    protected void loadData(ObjIntConsumer<List<DictItem<?>>> callback) throws Exception {
        ValueHolder queryHolder = new ValueHolder();
        FxUtil.waitForFxThread(() -> queryHolder.set(this.buildQuery()));
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        DictService dictService = (DictService)RpcServiceManager.get().getService(DictService.class);
        List searchResult = dictService.search(sic, this.getDictHandler().getDictType(), (DictQuery)queryHolder.get());
        callback.accept(new ArrayList(searchResult), ((DictQuery)queryHolder.get()).getOffset());
    }

    public DictQuery buildQuery() {
        DictQuery result = new DictQuery();
        for (TableColumn col : this.getTableView().getColumns()) {
            if (!col.isVisible() || col.getId() == null) continue;
            result.getFields().add(col.getId());
        }
        String pattern = this.getPatternText();
        if (!TextUtil.isBlank((String)pattern)) {
            pattern = pattern.trim();
            if (!GlobalSettingsService.get().isRestrictedTextSearch() || pattern.length() > 1) {
                result.setPattern(pattern);
            }
        }
        for (Map.Entry<String, SortOrder> entry : this.getSortOrder().entrySet()) {
            if (entry.getValue() == null) continue;
            result.getSorting().put(entry.getKey(), entry.getValue());
        }
        result.getCriterions().addAll(((DictsListPaneConfiguration)this.getConfiguration()).getSearchCriterions());
        for (Map.Entry<String, Object> entry : this.getFiltersData().entrySet()) {
            String fieldId = entry.getKey();
            List values = (List)entry.getValue();
            if (values.size() == 1 && values.get(0) != null) {
                result.getCriterions().add(new DictQuery.SearchCriterion(fieldId, new Object[]{values.get(0)}));
                continue;
            }
            if (values.size() != 2) continue;
            throw Xeption.forDeveloper((String)"unsupported filter {0}", (Object[])new Object[]{fieldId});
        }
        result.setLimit(((DictsListPaneConfiguration)this.getConfiguration()).getLimit());
        result.setOffset(this.getOffset());
        return result;
    }

    @Override
    protected String getQueryInfo() {
        ValueHolder queryHolder = new ValueHolder();
        try {
            FxUtil.waitForFxThread(() -> queryHolder.set(this.buildQuery()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getDictHandler().getDictType().getName() + ' ' + ((DictQuery)queryHolder.get()).toString();
    }

    @Override
    protected Object getItemValue(DictItem<?> item, String columnId) {
        return item.getFields().get(columnId);
    }

    @Override
    protected ActionsPane<?> createActionsPane() {
        ActionsPane<DictsListAction> result = new ActionsPane<DictsListAction>(){

            @Override
            protected boolean isDefault(DictsListAction action) {
                return action.isDefault();
            }

            @Override
            protected boolean isEnabled(DictsListAction action) {
                if (DictsListPane.this.getMutex().isAcquired() || !DictsListPane.this.actionsAcl.contains(action.getId())) {
                    return false;
                }
                return action.isEnabled(DictsListPane.this);
            }

            @Override
            protected void execute(Control source, DictsListAction action, boolean alt) {
                action.execute(source, DictsListPane.this, alt);
            }

            @Override
            protected String getName(DictsListAction action) {
                return action.getName(DictsListPane.this);
            }

            @Override
            protected String getDescription(DictsListAction action) {
                return action.getDescription(DictsListPane.this);
            }

            @Override
            protected ActionIcon getIcon(DictsListAction action) {
                return action.getIcon(DictsListPane.this);
            }
        };
        result.populate(this.collectActions());
        return result;
    }

    protected List<DictsListAction> collectActions() {
        return ClientRegistry.get().allOf(DictsListAction.TYPE).values().stream().filter(action -> action.isAvailable(this)).collect(Collectors.toList());
    }

    @Override
    protected <A extends Action<?>> void executeAction(Control source, A action) {
        DictsListAction dla = (DictsListAction)action;
        if (dla.isEnabled(this)) {
            dla.execute(source, this, false);
        }
    }

    @Override
    protected AclQuery getListACLQuery() {
        return new AclQuery(StandardRestrictionResourceOperations.VIEW.getId(), this.getDictHandler().getDictType().getName());
    }

    public DictHandler<?> getDictHandler() {
        return ((DictsListPaneConfiguration)this.getConfiguration()).getHandler();
    }

    public Consumer<DictionaryModificationEvent> getModificationEventHandler() {
        return this.modificationEventHandler;
    }

    @Override
    protected void newConfigurationPopulated() {
        super.newConfigurationPopulated();
        ActionsPane<?> actionsPane = this.getActionsPane();
        if (actionsPane == null) {
            return;
        }
        this.actionsAcl.clear();
        Notifications.get().submitTask(() -> {
            HashSet<String> enabled = new HashSet<String>();
            HashMap<String, AclQuery> map = new HashMap<String, AclQuery>();
            for (DictsListAction action : this.collectActions()) {
                AclQuery query = action.getACLQuery(this);
                if (query == null) {
                    enabled.add(action.getId());
                    continue;
                }
                map.put(action.getId(), query);
            }
            Set<String> granted = FxAclUtil.applyACL(map);
            this.actionsAcl.clear();
            this.actionsAcl.addAll(enabled);
            this.actionsAcl.addAll(granted);
            FxUtil.submitToFxThread(actionsPane::revalidate);
        }, this.getMutex());
    }

    @Override
    protected void buildConfigurationInfo(StringBuilder buf, DictsListPaneConfiguration config) {
        super.buildConfigurationInfo(buf, config);
        buf.append("Dictionary class: ").append(config.getHandler().getDictType().getName()).append('\n');
        buf.append("Dictionary name: ").append(DictHandler.format(config.getHandler())).append('\n');
        buf.append("Dictionary handler class: ").append(config.getHandler().getClass().getName()).append('\n');
        buf.append("Actions (class, ID, title [flags]):\n");
        for (DictsListAction action : this.collectActions()) {
            buf.append('\t').append(action.getClass().getName()).append('\t').append(action.getId()).append('\t').append(action.getName(this));
            if (!action.isEnabled(this)) {
                buf.append(" [disabled]");
            }
            if (!this.actionsAcl.contains(action.getId())) {
                buf.append(" [forbidden]");
            }
            buf.append('\n');
        }
    }
}

