/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.dicts.list;

import com.gridnine.xtrip.client.fx.core.dicts.DictHandler;
import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.table.ProjectionField;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.list.ListPaneConfiguration;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.meta.DictionaryProperty;
import com.gridnine.xtrip.common.meta.DictionaryType;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.control.SelectionMode;

public class DictsListPaneConfiguration
implements ListPaneConfiguration {
    public static final int DEFAULT_LIMIT = 200;
    private final DictHandler<?> handler;
    private final List<TableColumnSettings> columnsSettings = new ArrayList<TableColumnSettings>();
    private final List<TableColumnSettings> filterSettings = new ArrayList<TableColumnSettings>();
    private final Map<String, SortOrder> sorting = new LinkedHashMap<String, SortOrder>();
    private final List<DictQuery.SearchCriterion> searchCriterions = new ArrayList<DictQuery.SearchCriterion>();
    private SelectionMode selectionMode;
    private boolean patternSearchEnabled;
    private boolean actionsEnabled;
    private int limit = 200;

    private static List<TableColumnSettings> prepareColumnSettings(Class<?> cls, List<TableColumnSettings> columns) {
        ArrayList<TableColumnSettings> result = new ArrayList<TableColumnSettings>(columns.size());
        DictionaryType dictType = MetaRegistryHelper.getDictionaryType((String)cls.getTypeName());
        for (TableColumnSettings origSett : columns) {
            TableColumnSettings newSett = new TableColumnSettings();
            newSett.setId(origSett.getId());
            newSett.setDisplayName(origSett.getDisplayName());
            newSett.setIcon(origSett.getIcon());
            newSett.setPrefWidth(origSett.getPrefWidth());
            newSett.setType(origSett.getType());
            newSett.setRenderer(origSett.getRenderer());
            DictsListPaneConfiguration.fixSettings(newSett, dictType);
            result.add(newSett);
        }
        return result;
    }

    private static void fixSettings(TableColumnSettings sett, DictionaryType dictType) {
        if (BaseDictionary.Property.code.name().equals(sett.getId())) {
            if (sett.getType() == null) {
                sett.setType("String");
            }
            if (sett.getDisplayName() == null) {
                sett.setDisplayName(Messages.General_Code);
            }
            if (sett.getRenderer() == null) {
                sett.setRenderer(StandardRenderers.GENERIC);
            }
            return;
        }
        if (BaseDictionary.Property.codeVariants.name().equals(sett.getId())) {
            if (sett.getType() == null) {
                sett.setType("String");
            }
            if (sett.getDisplayName() == null) {
                sett.setDisplayName(Messages.General_Codes);
            }
            if (sett.getRenderer() == null) {
                sett.setRenderer(StandardRenderers.CODE_VARIANTS);
            }
            return;
        }
        if (BaseDictionary.Property.created.name().equals(sett.getId())) {
            if (sett.getType() == null) {
                sett.setType("java.util.Date");
            }
            if (sett.getDisplayName() == null) {
                sett.setDisplayName(Messages.General_Create_date);
            }
            if (sett.getRenderer() == null) {
                sett.setRenderer(StandardRenderers.DATE_TIME);
            }
            return;
        }
        if (BaseDictionary.Property.createdBy.name().equals(sett.getId())) {
            if (sett.getType() == null) {
                sett.setType("String");
            }
            if (sett.getDisplayName() == null) {
                sett.setDisplayName(Messages.General_Created);
            }
            if (sett.getRenderer() == null) {
                sett.setRenderer(StandardRenderers.GENERIC);
            }
            return;
        }
        if (BaseDictionary.Property.modified.name().equals(sett.getId())) {
            if (sett.getType() == null) {
                sett.setType("java.util.Date");
            }
            if (sett.getDisplayName() == null) {
                sett.setDisplayName(Messages.General_Date_of_change);
            }
            if (sett.getRenderer() == null) {
                sett.setRenderer(StandardRenderers.DATE_TIME);
            }
            return;
        }
        if (BaseDictionary.Property.modifiedBy.name().equals(sett.getId())) {
            if (sett.getType() == null) {
                sett.setType("String");
            }
            if (sett.getDisplayName() == null) {
                sett.setDisplayName(Messages.General_Changed);
            }
            if (sett.getRenderer() == null) {
                sett.setRenderer(StandardRenderers.GENERIC);
            }
            return;
        }
        if (BaseDictionary.Property.spellVariants.name().equals(sett.getId())) {
            if (sett.getType() == null) {
                sett.setType("String");
            }
            if (sett.getDisplayName() == null) {
                sett.setDisplayName(Messages.General_Writing_variants);
            }
            if (sett.getRenderer() == null) {
                sett.setRenderer(StandardRenderers.GENERIC);
            }
            return;
        }
        if (BaseDictionary.Property.translations.name().equals(sett.getId())) {
            if (sett.getType() == null) {
                sett.setType("String");
            }
            if (sett.getDisplayName() == null) {
                sett.setDisplayName(Messages.General_Transactions);
            }
            if (sett.getRenderer() == null) {
                sett.setRenderer(StandardRenderers.TRANSLATIONS);
            }
            return;
        }
        DictionaryProperty prop = (DictionaryProperty)dictType.getProperties().get(sett.getId());
        if (prop != null) {
            if (sett.getType() == null) {
                sett.setType(prop.getType());
            }
            if (sett.getDisplayName() == null) {
                sett.setDisplayName(prop.getDisplayName());
            }
            if (sett.getRenderer() == null) {
                if ("java.util.Date".equals(sett.getType()) && !TextUtil.isBlank((String)prop.getFormat())) {
                    sett.setRenderer(StandardRenderers.DATE_TIME);
                } else if ("time".equalsIgnoreCase(prop.getFormat())) {
                    sett.setRenderer(StandardRenderers.TIME);
                } else {
                    sett.setRenderer(StandardRenderers.guessFor(sett.getType()));
                }
            }
            return;
        }
        EntityCollection coll = (EntityCollection)dictType.getCollections().get(sett.getId());
        if (coll != null) {
            if (sett.getType() == null) {
                sett.setType(coll.getElementType());
            }
            if (sett.getDisplayName() == null) {
                sett.setDisplayName(coll.getDisplayName());
            }
            if (sett.getRenderer() == null) {
                if ("java.util.Date".equals(sett.getType()) && !TextUtil.isBlank((String)coll.getFormat())) {
                    sett.setRenderer(StandardRenderers.DATE_TIME);
                } else if ("time".equalsIgnoreCase(coll.getFormat())) {
                    sett.setRenderer(StandardRenderers.TIME);
                } else {
                    sett.setRenderer(StandardRenderers.guessFor(sett.getType()));
                }
            }
        }
    }

    public DictsListPaneConfiguration(DictHandler<?> dictHandler) {
        this.handler = dictHandler;
    }

    @Override
    public SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(SelectionMode value) {
        this.selectionMode = value;
    }

    @Override
    public boolean isPatternSearchEnabled() {
        return this.patternSearchEnabled;
    }

    public void setPatternSearchEnabled(boolean value) {
        this.patternSearchEnabled = value;
    }

    @Override
    public boolean isActionsEnabled() {
        return this.actionsEnabled;
    }

    public void setActionsEnabled(boolean value) {
        this.actionsEnabled = value;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int value) {
        this.limit = value <= 0 ? 200 : value;
    }

    @Override
    public List<TableColumnSettings> getColumnsSettings() {
        return this.columnsSettings;
    }

    @Override
    public List<TableColumnSettings> getFiltersSettings() {
        return this.filterSettings;
    }

    @Override
    public List<ProjectionField> getProjections() {
        return Collections.emptyList();
    }

    @Override
    public Map<String, SortOrder> getSorting() {
        return this.sorting;
    }

    public DictHandler<?> getHandler() {
        return this.handler;
    }

    public List<DictQuery.SearchCriterion> getSearchCriterions() {
        return this.searchCriterions;
    }

    public void applyParameters(DictListParameters parameters) {
        this.filterSettings.addAll(DictsListPaneConfiguration.prepareColumnSettings(this.handler.getDictType(), parameters.getFilters()));
        this.columnsSettings.addAll(DictsListPaneConfiguration.prepareColumnSettings(this.handler.getDictType(), parameters.getColumns()));
        this.sorting.putAll(parameters.getSortings());
        this.searchCriterions.addAll(parameters.getSearchCriterions());
    }
}

