/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.entity;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItem;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItemType;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;

public interface EntityIndexHandler<E extends BaseEntity, I extends EntityIndex<E>>
extends RegistryItem<EntityIndexHandler<?, ?>> {
    public static final RegistryItemType<EntityIndexHandler<?, ?>> TYPE = new RegistryItemType("ENTITY-INDEX-HANDLER");

    public static EntityIndexHandler<?, ?> forId(String id) {
        return ClientRegistry.get().allOf(TYPE).get(id);
    }

    public static <E extends BaseEntity, I extends EntityIndex<E>> EntityIndexHandler<E, I> forIndexClass(Class<I> indexClass) {
        return EntityIndexHandler.forIndexClass(indexClass.getName());
    }

    public static EntityIndexHandler<?, ?> forIndexClass(String indexClassName) {
        for (EntityIndexHandler<?, ?> handler : ClientRegistry.get().allOf(TYPE).values()) {
            if (!handler.getIndexClass().getName().equals(indexClassName)) continue;
            return handler;
        }
        return null;
    }

    public static String format(EntityIndexHandler<?, ?> handler) {
        String result = ClientRegistry.get().getResourceFor(handler, "name");
        if (result != null) {
            return result;
        }
        IndexType idt = (IndexType)MetaRegistry.get().getIndexes().get(handler.getIndexClass().getName());
        return idt == null ? handler.getId() : idt.getDisplayName();
    }

    @Override
    default public RegistryItemType<EntityIndexHandler<?, ?>> getType() {
        return TYPE;
    }

    @Override
    default public String getId() {
        return this.getIndexClass().getName();
    }

    public Class<I> getIndexClass();

    public IndexListParameters<E, I> createListParameters();

    public boolean isAvaibleInConfiguration();
}

