/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.entity.editor;

import com.gridnine.xtrip.client.fx.core.acl.AclCheckEntry;
import com.gridnine.xtrip.client.fx.core.acl.AppliedAclData;
import com.gridnine.xtrip.client.fx.core.acl.FxAclUtil;
import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.action.ActionsPane;
import com.gridnine.xtrip.client.fx.core.devtools.DevTools;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.RootEntityEditor;
import com.gridnine.xtrip.client.fx.core.entity.RootEntityEditorInterceptor;
import com.gridnine.xtrip.client.fx.core.entity.RootEntityHandler;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.EntityLockHandler;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPaneHandler;
import com.gridnine.xtrip.client.fx.core.entity.raw.RawEntityEditor;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.kb.KeyBindings;
import com.gridnine.xtrip.client.fx.core.kb.ShortcutHandler;
import com.gridnine.xtrip.client.fx.core.kb.StandardKeyBindingActions;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.ViewWalker;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomContextMenu;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomMenuItem;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TilesSpace;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextAreaWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichContentWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichData;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.StandardNotifications;
import com.gridnine.xtrip.client.fx.core.ui.tab.BaseContentPane;
import com.gridnine.xtrip.client.fx.core.ui.tab.ContentError;
import com.gridnine.xtrip.client.fx.core.ui.tab.TabContentWrapper;
import com.gridnine.xtrip.client.fx.core.util.DumpDataUtil;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.Executable;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ModelCheckUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.merge.XMergeHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceOperation;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.HasDraftState;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ReflectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javax.xml.stream.XMLStreamWriter;

public class RootEntityPane<E extends BaseEntity, S>
extends BaseContentPane
implements ShortcutHandler,
RootEntityEditor<E, S> {
    private static final boolean ENFORCE_DRAFT_STATE = "true".equalsIgnoreCase(System.getProperty("client.fx.enforceDraftState"));
    private static final RootEntityPaneHandler PANE_HANDLER = (RootEntityPaneHandler)ReflectionUtil.createBySystemPropertyName((ClassLoader)RootEntityPane.class.getClassLoader(), (String)"client.fx.rootEntityPaneHandler.class", null, () -> new RootEntityPaneHandler(){

        @Override
        public void handleClosing(RootEntityPane<?, ?> pane, Runnable callback) {
            callback.run();
        }

        @Override
        public void handleDraftStateOff(RootEntityPane<?, ?> pane) {
            Dialog.confirm(pane, Messages.General_Is_not_draft_anymore, Messages.General_Doc_will_be_saved, Messages.General_Not_draft_anymore, () -> {
                pane.setDraftStateOff();
                Notifications.get().submitTask(pane::saveData, pane.getMutex());
            }, null);
        }

        @Override
        public void onEditorModeChanged(RootEntityPane<?, ?> pane, EditingMode oldValue, EditingMode newValue) {
        }
    });
    final ReadOnlyObjectWrapper<EditingMode> mode = new ReadOnlyObjectWrapper((Object)EditingMode.CREATE);
    private final ReadOnlyObjectWrapper<EditingMode> previousMode = new ReadOnlyObjectWrapper();
    private final ObservableMutex mutex;
    boolean dataLoaded;
    final Set<String> actionsAcl = new HashSet<String>();
    private final ActionsPane<RootEntityAction> actionsPane = new ActionsPane<RootEntityAction>(){

        @Override
        protected boolean isDefault(RootEntityAction action) {
            return false;
        }

        @Override
        protected boolean isEnabled(RootEntityAction action) {
            if (!RootEntityPane.this.dataLoaded || RootEntityPane.this.getMutex().isAcquired() || !RootEntityPane.this.actionsAcl.contains(action.getId())) {
                return false;
            }
            return action.isEnabled(RootEntityPane.this);
        }

        @Override
        protected void execute(Control source, RootEntityAction action, boolean alt) {
            action.execute(source, RootEntityPane.this, alt);
        }

        @Override
        protected String getName(RootEntityAction action) {
            return action.getName(RootEntityPane.this);
        }

        @Override
        protected String getDescription(RootEntityAction action) {
            return action.getDescription(RootEntityPane.this);
        }

        @Override
        protected ActionIcon getIcon(RootEntityAction action) {
            return action.getIcon(RootEntityPane.this);
        }
    };
    private final SimpleStringProperty title = new SimpleStringProperty((Object)this, "title");
    private final SimpleStringProperty description = new SimpleStringProperty((Object)this, "description");
    private final RootEntityHandler<E, S> entityHandler;
    private final String containerUid;
    private final Integer fixedVersionNumber;
    private final ViewController<?, DataTransferPackage<E, S>> controller;
    private final StackPane contentPane;
    private final EntityLockHandler lockHandler;
    private final Label caption = new Label();
    final SimpleBooleanProperty modControlsDisabled = new SimpleBooleanProperty();
    private ViewController<?, DataTransferPackage<E, S>> adminController;
    private ToggleButton modeButton;
    private final SimpleBooleanProperty draftState = new SimpleBooleanProperty();
    private Label draftStateLabel;
    private boolean readOnlyState;
    private DataTransferPackage<E, S> data;
    private boolean saveWithCheckPoint = true;
    private ModelCheckUtil.CheckFailedException loadingExc;
    private final Consumer<EntityModificationEvent> modificationEventHandler = evt -> {
        if (this == evt.getSource() || evt.getModifications().isEmpty()) {
            return;
        }
        FxUtil.runInFxThread(() -> {
            for (EntityModification mod : evt.getModifications()) {
                if (!this.getContainerUid().equals(mod.getReference().getUid())) continue;
                if (mod.getType() == EntityModification.ModificationType.CHANGE) {
                    if (this.getMode() != EditingMode.VIEW && this.isDataChanged()) {
                        new Dialog().setTitle(Messages.General_Accepting_required).setMessage(Messages.General_Is_doc_data_refresh_required).setSupplmentalMessage(Messages.General_Doc_changed_warning).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.General_Refresh, () -> Notifications.get().submitTask(this::reloadData, this.getMutex())).show((Node)this);
                    } else {
                        Notifications.get().submitTask(this::reloadData, this.getMutex());
                    }
                }
                return;
            }
        });
    };
    private boolean dataLoadFailed;
    private InvalidationListener acquiredListener;
    private Button reloadButton;
    private List<AclCheckEntry> lastUiAclCheck;
    private Map<String, Boolean> lastEntityAclCheck;
    private final List<AclCheckEntry> lastActionsAclCheck = new ArrayList<AclCheckEntry>();

    public static RootEntityPane<?, ?> lookup(Node node) {
        Node result = UiUtil.lookupNode(node, candidate -> candidate instanceof RootEntityPane || candidate instanceof TabContentWrapper);
        if (result == null) {
            return null;
        }
        if (result instanceof TabContentWrapper) {
            result = ((TabContentWrapper)result).getContent();
        }
        return result instanceof RootEntityPane ? (RootEntityPane)result : null;
    }

    public static void executeAsyncAction(RootEntityPane<?, ?> pane, Executable action) {
        EntityContainer ctr = pane.getData().getContainer();
        if (ctr != null && pane.getMode() == EditingMode.VIEW) {
            Notifications.get().submitTask(() -> {
                pane.lockHandler.tryLock(ctr.getVersionInfo().getVersionNumber());
                FxUtil.submitToFxThread(pane::updateLockState);
                if (pane.lockHandler.isLocked()) {
                    action.execute();
                    EventBus.get().publishAsync(new EntityModificationEvent(null, new EntityModification(ctr.toReference(), EntityModification.ModificationType.CHANGE)));
                }
            }, pane.getMutex());
            return;
        }
        if (!pane.isDataChanged()) {
            Notifications.get().submitTask(() -> {
                action.execute();
                if (ctr != null) {
                    EventBus.get().publishAsync(new EntityModificationEvent(null, new EntityModification(ctr.toReference(), EntityModification.ModificationType.CHANGE)));
                }
            }, pane.getMutex());
            return;
        }
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.General_Accepting_required).setMessage(Messages.General_Redactor_contains_unsaved_data).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.AUXILARY, Messages.General_Continue_without_saving, () -> Notifications.get().submitTask(() -> {
            action.execute();
            if (ctr != null) {
                EventBus.get().publishAsync(new EntityModificationEvent(null, new EntityModification(ctr.toReference(), EntityModification.ModificationType.CHANGE)));
            }
        }, pane.getMutex())).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.General_Save_and_continue, () -> {
            if (!pane.validate()) {
                return;
            }
            Notifications.get().submitTask(() -> {
                pane.saveData();
                action.execute();
                if (ctr != null) {
                    EventBus.get().publishAsync(new EntityModificationEvent(null, new EntityModification(ctr.toReference(), EntityModification.ModificationType.CHANGE)));
                }
            }, pane.getMutex());
        }).show((Node)pane);
    }

    public static void executeAction(RootEntityPane<?, ?> pane, Runnable action) {
        if (pane.getMode() == EditingMode.VIEW) {
            Notifications.get().submitTask(() -> {
                pane.lockHandler.tryLock(pane.data.getContainer().getVersionInfo().getVersionNumber());
                FxUtil.submitToFxThread(() -> {
                    pane.updateLockState();
                    if (pane.lockHandler.isLocked()) {
                        action.run();
                    }
                });
            }, pane.getMutex());
            return;
        }
        if (!pane.isDataChanged()) {
            action.run();
            return;
        }
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.General_Accepting_required).setMessage(Messages.General_Redactor_contains_unsaved_data).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.AUXILARY, Messages.General_Continue_without_saving, () -> action.run()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.General_Save_and_continue, () -> {
            if (!pane.validate()) {
                return;
            }
            Notifications.get().submitTask(() -> {
                pane.saveData();
                FxUtil.submitToFxThread(action);
            }, pane.getMutex());
        }).show((Node)pane);
    }

    public RootEntityPane(ObservableMutex mtx, RootEntityHandler<E, S> ettHandler, EditingMode editingMode, String ctrUid, int versionNumber) {
        this(mtx, ettHandler, new EntityLockHandler(){

            @Override
            public void unLock() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void tryLock(int version) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isLocked() {
                return false;
            }
        }, editingMode, ctrUid, versionNumber);
    }

    public RootEntityPane(ObservableMutex mtx, RootEntityHandler<E, S> ettHandler, EntityLockHandler lkHandler, EditingMode editingMode, String ctrUid) {
        this(mtx, ettHandler, lkHandler, editingMode, ctrUid, null);
    }

    private RootEntityPane(ObservableMutex mtx, RootEntityHandler<E, S> ettHandler, EntityLockHandler lkHandler, EditingMode editingMode, String ctrUid, Integer versionNumber) {
        this.mutex = mtx;
        this.entityHandler = Objects.requireNonNull(ettHandler);
        this.lockHandler = Objects.requireNonNull(lkHandler);
        this.containerUid = Objects.requireNonNull(ctrUid);
        this.fixedVersionNumber = versionNumber;
        this.mode.set((Object)editingMode);
        this.dataLoaded = editingMode == EditingMode.CREATE;
        this.getStyleClass().add((Object)"xtrip-editor-pane");
        this.controller = this.entityHandler.createEditorController(this.mode.get() == EditingMode.VIEW);
        this.contentPane = new StackPane();
        this.initView();
        this.actionsPane.populate(this.getActions());
        this.acquiredListener = obj -> this.updateState();
        this.mutex.acquiredProperty().addListener(this.acquiredListener);
        this.composePane((Node)this.contentPane, this.buildHeader(), this.actionsPane, null);
        if (this.fixedVersionNumber != null) {
            this.disableModeControls(true);
        }
        this.updateState();
        ViewController vc = this.getViewController();
        String viewId = vc.getView().getClass().getName();
        String aclRes = FxAclUtil.getUiAclResource(viewId);
        Notifications.get().submitTask(() -> {
            AppliedAclData.loadForMetaBasedUI(aclData -> vc.enforceAcl((AppliedAclData)aclData, aclRes), viewId);
            this.reloadActionsACL();
        }, mtx);
    }

    @Override
    public void dispose() {
        this.modeButton.disableProperty().unbind();
        this.reloadButton.disableProperty().unbind();
        this.mutex.acquiredProperty().removeListener(this.acquiredListener);
        super.dispose();
    }

    @Override
    public void handleShortcut(KeyEvent event) {
        if (this.mutex.isAcquired()) {
            return;
        }
        KeyBindings kb = KeyBindings.get();
        if (kb.getKeyCombination(StandardKeyBindingActions.RELOAD).match(event)) {
            this.doReload();
            event.consume();
        } else if (kb.getKeyCombination(StandardKeyBindingActions.VIEW).match(event) && this.modeButton.isSelected() || kb.getKeyCombination(StandardKeyBindingActions.EDIT).match(event) && !this.modeButton.isSelected()) {
            if (!this.modeButton.isDisabled()) {
                this.modeButton.fire();
                event.consume();
            }
        } else {
            this.actionsPane.handleShortcut(event);
        }
    }

    public Node getEditor() {
        return this.controller.getView();
    }

    private ViewController<?, DataTransferPackage<E, S>> getViewController() {
        return this.adminController != null ? this.adminController : this.controller;
    }

    public void reloadData() {
        if (this.mode.get() == EditingMode.CREATE || this.isDisposed()) {
            this.dataLoaded = true;
            return;
        }
        long timing = System.currentTimeMillis();
        try {
            Map permissions;
            DataTransferPackage dtp;
            DataTransferPackage restoredDtp;
            this.dataLoaded = false;
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            HashMap<String, AclQuery> map = new HashMap<String, AclQuery>();
            String uiAclRes = FxAclUtil.getUiAclResource(this.getViewController().getView().getClass().getName());
            map.put("view-ui", AclQuery.AclQueryBuilder.get().entry(StandardRestrictionResourceOperations.VIEW.getId(), uiAclRes).build());
            map.put("edit-ui", AclQuery.AclQueryBuilder.get().entry(StandardRestrictionResourceOperations.EDIT.getId(), uiAclRes).build());
            Set<String> grantedIds = FxAclUtil.applyACL(map);
            this.lastUiAclCheck = FxAclUtil.asCheckEntries(map, grantedIds);
            if (!grantedIds.contains("view-ui")) {
                this.handleNotGrantedView();
                return;
            }
            if (!grantedIds.contains("edit-ui")) {
                this.handleNotGrantedEdit();
            }
            DataTransferPackage dataTransferPackage = restoredDtp = this.modControlsDisabled.get() ? null : this.restoreEditorState();
            if (restoredDtp != null) {
                dtp = restoredDtp;
                permissions = FxAclUtil.applyACL(dtp.getContainer().getEntityType(), dtp.getContainer().getUid(), dtp.getContainer().getVersionInfo().getVersionNumber());
                this.lastEntityAclCheck = permissions;
            } else {
                EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                Class<S> supplementClass = Void.class.isAssignableFrom(this.entityHandler.getSupplementClass()) ? null : this.entityHandler.getSupplementClass();
                MiscUtil.Pair dtpAndPermissions = entityService.loadWithPermissions(sic, this.entityHandler.getEntityClass(), this.containerUid, this.fixedVersionNumber, supplementClass);
                dtp = (DataTransferPackage)dtpAndPermissions.getFirst();
                this.lastEntityAclCheck = permissions = (Map)dtpAndPermissions.getSecond();
                if (this.fixedVersionNumber == null && dtp.getContainer() != null) {
                    try {
                        ModelCheckUtil.check(dtp.getContainer().getEntity());
                    }
                    catch (ModelCheckUtil.CheckFailedException cfe) {
                        this.loadingExc = cfe;
                    }
                }
            }
            if (dtp.getContainer() == null) {
                FxUtil.waitForFxThread(() -> this.handleLoadError(ContentError.NOT_FOUND));
            } else {
                for (RootEntityEditorInterceptor<E, S> interceptor : this.entityHandler.getEditorInterceptors()) {
                    interceptor.beforeLoad(dtp);
                    if (this.isReadOnlyState() || !interceptor.isReadOnly(dtp)) continue;
                    this.readOnlyState = true;
                }
                if (Boolean.FALSE.equals(permissions.get(AclHelper.createPermission((String)dtp.getContainer().getEntity().getUid(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW)))) {
                    this.handleNotGrantedView();
                    return;
                }
                boolean editPermissionsChecked = permissions.keySet().stream().anyMatch(permission -> AclHelper.isForOperation((String)permission, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
                boolean anyEditPermissionGranted = permissions.entrySet().stream().anyMatch(entry -> (Boolean)entry.getValue() != false && AclHelper.isForOperation((String)((String)entry.getKey()), (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
                if (editPermissionsChecked && !anyEditPermissionGranted || this.isReadOnlyState()) {
                    this.handleNotGrantedEdit();
                }
                FxUtil.waitForFxThread(() -> {
                    if (this.previousMode.get() != this.mode.get()) {
                        PANE_HANDLER.onEditorModeChanged(this, (EditingMode)((Object)((Object)this.previousMode.get())), (EditingMode)((Object)((Object)this.mode.get())));
                    }
                    this.readData(dtp, permissions);
                });
            }
            this.reloadActionsACL();
            if (dtp.getContainer() != null) {
                for (RootEntityEditorInterceptor<E, S> interceptor : this.entityHandler.getEditorInterceptors()) {
                    interceptor.onLoad((DataTransferPackage<E, S>)dtp, (Node)this.controller.getView());
                }
                if (restoredDtp != null) {
                    this.lockHandler.tryLock(dtp.getContainer().getVersionInfo().getVersionNumber());
                    FxUtil.submitToFxThread(this::updateLockState);
                    Dialog.info((Node)this, Messages.Editor_state_restored_notification);
                }
            }
            this.dataLoaded = true;
        }
        catch (Exception e) {
            ErrorHandler.handle(e);
        }
        MiscUtil.logTiming((long)timing, (String)String.format("reloadData() for {%s:%s}", this.entityHandler.getEntityClass().getName(), this.containerUid));
    }

    private void handleNotGrantedView() {
        FxUtil.submitToFxThread(() -> this.handleLoadError(ContentError.ACCESS_DENIED));
    }

    private void handleNotGrantedEdit() throws Exception {
        FxUtil.waitForFxThread(() -> {
            this.modControlsDisabled.set(true);
            this.modeButton.setSelected(false);
            if (this.mode.get() != EditingMode.VIEW) {
                this.mode.set((Object)EditingMode.VIEW);
                Notifications.get().showFlashNotification(Messages.REP_Editing_not_allowed, null);
            }
            this.updateState();
        });
    }

    private void reloadActionsACL() throws Exception {
        HashSet<String> enabled = new HashSet<String>();
        HashMap<String, AclQuery> map = new HashMap<String, AclQuery>();
        for (RootEntityAction action : this.getActions()) {
            AclQuery query = action.getACLQuery(this);
            if (query == null) {
                enabled.add(action.getId());
                continue;
            }
            map.put(action.getId(), query);
        }
        Set<String> granted = FxAclUtil.applyACL(map);
        this.lastActionsAclCheck.clear();
        this.lastActionsAclCheck.addAll(FxAclUtil.asCheckEntries(map, granted));
        this.actionsAcl.clear();
        this.actionsAcl.addAll(enabled);
        this.actionsAcl.addAll(granted);
    }

    public void disableModeControls(boolean disable) {
        this.modControlsDisabled.set(disable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveData() throws Exception {
        if (this.fixedVersionNumber != null) {
            throw new UnsupportedOperationException();
        }
        try {
            Map permissions;
            DataTransferPackage editedData;
            long timing = System.currentTimeMillis();
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
            VersionInfo editedVersionInfo = null;
            DataTransferPackage currentData = null;
            if (this.data != null && this.data.getContainer() != null) {
                if (this.mode.get() != EditingMode.CREATE) {
                    currentData = entityService.load(sic, this.data.getContainer().getEntityType(), this.data.getContainer().getUid(), Void.class.isAssignableFrom(this.entityHandler.getSupplementClass()) ? null : this.entityHandler.getSupplementClass());
                    if (currentData == null || this.data.getContainer() == null) {
                        throw Xeption.forEndUser((String)Messages.General_Doc_unfound, (Object[])new Object[0]);
                    }
                    if (!MiscUtil.equals((Object)this.data.getContainer().getRevision(), (Object)currentData.getContainer().getRevision())) {
                        editedData = new DataTransferPackage((EntityContainer)this.data.getContainer().clone(false, Collections.emptyMap()), this.data.getSupplement());
                    } else {
                        currentData = null;
                        editedData = this.data;
                    }
                } else {
                    editedData = this.data;
                }
            } else {
                Iterator<RootEntityEditorInterceptor<E, S>> supplement = null;
                if (this.entityHandler.getSupplementClass() != null && this.entityHandler.getSupplementClass() != Void.class) {
                    supplement = (Iterator<RootEntityEditorInterceptor<E, S>>)this.entityHandler.getSupplementClass().newInstance();
                }
                editedData = new DataTransferPackage(new EntityContainer(this.entityHandler.getEntityClass(), this.containerUid), supplement);
            }
            for (RootEntityEditorInterceptor<E, S> interceptor : this.entityHandler.getEditorInterceptors()) {
                if (interceptor.onSave((DataTransferPackage<E, S>)editedData, (Node)this.controller.getView())) continue;
                StandardNotifications.SAVE_INTERRUPTED.show(editedData.getContainer().getEntity().toString());
                return;
            }
            FxUtil.waitForFxThread(() -> this.writeData(editedData));
            try {
                ModelCheckUtil.check(editedData.getContainer().getEntity());
            }
            catch (ModelCheckUtil.CheckFailedException cfe) {
                if (this.loadingExc != null) {
                    if (this.loadingExc.getEntityUid() != null && this.loadingExc.getEntityUid().equals(cfe.getEntityUid())) {
                        throw Xeption.forDeveloper((String)"same fatal error while saving data as when loading for {0}, duplicate object with UID {1} and type {2} found", (Object[])new Object[]{this.data.getContainer(), TextUtil.isBlank((String)cfe.getEntityUid()) ? "EMPTY" : cfe.getEntityUid(), cfe.getEntityType().getName()});
                    }
                    throw Xeption.forDeveloper((String)"fatal errors while saving and loading data for {0}, duplicate object (while loading) with UID {1} and type {2} found, duplicate object (while saving) with UID {3} and type {4} found", (Object[])new Object[]{this.data.getContainer(), TextUtil.isBlank((String)this.loadingExc.getEntityUid()) ? "EMPTY" : cfe.getEntityUid(), this.loadingExc.getEntityType().getName(), TextUtil.isBlank((String)cfe.getEntityUid()) ? "EMPTY" : cfe.getEntityUid(), cfe.getEntityType().getName()});
                }
                throw Xeption.forDeveloper((String)"fatal error while saving data for {0}, duplicate object with UID {1} and type {2} found", (Object[])new Object[]{this.data.getContainer(), TextUtil.isBlank((String)cfe.getEntityUid()) ? "EMPTY" : cfe.getEntityUid(), cfe.getEntityType().getName()});
            }
            if (currentData != null) {
                try {
                    XMergeHelper.mergeEntity((BaseEntity)this.data.getContainer().getEntity(), (BaseEntity)currentData.getContainer().getEntity(), (BaseEntity)editedData.getContainer().getEntity());
                    editedVersionInfo = new VersionInfo(currentData.getContainer().getVersionInfo().getUid());
                    editedVersionInfo.copyFrom((BaseEntity)currentData.getContainer().getVersionInfo(), false, Collections.emptyMap());
                    this.saveWithCheckPoint = true;
                }
                catch (XMergeHelper.MergeConflictException mce) {
                    File file = DumpDataUtil.newFile(DumpDataUtil.DataKind.MERGE_CONFLICT_DATA);
                    try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(new FileOutputStream(file)), Charset.forName("utf-8")));
                         XMLStreamWriter writer = XSUtil.wrapForPrettyPrinting((XMLStreamWriter)XSUtil.getXMLOutputFactory().createXMLStreamWriter(out));){
                        writer.writeStartElement("merge-conflict");
                        writer.writeAttribute("container-uid", this.data.getContainer().getUid());
                        RootEntityPane.writeContainerData(writer, "base", this.data.getContainer());
                        RootEntityPane.writeContainerData(writer, "mine", editedData.getContainer());
                        RootEntityPane.writeContainerData(writer, "theirs", currentData.getContainer());
                        writer.writeEndElement();
                    }
                    catch (Exception e) {
                        ErrorHandler.handle(e);
                    }
                    throw Xeption.forEndUser((String)Messages.getREP_Unmergable_Conflict(file), (Throwable)mce, (Object[])new Object[0]);
                }
            }
            if (editedVersionInfo == null && this.data != null && this.data.getContainer() != null && this.data.getContainer().getVersionInfo() != null) {
                editedVersionInfo = new VersionInfo(this.data.getContainer().getVersionInfo().getUid());
                editedVersionInfo.copyFrom((BaseEntity)this.data.getContainer().getVersionInfo(), false, Collections.emptyMap());
            }
            DataTransferPackage toBeSavedData = currentData != null ? currentData : editedData;
            this.saveWithCheckPoint = this.saveWithCheckPoint || !MiscUtil.equals((Object)"fx-editor", (Object)toBeSavedData.getContainer().getVersionInfo().getDataSource());
            this.updateContainer(toBeSavedData.getContainer());
            MiscUtil.Pair savedDataAndPermissions = entityService.saveWithPermissions(sic, toBeSavedData, editedVersionInfo, this.saveWithCheckPoint);
            DataTransferPackage savedData = (DataTransferPackage)savedDataAndPermissions.getFirst();
            this.lastEntityAclCheck = permissions = (Map)savedDataAndPermissions.getSecond();
            this.saveWithCheckPoint = false;
            FxUtil.waitForFxThread(() -> {
                this.readData(savedData, permissions);
                if (this.mode.get() == EditingMode.CREATE) {
                    this.previousMode.setValue(this.mode.getValue());
                    this.mode.set((Object)EditingMode.EDIT);
                    Notifications.get().submitTask(() -> {
                        this.lockHandler.tryLock(this.data.getContainer().getVersionInfo().getVersionNumber());
                        FxUtil.submitToFxThread(this::updateLockState);
                    }, this.mutex);
                }
            });
            this.reloadActionsACL();
            StandardNotifications.SAVED.show(savedData.getContainer().getEntity().toString());
            EventBus.get().publishAsync(new EntityModificationEvent((Object)this, new EntityModification(savedData.getContainer().toReference(), EntityModification.ModificationType.CHANGE)));
            MiscUtil.logTiming((long)timing, (String)String.format("saveData() for {%s:%s}", this.entityHandler.getEntityClass().getName(), this.containerUid));
            FxUtil.submitToFxThread(() -> {
                for (RootEntityEditorInterceptor<E, S> interceptor : this.entityHandler.getEditorInterceptors()) {
                    interceptor.afterSave((DataTransferPackage<E, S>)savedData, (Node)this.controller.getView());
                }
            });
        }
        catch (Exception e) {
            ServiceException se;
            if (ErrorHandler.isVersionMismatchError(e)) {
                this.saveEditorState();
                Dialog.info((Node)this, Messages.Editor_state_saved_notification);
            }
            if (e instanceof ServiceException && ((se = (ServiceException)e).isForUser() || se.isForAdmin())) {
                ArrayList<Message> messages = new ArrayList<Message>();
                messages.add(MessagesHelper.createMessageWithDetails((MessageType)MessageType.ERROR, (String)se.getUserMessage(), (String)se.getDetails(), (Object[])new Object[0]));
                FxUtil.submitToFxThread(() -> ((TilesSpace)this.contentPane.getChildren().get(0)).setMessages(messages));
                return;
            }
            throw e;
        }
    }

    private static void writeContainerData(XMLStreamWriter writer, String name, EntityContainer<?> ctr) throws Exception {
        writer.writeStartElement(name);
        writer.writeAttribute("revision", Objects.toString(ctr.getRevision()));
        writer.writeAttribute("created", Objects.toString(ctr.getVersionInfo().getCreated()));
        writer.writeAttribute("modified", Objects.toString(ctr.getVersionInfo().getModified()));
        writer.writeAttribute("created-by", Objects.toString(ctr.getVersionInfo().getCreatedBy()));
        writer.writeAttribute("modified-by", Objects.toString(ctr.getVersionInfo().getModifiedBy()));
        writer.writeAttribute("version-number", Integer.toString(ctr.getVersionInfo().getVersionNumber()));
        writer.writeAttribute("data-source", Objects.toString(ctr.getVersionInfo().getDataSource()));
        writer.writeAttribute("version-notes", Objects.toString(ctr.getVersionInfo().getDataSource()));
        writer.writeAttribute("data-size", Integer.toString(ctr.getVersionInfo().getDataSize()));
        ctr.getEntity().toXML(writer);
        writer.writeEndElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private DataTransferPackage<E, S> restoreEditorState() {
        if (this.containerUid == null) {
            return null;
        }
        File file = new File(Environment.getDataFolder(), "editor-state-" + this.containerUid);
        if (!file.isFile()) {
            return null;
        }
        try {
            DataTransferPackage dataTransferPackage;
            Throwable throwable;
            ObjectInputStream in;
            block21: {
                block22: {
                    in = new ObjectInputStream(new FileInputStream(file));
                    throwable = null;
                    dataTransferPackage = (DataTransferPackage)in.readObject();
                    if (in == null) break block21;
                    if (throwable == null) break block22;
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block21;
                }
                in.close();
            }
            return dataTransferPackage;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (in != null) {
                            if (throwable != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                in.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (InvalidClassException ice) {
                    Dialog.info((Node)this, Messages.Editor_state_restore_failed);
                    throwable = null;
                    return throwable;
                }
                catch (Exception e) {
                    ErrorHandler.handle(e);
                }
            }
        }
        finally {
            file.delete();
        }
        return null;
    }

    private void saveEditorState() {
        try {
            DataTransferPackage dataToSave;
            if (this.data != null && this.data.getContainer() != null) {
                dataToSave = this.data;
            } else {
                Object supplement = null;
                if (this.entityHandler.getSupplementClass() != null && this.entityHandler.getSupplementClass() != Void.class) {
                    supplement = this.entityHandler.getSupplementClass().newInstance();
                }
                dataToSave = new DataTransferPackage(new EntityContainer(this.entityHandler.getEntityClass(), this.containerUid), supplement);
            }
            FxUtil.waitForFxThread(() -> this.writeData(dataToSave));
            File file = new File(Environment.getDataFolder(), "editor-state-" + this.containerUid);
            try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));){
                out.writeObject(dataToSave);
            }
        }
        catch (Exception e) {
            ErrorHandler.handle(e);
        }
    }

    private void updateContainer(EntityContainer<E> ctr) {
        if (this.saveWithCheckPoint) {
            ctr.getVersionInfo().setCreated(null);
            ctr.getVersionInfo().setCreatedBy(null);
            ctr.getVersionInfo().setUid(null);
        }
        ctr.setModified(null);
        ctr.setModifiedBy(null);
        ctr.getVersionInfo().setModified(null);
        ctr.getVersionInfo().setModifiedBy(null);
        ctr.getVersionInfo().setDataSource("fx-editor");
        ctr.getVersionInfo().setVersionNotes(this.adminController == null ? "UI editing mode" : "raw XML editing mode");
    }

    public boolean validate() {
        ArrayList<Message> messages = new ArrayList<Message>();
        this.validateData(messages);
        ((TilesSpace)this.contentPane.getChildren().get(0)).setMessages(messages);
        if (!MessagesHelper.hasErrorMessage(messages)) {
            return true;
        }
        StandardNotifications.VALIDATION_FAILED.show(null);
        return false;
    }

    public ObservableMutex getMutex() {
        return this.mutex;
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public StringProperty descriptionProperty() {
        return this.description;
    }

    public boolean isLastVersion() {
        return this.fixedVersionNumber == null;
    }

    public Integer getFixedVersionNumber() {
        return this.fixedVersionNumber;
    }

    public RootEntityHandler<E, S> getEntityHandler() {
        return this.entityHandler;
    }

    public void tryLock(int version) throws Exception {
        if (this.lockHandler.isLocked()) {
            return;
        }
        this.lockHandler.tryLock(version);
        FxUtil.submitToFxThread(this::updateLockState);
    }

    public String getContainerUid() {
        return this.containerUid;
    }

    public ReadOnlyObjectProperty<EditingMode> modeProperty() {
        return this.mode.getReadOnlyProperty();
    }

    public EditingMode getMode() {
        return (EditingMode)((Object)this.mode.get());
    }

    @Override
    public DataTransferPackage<E, S> getLoadedData() {
        return this.data;
    }

    public DataTransferPackage<E, S> getData() {
        return this.data;
    }

    public boolean isDraftState() {
        return this.draftState.get();
    }

    public void setDraftStateOff() {
        this.draftState.set(false);
    }

    public boolean isReadOnlyState() {
        return this.readOnlyState;
    }

    public void handleClosing(Runnable callback) {
        PANE_HANDLER.handleClosing(this, callback);
    }

    public Consumer<EntityModificationEvent> getModificationEventHandler() {
        return this.modificationEventHandler;
    }

    public void readData(DataTransferPackage<E, S> model, Map<String, Boolean> preloadedPermissions) {
        if (this.isDisposed()) {
            return;
        }
        long timing = System.currentTimeMillis();
        this.data = model;
        if (model.getContainer().getEntity() instanceof HasDraftState) {
            this.draftState.set(this.mode.get() == EditingMode.CREATE && ENFORCE_DRAFT_STATE || ((HasDraftState)this.data.getContainer().getEntity()).isDraftState());
        } else {
            this.draftState.set(false);
        }
        this.updateTitle(model.getContainer());
        ViewController viewController = this.getViewController();
        ViewWalker.saveState(viewController.getView());
        if (viewController.isAwareOfControllersRegistry()) {
            viewController.readData(model);
        } else {
            ControllersRegistry.beforeReadData(viewController, model);
            viewController.readData(model);
            ControllersRegistry.afterReadData(viewController, model);
        }
        FxUtil.submitToFxThread(() -> ViewWalker.restoreState(viewController.getView()));
        if (preloadedPermissions != null) {
            Set<String> deniedPermissions = preloadedPermissions.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toSet());
            viewController.enforceDataAcl(viewController, deniedPermissions);
        } else if (viewController.isDataAclEnforceable()) {
            Notifications.get().submitTask(() -> {
                Map<String, Boolean> permissions = FxAclUtil.applyACL(model.getContainer().getEntityType(), model.getContainer().getUid(), model.getContainer().getVersionInfo().getVersionNumber());
                this.lastEntityAclCheck = permissions;
                Set deniedPermissions = permissions.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toSet());
                FxUtil.submitToFxThread(() -> viewController.enforceDataAcl(viewController, deniedPermissions));
            }, this.getMutex());
        }
        MiscUtil.logTiming((long)timing, (String)String.format("readData() for {%s:%s}", this.entityHandler.getEntityClass().getName(), this.containerUid));
    }

    public void writeData(DataTransferPackage<E, S> model) {
        ViewController<?, DataTransferPackage<E, S>> viewController;
        long timing = System.currentTimeMillis();
        if (model.getContainer().getEntity() instanceof HasDraftState) {
            ((HasDraftState)model.getContainer().getEntity()).setDraftState(this.draftState.get());
        }
        if ((viewController = this.getViewController()).isAwareOfControllersRegistry()) {
            viewController.writeData(model);
        } else {
            ControllersRegistry.beforeWriteData(viewController, model);
            viewController.writeData(model);
            ControllersRegistry.afterWriteData(viewController, model);
        }
        MiscUtil.logTiming((long)timing, (String)String.format("writeData() for {%s:%s}", this.entityHandler.getEntityClass().getName(), this.containerUid));
    }

    public void revalidateActions() {
        this.actionsPane.revalidate();
    }

    private void setReadonly(boolean readonly) {
        this.getViewController().setReadonly(readonly);
    }

    public boolean isDataChanged() {
        return !this.dataLoadFailed && this.getViewController().isDataChanged();
    }

    private void validateData(List<Message> messages) {
        ViewController<?, DataTransferPackage<E, S>> viewController = this.getViewController();
        if (!viewController.isAwareOfControllersRegistry()) {
            ControllersRegistry.validateData(viewController, messages);
        }
        viewController.validateData(messages);
    }

    private List<RootEntityAction> getActions() {
        return ClientRegistry.get().allOf(RootEntityAction.TYPE).values().stream().filter(action -> action.isAvailable(this)).collect(Collectors.toList());
    }

    private void initView() {
        this.getViewController().setReadonly(this.mode.get() == EditingMode.VIEW);
        Object view = this.getViewController().getView();
        if (view instanceof TilesSpace) {
            this.contentPane.getChildren().setAll((Object[])new Node[]{view});
        } else {
            this.contentPane.getChildren().setAll((Object[])new Node[]{new TilesSpace(1, (Node)view){
                final /* synthetic */ Node val$view;
                {
                    this.val$view = node;
                    super(columns);
                    this.addTiles(new Tile<Object, Node>("main", RootEntityHandler.format(RootEntityPane.this.getEntityHandler()), null, this.val$view));
                }
            }});
        }
    }

    private Node buildHeader() {
        ArrayList<Object> nodes = new ArrayList<Object>();
        GridPane.setHgrow((Node)this.caption, (Priority)Priority.ALWAYS);
        this.caption.textProperty().bind((ObservableValue)this.description);
        this.caption.setGraphic((Node)new IconNode(this.mode.get() == EditingMode.VIEW ? StandardIconShapes.ROOT_VIEW_12x12 : StandardIconShapes.ROOT_EDIT_12x12, (Styleable)this.caption, StandardIconIntentions.ROOT_MODE_CAPTION_ACTION, (Styleable)this.caption));
        nodes.add(this.caption);
        this.draftStateLabel = new Label(Messages.General_Draft);
        this.draftStateLabel.getStyleClass().add((Object)"draft");
        FxUtil.addListener(this.draftState, (s, o, n) -> this.updateDraftState());
        nodes.add(this.draftStateLabel);
        Object view = this.getViewController().getView();
        if (view instanceof TilesSpace && ((TilesSpace)view).getTiles().size() > 1) {
            Button button = new Button();
            button.setGraphic((Node)new IconNode(StandardIconShapes.ROOT_SETTINGS_12x12, (Styleable)button, StandardIconIntentions.BASIC_BUTTON_ACTION, (Styleable)button));
            button.getStyleClass().add((Object)"xtrip-button");
            UiUtil.setTooltip((Node)button, Messages.General_Doc_view_settings);
            button.setOnAction(evt -> {
                if (view instanceof TilesSpace) {
                    ((TilesSpace)view).showConfigurationPane((Region)button);
                }
            });
            nodes.add(button);
        }
        this.reloadButton = new Button();
        this.reloadButton.setGraphic((Node)new IconNode(StandardIconShapes.RELOAD_12x12, (Styleable)this.reloadButton, StandardIconIntentions.BASIC_BUTTON_ACTION, (Styleable)this.reloadButton));
        this.reloadButton.getStyleClass().add((Object)"xtrip-button");
        UiUtil.setTooltip((Node)this.reloadButton, Messages.General_Doc_data_refresh);
        this.reloadButton.disableProperty().bind((ObservableValue)new BooleanBinding(){
            {
                this.bind(new Observable[]{RootEntityPane.this.mode, RootEntityPane.this.getMutex().acquiredProperty()});
            }

            protected boolean computeValue() {
                return RootEntityPane.this.mode.get() == EditingMode.CREATE || RootEntityPane.this.getMutex().isAcquired();
            }
        });
        this.reloadButton.setOnAction(evt -> this.doReload());
        nodes.add(this.reloadButton);
        SimpleStringProperty tooltipText = new SimpleStringProperty(Messages.General_Go_to_edit_mode);
        this.modeButton = new ToggleButton(Messages.General_Editor);
        this.modeButton.getStyleClass().addAll((Object[])new String[]{"xtrip-button", "xtrip-toggle-button"});
        this.modeButton.setGraphic((Node)new IconNode(StandardIconShapes.ROOT_EDIT_12x12, (Styleable)this.modeButton, StandardIconIntentions.ROOT_MODE_BUTTON_ACTION, (Styleable)this.modeButton));
        UiUtil.setTooltip((Node)this.modeButton, (ObservableValue<? extends String>)tooltipText);
        this.modeButton.selectedProperty().addListener((obj, o, n) -> {
            this.modeButton.setGraphic((Node)new IconNode(n != false ? StandardIconShapes.ROOT_VIEW_12x12 : StandardIconShapes.ROOT_EDIT_12x12, (Styleable)this.modeButton, StandardIconIntentions.ROOT_MODE_BUTTON_ACTION, (Styleable)this.modeButton));
            this.caption.setGraphic((Node)new IconNode(n != false ? StandardIconShapes.ROOT_EDIT_12x12 : StandardIconShapes.ROOT_VIEW_12x12, (Styleable)this.caption, StandardIconIntentions.ROOT_MODE_CAPTION_ACTION, (Styleable)this.caption));
            this.modeButton.setText(n != false ? Messages.General_View : Messages.General_Editor);
            tooltipText.set(n != false ? Messages.General_Go_to_view_mode : Messages.General_Go_to_edit_mode);
        });
        this.modeButton.disableProperty().bind((ObservableValue)new BooleanBinding(){
            {
                this.bind(new Observable[]{RootEntityPane.this.mode, RootEntityPane.this.modControlsDisabled, RootEntityPane.this.getMutex().acquiredProperty()});
            }

            protected boolean computeValue() {
                return RootEntityPane.this.modControlsDisabled.get() || RootEntityPane.this.mode.get() == EditingMode.CREATE || RootEntityPane.this.getMutex().isAcquired();
            }
        });
        this.modeButton.setOnAction(evt -> {
            if (this.modeButton.isSelected()) {
                Notifications.get().submitTask(() -> {
                    this.lockHandler.tryLock(this.data == null || this.data.getContainer() == null ? 0 : this.data.getContainer().getVersionInfo().getVersionNumber());
                    FxUtil.submitToFxThread(() -> {
                        this.updateLockState();
                        if (!this.getMutex().isAcquired()) {
                            this.modeButton.setSelected(false);
                        }
                    });
                    this.reloadData();
                }, this.mutex);
            } else if (this.isDataChanged()) {
                new Dialog().setTitle(Messages.General_Accepting_required).setMessage(Messages.General_Is_saving_required).setSupplmentalMessage((String)this.titleProperty().get()).addButton(DialogButtonStyle.DECLINE, () -> this.modeButton.setSelected(true)).addButton(DialogButtonStyle.AUXILARY, Messages.General_Dont_save, () -> Notifications.get().submitTask(() -> {
                    this.reloadData();
                    this.lockHandler.unLock();
                    FxUtil.submitToFxThread(this::updateLockState);
                }, this.mutex)).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.General_Save, () -> {
                    if (!this.validate()) {
                        this.modeButton.setSelected(true);
                        return;
                    }
                    Notifications.get().submitTask(() -> {
                        this.saveData();
                        this.lockHandler.unLock();
                        FxUtil.submitToFxThread(this::updateLockState);
                    }, this.mutex);
                }).setOnCloseRequest(() -> this.modeButton.setSelected(true)).show((Node)this);
            } else {
                Notifications.get().submitTask(() -> {
                    this.lockHandler.unLock();
                    FxUtil.submitToFxThread(this::updateLockState);
                    this.reloadData();
                }, this.mutex);
            }
        });
        nodes.add(this.modeButton);
        GridPane result = new GridPane();
        result.getStyleClass().add((Object)"editor-header-pane");
        result.addRow(0, nodes.toArray(new Node[nodes.size()]));
        result.setOnMouseClicked(evt -> {
            if (!evt.isAltDown() || evt.getButton() != MouseButton.PRIMARY) {
                return;
            }
            CustomContextMenu menu = new CustomContextMenu();
            menu.getItems().addAll(this.collectAdminTools());
            menu.show((Node)result, evt.getScreenX(), evt.getScreenY());
        });
        return result;
    }

    private void doReload() {
        if (this.mode.get() != EditingMode.VIEW && this.isDataChanged()) {
            new Dialog().setTitle(Messages.General_Accepting_required).setMessage(Messages.General_Is_saving_required).setSupplmentalMessage((String)this.titleProperty().get()).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.AUXILARY, Messages.General_Refresh_without_saving, () -> Notifications.get().submitTask(this::reloadData, this.mutex)).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.General_Save_and_refresh, () -> {
                if (!this.validate()) {
                    return;
                }
                Notifications.get().submitTask(this::saveData, this.mutex);
            }).show((Node)this);
        } else {
            Notifications.get().submitTask(this::reloadData, this.mutex);
        }
    }

    private List<MenuItem> collectAdminTools() {
        CustomMenuItem item;
        ArrayList<MenuItem> result = new ArrayList<MenuItem>();
        if (this.adminController == null) {
            item = new CustomMenuItem("XML content mode");
            item.setOnAction(evt -> {
                if (this.mode.get() != EditingMode.VIEW) {
                    if (this.data == null || this.data.getContainer() == null) {
                        this.data = new DataTransferPackage(new EntityContainer(this.getEntityHandler().getEntityClass()));
                    }
                    this.writeData(this.data);
                }
                this.saveWithCheckPoint = true;
                this.adminController = new ViewController<RawEntityEditor<E>, DataTransferPackage<E, S>>(){
                    private final ViewController rawController;
                    private DataTransferPackage localData;
                    {
                        this.rawController = RawEntityEditor.createContainerController(RootEntityPane.this.getEntityHandler().getEntityClass());
                    }

                    @Override
                    public RawEntityEditor<E> getView() {
                        return (RawEntityEditor)((Object)this.rawController.getView());
                    }

                    @Override
                    public DataTransferPackage<E, S> getData() {
                        return this.localData;
                    }

                    @Override
                    public void readData(DataTransferPackage<E, S> model) {
                        this.localData = model;
                        this.rawController.readData(model.getContainer());
                    }

                    @Override
                    public void writeData(DataTransferPackage<E, S> model) {
                        this.localData = model;
                        this.rawController.writeData(model.getContainer());
                    }

                    @Override
                    public boolean isReadonly() {
                        return this.rawController.isReadonly();
                    }

                    @Override
                    public void setReadonly(boolean readonly) {
                        this.rawController.setReadonly(readonly);
                    }

                    @Override
                    public void setNotEditable(boolean notEditable) {
                        this.rawController.setNotEditable(notEditable);
                    }

                    @Override
                    public void setAclNotEditable(boolean aclNotEditable) {
                        this.rawController.setAclNotEditable(aclNotEditable);
                    }

                    @Override
                    public boolean isDataChanged() {
                        return this.rawController.isDataChanged();
                    }

                    @Override
                    public void validateData(List<Message> messages) {
                        this.rawController.validateData(messages);
                    }
                };
                this.initView();
                if (this.data != null && this.data.getContainer() != null) {
                    this.readData(this.data, null);
                } else {
                    this.updateState();
                }
            });
            result.add((MenuItem)item);
        } else {
            item = new CustomMenuItem("Standard content mode");
            item.setOnAction(evt -> {
                if (this.mode.get() != EditingMode.VIEW) {
                    if (this.data == null || this.data.getContainer() == null) {
                        this.data = new DataTransferPackage(new EntityContainer(this.getEntityHandler().getEntityClass(), this.containerUid));
                    }
                    this.writeData(this.data);
                }
                this.adminController = null;
                this.saveWithCheckPoint = true;
                this.initView();
                if (this.data != null && this.data.getContainer() != null) {
                    this.readData(this.data, null);
                } else {
                    this.updateState();
                }
            });
            result.add((MenuItem)item);
        }
        item = new CustomMenuItem("Entity Container Data");
        item.setOnAction(evt -> {
            RichContentWidget widget = new RichContentWidget(true);
            widget.setFileNameSupplier(() -> this.containerUid + ".xml");
            RichData rd = new RichData();
            rd.setContentType(ContentType.XML);
            if (this.data != null && this.data.getContainer() != null) {
                try {
                    rd.setContent(XSUtil.toByteArray((XSSerializable)this.data.getContainer()));
                }
                catch (Exception e) {
                    ErrorHandler.handle(e);
                    return;
                }
            }
            widget.setData(rd);
            widget.getViewState().setNotEditable(true);
            new Dialog().setTitle("Entity Container Data").setBody((Node)widget).addButton(DialogButtonStyle.DECLINE, "Close").setExpandToParent(true).show((Node)this);
        });
        result.add((MenuItem)item);
        item = new CustomMenuItem("UI Technical Data");
        item.setOnAction(evt -> {
            TextAreaWidget widget = new TextAreaWidget(true);
            widget.setValue(this.buildTechData());
            widget.setMonospace(true);
            widget.getViewState().setNotEditable(true);
            new Dialog().setTitle("Editor UI Technical Data").setBody((Node)widget).addButton(DialogButtonStyle.DECLINE, "Close").setExpandToParent(true).show((Node)this);
        });
        result.add((MenuItem)item);
        item = new CustomMenuItem("Save and Compare Data");
        item.setDisable(this.mode.get() != EditingMode.EDIT);
        item.setOnAction(evt -> Notifications.get().submitTask(() -> {
            DataTransferPackage<E, S> data1 = this.getData();
            this.saveData();
            DataTransferPackage<E, S> data2 = this.getData();
            try {
                ModelCheckUtil.compare(data1.getContainer().getEntity(), data2.getContainer().getEntity());
                Dialog.info((Node)this, "Data matched.");
            }
            catch (ModelCheckUtil.MatchFailedException me) {
                Dialog.message((Node)this, "Data not matched", me.getPath() + "\n\n" + me.getDetails());
            }
        }, this.mutex));
        result.add((MenuItem)item);
        return result;
    }

    private String buildTechData() {
        StringBuilder result = new StringBuilder();
        result.append("Root entity handler class: ").append(this.entityHandler.getClass().getName()).append('\n');
        result.append("Root entity handler ID: ").append(this.entityHandler.getId()).append('\n');
        result.append('\n');
        if (this.data == null) {
            result.append("No data loaded.\n");
        } else {
            result.append("Loaded data container: ").append(this.data.getContainer()).append('\n');
            result.append("Loaded data supplement: ").append(this.data.getSupplement()).append('\n');
        }
        result.append('\n');
        result.append("UI permissions (key, query, granted)\n");
        if (this.lastUiAclCheck != null) {
            for (AclCheckEntry aclCheckEntry : this.lastUiAclCheck) {
                result.append("\t").append(aclCheckEntry.getKey()).append(", ").append(aclCheckEntry.getQuery()).append(", ").append(aclCheckEntry.isGranted()).append('\n');
            }
        } else {
            result.append("\tno data\n");
        }
        result.append('\n');
        result.append("Entity permissions (key, granted)\n");
        if (this.lastEntityAclCheck != null) {
            for (Map.Entry entry : this.lastEntityAclCheck.entrySet()) {
                result.append("\t").append((String)entry.getKey()).append(", ").append(entry.getValue()).append('\n');
            }
        } else {
            result.append("\tno data\n");
        }
        result.append('\n');
        result.append("Actions (ID, title, enabled / disabled, class, key, query, granted)\n");
        Map<String, AclCheckEntry> aclCheckEntries = this.lastActionsAclCheck.stream().collect(Collectors.toMap(item -> item.getKey(), item -> item));
        result.append(DebugUtil.table(this.getActions(), Arrays.asList(DebugUtil.ColumnBuilder.get().name("id").extractor(item -> item.getId()).build(), DebugUtil.ColumnBuilder.get().name("name").extractor(item -> item.getName(this)).build(), DebugUtil.ColumnBuilder.get().name("enabled").extractor(item -> item.isEnabled(this) ? "\u26ab" : "\u26aa").align(DebugUtil.Align.CENTER).build(), DebugUtil.ColumnBuilder.get().name("class").extractor(item -> item.getClass().getName()).build(), DebugUtil.ColumnBuilder.get().name("key").extractor(item -> Optional.ofNullable(aclCheckEntries.get(item.getId())).map(entry -> entry.getKey()).orElse(null)).build(), DebugUtil.ColumnBuilder.get().name("query").extractor(item -> Optional.ofNullable(aclCheckEntries.get(item.getId())).map(entry -> entry.getQuery().toString()).orElse(null)).build(), DebugUtil.ColumnBuilder.get().name("granted").extractor(item -> Optional.ofNullable(aclCheckEntries.get(item.getId())).map(entry -> entry.isGranted() ? "\u26ab" : "\u26aa").orElse(null)).build()), (String)"\t", (DebugUtil.Border)DebugUtil.Border.NONE, (boolean)false));
        result.append('\n').append(DevTools.getStructuredInfo(this.contentPane.getChildren().get(0)));
        return result.toString();
    }

    private void updateLockState() {
        this.previousMode.setValue(this.mode.getValue());
        if (this.lockHandler.isLocked()) {
            if (this.mode.get() != EditingMode.CREATE) {
                this.mode.set((Object)EditingMode.EDIT);
            }
            this.saveWithCheckPoint = true;
        } else {
            this.mode.set((Object)EditingMode.VIEW);
        }
        this.updateState();
    }

    private void updateState() {
        boolean editing;
        boolean bl = editing = this.mode.get() != EditingMode.VIEW;
        if (this.modeButton != null) {
            this.modeButton.setSelected(editing);
        }
        this.setReadonly(!editing);
        this.actionsPane.revalidate();
        Object view = this.getViewController().getView();
        if (view instanceof TilesSpace) {
            ((TilesSpace)view).revalidateActions();
        }
        this.updateDraftState();
    }

    private void updateDraftState() {
        UiUtil.setHidden((Node)this.draftStateLabel, !this.draftState.get());
        if (!this.draftState.get()) {
            return;
        }
        boolean active = this.mode.get() != EditingMode.VIEW;
        Styles.manageStyle((Styleable)this.draftStateLabel, "active", active);
        if (active) {
            this.draftStateLabel.setOnMouseClicked(evt -> PANE_HANDLER.handleDraftStateOff(this));
        } else {
            this.draftStateLabel.setOnMouseClicked(null);
        }
    }

    private void handleLoadError(ContentError error) {
        if (this.isDisposed()) {
            return;
        }
        this.data = null;
        this.dataLoadFailed = true;
        this.composePane(error.createNode(String.format("<p>Handler ID: <code>%s</code><br>Container UID: <code>%s</code></p>", this.entityHandler.getId(), this.containerUid)), null, null, null);
        this.title.set(error.getTitle());
        this.description.set(null);
    }

    private void updateTitle(EntityContainer<E> ctr) {
        String str = this.entityHandler.format(ctr);
        if (TextUtil.isBlank((String)str)) {
            str = Messages.General_Without_name;
        }
        if (this.fixedVersionNumber != null) {
            str = str + ", " + Messages.General_Version + ' ' + (this.fixedVersionNumber + 1);
        }
        this.title.set(str);
        this.description.set(RootEntityHandler.format(this.entityHandler) + ": " + str);
        if (this.isReadOnlyState()) {
            this.description.set(this.description.get() + "   [" + Messages.General_ReadOnly.toUpperCase() + "]");
        }
    }
}

