/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.entity.metadata;

import com.gridnine.xtrip.client.fx.core.entity.metadata.BaseCollectionField;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.LocaleValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.util.ReflectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

class CollectionFieldLocale<E>
extends BaseCollectionField<E> {
    private final TableWidgetController<TableWidget<ValueHolder<Locale>>, ValueHolder<Locale>> controller;

    CollectionFieldLocale(Class<E> entityClass, EntityCollection coll) throws Exception {
        super(entityClass, coll);
        final TableWidget widget = new TableWidget(false);
        widget.setItemsProvider(ValueHolder::new);
        if (List.class.getName().equals(coll.getType())) {
            widget.setControlButtonsAvailability(ControlsPane.ADD_REMOVE_REORDERING);
        }
        ArrayList columns = new ArrayList();
        LocaleValueWidgetColumn<ValueHolder> column = new LocaleValueWidgetColumn<ValueHolder>(ValueHolder::get, ValueHolder::set);
        column.setId("value");
        columns.add(column);
        widget.setColumns(columns);
        this.controller = new TableWidgetController<TableWidget<ValueHolder<Locale>>, ValueHolder<Locale>>(){

            @Override
            public TableWidget<ValueHolder<Locale>> getView() {
                return widget;
            }
        };
    }

    @Override
    void buildUI(List<GridCell<?>> cells, String label) {
        cells.add(GridCell.NEW_ROW_MARKER);
        GridCell cell = new GridCell(label, this.controller.getView());
        cell.setColSpan(Integer.MAX_VALUE);
        cells.add(cell);
    }

    @Override
    void readData(E entity) {
        Collection value = (Collection)ReflectionUtil.getValue((Class)this.cls, entity, (String)this.id);
        if (value != null) {
            this.controller.readData(value.stream().map(ValueHolder::new).collect(Collectors.toList()));
        }
    }

    @Override
    void writeData(E entity) {
        ArrayList list = new ArrayList();
        this.controller.writeData(list);
        Collection value = (Collection)ReflectionUtil.getValue((Class)this.cls, entity, (String)this.id);
        if (value != null) {
            value.clear();
            list.stream().filter(vh -> vh.get() != null).forEach(vh -> value.add(vh.get()));
        }
    }

    @Override
    void setReadonly(boolean readonly) {
        this.controller.setReadonly(readonly);
    }

    @Override
    boolean isDataChanged() {
        return this.controller.isDataChanged();
    }

    @Override
    void setNotEditable(boolean notEditable) {
        ((TableWidget)this.controller.getView()).getViewState().setNotEditable(notEditable);
    }

    @Override
    void setAclNotEditable(boolean aclNotEditable) {
        ((TableWidget)this.controller.getView()).getViewState().setAclNotEditable(aclNotEditable);
    }
}

