/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.entity.metadata;

import com.gridnine.xtrip.client.fx.core.entity.metadata.CollectionFieldDate;
import com.gridnine.xtrip.client.fx.core.entity.metadata.CollectionFieldDict;
import com.gridnine.xtrip.client.fx.core.entity.metadata.CollectionFieldEntityReference;
import com.gridnine.xtrip.client.fx.core.entity.metadata.CollectionFieldEnum;
import com.gridnine.xtrip.client.fx.core.entity.metadata.CollectionFieldLocale;
import com.gridnine.xtrip.client.fx.core.entity.metadata.CollectionFieldMessage;
import com.gridnine.xtrip.client.fx.core.entity.metadata.CollectionFieldSimpleEntity;
import com.gridnine.xtrip.client.fx.core.entity.metadata.CollectionFieldText;
import com.gridnine.xtrip.client.fx.core.entity.metadata.CollectionFieldUnsupported;
import com.gridnine.xtrip.client.fx.core.entity.metadata.MetadataContext;
import com.gridnine.xtrip.client.fx.core.entity.metadata.PropertyFieldBigDecimal;
import com.gridnine.xtrip.client.fx.core.entity.metadata.PropertyFieldBoolean;
import com.gridnine.xtrip.client.fx.core.entity.metadata.PropertyFieldDate;
import com.gridnine.xtrip.client.fx.core.entity.metadata.PropertyFieldDateTime;
import com.gridnine.xtrip.client.fx.core.entity.metadata.PropertyFieldDict;
import com.gridnine.xtrip.client.fx.core.entity.metadata.PropertyFieldDouble;
import com.gridnine.xtrip.client.fx.core.entity.metadata.PropertyFieldEntityReference;
import com.gridnine.xtrip.client.fx.core.entity.metadata.PropertyFieldEnum;
import com.gridnine.xtrip.client.fx.core.entity.metadata.PropertyFieldInt;
import com.gridnine.xtrip.client.fx.core.entity.metadata.PropertyFieldLocalDate;
import com.gridnine.xtrip.client.fx.core.entity.metadata.PropertyFieldLocalDateTime;
import com.gridnine.xtrip.client.fx.core.entity.metadata.PropertyFieldLong;
import com.gridnine.xtrip.client.fx.core.entity.metadata.PropertyFieldNestedEntityReference;
import com.gridnine.xtrip.client.fx.core.entity.metadata.PropertyFieldPassword;
import com.gridnine.xtrip.client.fx.core.entity.metadata.PropertyFieldText;
import com.gridnine.xtrip.client.fx.core.entity.metadata.PropertyFieldUnsupported;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.List;

abstract class EntityField<E> {
    EntityField() {
    }

    static <E> EntityField<E> forProperty(Class<E> entityClass, Property prop) throws Exception {
        switch (prop.getType()) {
            case "String": 
            case "text": {
                if ("true".equals(prop.getParameters().get("password")) || "password".equals(prop.getId())) {
                    return new PropertyFieldPassword<E>(entityClass, prop);
                }
                return new PropertyFieldText<E>(entityClass, prop);
            }
            case "Boolean": 
            case "boolean": {
                return new PropertyFieldBoolean<E>(entityClass, prop);
            }
            case "Double": 
            case "double": {
                return new PropertyFieldDouble<E>(entityClass, prop);
            }
            case "Integer": 
            case "int": {
                return new PropertyFieldInt<E>(entityClass, prop);
            }
            case "Long": 
            case "long": {
                return new PropertyFieldLong<E>(entityClass, prop);
            }
            case "java.math.BigDecimal": {
                return new PropertyFieldBigDecimal<E>(entityClass, prop);
            }
            case "java.util.Date": {
                if (prop.getFormat() != null && prop.getFormat().contains("ss")) {
                    return new PropertyFieldDateTime<E>(entityClass, prop);
                }
                return new PropertyFieldDate<E>(entityClass, prop);
            }
            case "java.time.LocalDate": {
                return new PropertyFieldLocalDate<E>(entityClass, prop);
            }
            case "java.time.LocalDateTime": {
                return new PropertyFieldLocalDateTime<E>(entityClass, prop);
            }
        }
        MetaRegistry metaRegistry = MetaRegistry.get();
        if (metaRegistry.getEnums().containsKey(prop.getType())) {
            return new PropertyFieldEnum<E>(entityClass, prop);
        }
        if (metaRegistry.getDictionaries().containsKey(prop.getType())) {
            return new PropertyFieldDict<E>(entityClass, prop);
        }
        if (metaRegistry.getEntities().containsKey(prop.getType()) && prop.isReference()) {
            return new PropertyFieldEntityReference<E>(entityClass, prop);
        }
        if (NestedEntityReference.class.getName().equals(prop.getType())) {
            String[] classes = prop.getGenerics().split(", ");
            Class root = XSHelper.getClass((String)classes[0]);
            Class nested = XSHelper.getClass((String)classes[1]);
            return new PropertyFieldNestedEntityReference(root, nested, prop);
        }
        return new PropertyFieldUnsupported<E>(entityClass, prop);
    }

    static <E> EntityField<E> forCollection(Class<E> entityClass, EntityCollection coll, MetadataContext ctx) throws Exception {
        switch (coll.getElementType()) {
            case "String": 
            case "text": {
                return new CollectionFieldText<E>(entityClass, coll);
            }
            case "java.util.Locale": {
                return new CollectionFieldLocale<E>(entityClass, coll);
            }
            case "java.util.Date": {
                return new CollectionFieldDate<E>(entityClass, coll);
            }
            case "com.gridnine.xtrip.common.model.system.Message": {
                return new CollectionFieldMessage<E>(entityClass, coll);
            }
        }
        MetaRegistry metaRegistry = MetaRegistry.get();
        if (metaRegistry.getEnums().containsKey(coll.getElementType())) {
            return new CollectionFieldEnum<E>(entityClass, coll);
        }
        if (metaRegistry.getDictionaries().containsKey(coll.getElementType())) {
            return new CollectionFieldDict<E>(entityClass, coll);
        }
        EntityType ett = (EntityType)metaRegistry.getEntities().get(coll.getElementType());
        if (ett != null) {
            if (coll.isReference()) {
                return new CollectionFieldEntityReference<E>(entityClass, coll);
            }
            if (CollectionFieldSimpleEntity.isApplicableTo(ett, ctx)) {
                return new CollectionFieldSimpleEntity<E>(entityClass, coll, ctx);
            }
        }
        return new CollectionFieldUnsupported<E>(entityClass, coll);
    }

    abstract void buildUI(List<GridCell<?>> var1, String var2);

    abstract void readData(E var1);

    abstract void writeData(E var1);

    abstract void setReadonly(boolean var1);

    abstract boolean isDataChanged();

    abstract void setNotEditable(boolean var1);

    abstract void setAclNotEditable(boolean var1);
}

