/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.entity.metadata;

import com.gridnine.xtrip.client.fx.core.entity.metadata.BasePropertyField;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ReflectionUtil;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.List;
import java.util.function.Supplier;

class PropertyFieldEnum<E>
extends BasePropertyField<E> {
    private final ComboBoxWidget<Object> widget = new ComboBoxWidget(false);
    private Object value;

    PropertyFieldEnum(Class<E> entityClass, Property prop) throws Exception {
        super(entityClass, prop);
        Supplier supplier = Suppliers.createEnumSupplier(XSHelper.getClass((String)prop.getType()));
        this.widget.setItemsSupplier(supplier);
        this.widget.setSuggestionsHandler(new SimpleSuggestionsHandler<Object>(this.widget.getConverter(), supplier, this.widget.isSortItems()));
    }

    @Override
    void buildUI(List<GridCell<?>> cells, String label) {
        cells.add(new GridCell<ComboBoxWidget<Object>>(label, this.widget));
    }

    @Override
    void readData(E entity) {
        this.value = ReflectionUtil.getValue((Class)this.cls, entity, (String)this.id);
        this.widget.setValue(this.value);
    }

    @Override
    void writeData(E entity) {
        this.value = this.widget.getValue();
        ReflectionUtil.setValue((Class)this.cls, entity, (String)this.id, (Object)this.value);
    }

    @Override
    void setReadonly(boolean readonly) {
        this.widget.getViewState().setReadonly(readonly);
    }

    @Override
    boolean isDataChanged() {
        return !MiscUtil.equals((Object)this.value, (Object)this.widget.getValue());
    }

    @Override
    void setNotEditable(boolean notEditable) {
        this.widget.getViewState().setNotEditable(notEditable);
    }

    @Override
    void setAclNotEditable(boolean aclNotEditable) {
        this.widget.getViewState().setAclNotEditable(aclNotEditable);
    }
}

