/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.factory;

import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconIntention;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItem;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItemType;
import java.util.Comparator;

public interface FactoryToolCategory
extends RegistryItem<FactoryToolCategory> {
    public static final RegistryItemType<FactoryToolCategory> TYPE = new RegistryItemType("FACTORY-TOOL-CATEGORY");
    public static final Comparator<FactoryToolCategory> COMPARATOR = (category1, category2) -> {
        if (category1.getWeight() != category2.getWeight()) {
            return category1.getWeight() < category2.getWeight() ? -1 : 1;
        }
        return category1.getName().compareTo(category2.getName());
    };

    public static FactoryToolCategory forId(String id) {
        return ClientRegistry.get().allOf(TYPE).get(id);
    }

    @Override
    default public RegistryItemType<FactoryToolCategory> getType() {
        return TYPE;
    }

    default public String getName() {
        String result = ClientRegistry.get().getResourceFor(this, "name");
        return result == null ? this.getId() : result;
    }

    public double getWeight();

    default public IconIntention getIntention() {
        return StandardIconIntentions.FACTORY_TOOLS_BASIC_TAG_ACTION;
    }
}

